/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.governanceaction.handlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineClient;
import org.odpi.openmetadata.accessservices.governanceengine.properties.GovernanceEngineProperties;
import org.odpi.openmetadata.engineservices.governanceaction.context.GovernanceListenerManager;
import org.odpi.openmetadata.engineservices.governanceaction.context.OpenMetadataStoreClient;
import org.odpi.openmetadata.engineservices.governanceaction.ffdc.GovernanceActionAuditCode;
import org.odpi.openmetadata.engineservices.governanceaction.ffdc.GovernanceActionErrorCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceActionContext;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceActionServiceConnector;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.ProvisioningGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.RemediationGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.TriageGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.VerificationGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.WatchdogGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RequestSourceElement;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceServiceHandler;

public class GovernanceActionServiceHandler
extends GovernanceServiceHandler {
    private GovernanceActionServiceConnector governanceActionService;
    private String governanceActionServiceType;
    private GovernanceContext governanceContext;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    GovernanceActionServiceHandler(GovernanceEngineProperties governanceActionEngineProperties, String governanceActionEngineGUID, String governanceActionUserId, String governanceActionGUID, GovernanceEngineClient governanceActionClient, String requestType, Map<String, String> requestParameters, List<RequestSourceElement> requestSourceElements, List<ActionTargetElement> actionTargetElements, String governanceActionServiceGUID, String governanceActionServiceName, Connector governanceActionServiceConnector, String partnerServerName, String partnerServerPlatformURLRoot, GovernanceEngineClient governanceEngineClient, GovernanceListenerManager governanceListenerManager, AuditLog auditLog) throws InvalidParameterException {
        super(governanceActionEngineProperties, governanceActionEngineGUID, governanceActionUserId, governanceActionGUID, governanceActionClient, requestType, governanceActionServiceGUID, governanceActionServiceName, governanceActionServiceConnector, auditLog);
        String actionDescription = "Initializing GovernanceActionService";
        String governanceActionServiceConnectorParameterName = "governanceActionServiceConnector";
        String genericGovernanceActionServiceType = "GovernanceActionService";
        String watchdogGovernanceActionServiceType = "WatchdogGovernanceActionService";
        String provisioningGovernanceActionServiceType = "ProvisioningGovernanceActionService";
        String verificationGovernanceActionServiceType = "VerificationGovernanceActionService";
        String triageGovernanceActionServiceType = "TriageGovernanceActionService";
        String remediationGovernanceActionServiceType = "RemediationGovernanceActionService";
        try {
            OpenMetadataStoreClient openMetadataClient = new OpenMetadataStoreClient(partnerServerName, partnerServerPlatformURLRoot, governanceEngineClient, governanceListenerManager, this, governanceActionUserId);
            if (!(governanceActionServiceConnector instanceof GovernanceActionServiceConnector)) {
                auditLog.logMessage("Initializing GovernanceActionService", GovernanceActionAuditCode.NOT_GOVERNANCE_ACTION_SERVICE.getMessageDefinition(new String[]{governanceActionServiceName, requestType, governanceActionServiceConnector.getClass().getName()}));
                throw new InvalidParameterException(GovernanceActionErrorCode.NOT_GOVERNANCE_ACTION_SERVICE.getMessageDefinition(new String[]{governanceActionServiceName, requestType, governanceActionServiceConnector.getClass().getName()}), ((Object)((Object)this)).getClass().getName(), "Initializing GovernanceActionService", "governanceActionServiceConnector");
            }
            GovernanceActionContext context = new GovernanceActionContext(governanceActionUserId, governanceActionGUID, requestType, requestParameters, requestSourceElements, actionTargetElements, (OpenMetadataClient)openMetadataClient);
            GovernanceActionServiceConnector service = (GovernanceActionServiceConnector)governanceActionServiceConnector;
            service.setGovernanceContext(context);
            service.setAuditLog(auditLog);
            service.setGovernanceServiceName(this.governanceServiceName);
            this.governanceContext = context;
            this.governanceActionService = service;
            if (governanceActionServiceConnector instanceof GovernanceActionService) {
                this.governanceActionServiceType = "GovernanceActionService";
            } else if (governanceActionServiceConnector instanceof WatchdogGovernanceActionService) {
                this.governanceActionServiceType = "WatchdogGovernanceActionService";
            } else if (governanceActionServiceConnector instanceof VerificationGovernanceActionService) {
                this.governanceActionServiceType = "VerificationGovernanceActionService";
            } else if (governanceActionServiceConnector instanceof TriageGovernanceActionService) {
                this.governanceActionServiceType = "TriageGovernanceActionService";
            } else if (governanceActionServiceConnector instanceof RemediationGovernanceActionService) {
                this.governanceActionServiceType = "RemediationGovernanceActionService";
            } else {
                if (!(governanceActionServiceConnector instanceof ProvisioningGovernanceActionService)) {
                    auditLog.logMessage("Initializing GovernanceActionService", GovernanceActionAuditCode.UNKNOWN_GOVERNANCE_ACTION_SERVICE.getMessageDefinition(new String[]{governanceActionServiceName, requestType, governanceActionServiceConnector.getClass().getName()}));
                    throw new InvalidParameterException(GovernanceActionErrorCode.UNKNOWN_GOVERNANCE_ACTION_SERVICE.getMessageDefinition(new String[]{governanceActionServiceName, requestType, governanceActionServiceConnector.getClass().getName()}), ((Object)((Object)this)).getClass().getName(), "Initializing GovernanceActionService", "governanceActionServiceConnector");
                }
                this.governanceActionServiceType = "ProvisioningGovernanceActionService";
            }
            auditLog.logMessage("Initializing GovernanceActionService", GovernanceActionAuditCode.GOVERNANCE_ACTION_INITIALIZED.getMessageDefinition(new String[]{governanceActionServiceName, requestType, governanceActionServiceConnector.getClass().getName(), this.getGovernanceEngineName()}));
            return;
        }
        catch (InvalidParameterException error) {
            throw error;
        }
        catch (Exception error) {
            auditLog.logException("Initializing GovernanceActionService", GovernanceActionAuditCode.INVALID_GOVERNANCE_ACTION_SERVICE.getMessageDefinition(new String[]{governanceActionServiceName, requestType, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            throw new InvalidParameterException(GovernanceActionErrorCode.INVALID_GOVERNANCE_ACTION_SERVICE.getMessageDefinition(new String[]{governanceActionServiceName, requestType, error.getClass().getName(), error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "Initializing GovernanceActionService", (Throwable)error, "governanceActionServiceConnector");
        }
    }

    public void run() {
        String actionDescription = "Run governance service";
        try {
            this.auditLog.logMessage("Run governance service", GovernanceActionAuditCode.GOVERNANCE_ACTION_SERVICE_STARTING.getMessageDefinition(new String[]{this.governanceActionServiceType, this.governanceServiceName, this.requestType, this.governanceEngineProperties.getQualifiedName(), this.governanceEngineGUID}));
            Date startTime = new Date();
            this.governanceActionService.start();
            Date endTime = new Date();
            CompletionStatus completionStatus = this.governanceContext.getCompletionStatus();
            if (completionStatus == null) {
                this.auditLog.logMessage("Run governance service", GovernanceActionAuditCode.GOVERNANCE_ACTION_SERVICE_RETURNED.getMessageDefinition(new String[]{this.governanceActionServiceType, this.governanceServiceName, this.requestType}));
            } else {
                this.auditLog.logMessage("Run governance service", GovernanceActionAuditCode.GOVERNANCE_ACTION_SERVICE_COMPLETE.getMessageDefinition(new String[]{this.governanceActionServiceType, this.governanceServiceName, this.requestType, completionStatus.getName(), Long.toString(endTime.getTime() - startTime.getTime())}));
                super.disconnect();
            }
        }
        catch (Exception error) {
            this.auditLog.logException("Run governance service", GovernanceActionAuditCode.GOVERNANCE_ACTION_SERVICE_FAILED.getMessageDefinition(new String[]{this.governanceActionServiceType, this.governanceServiceName, error.getClass().getName(), this.governanceEngineProperties.getQualifiedName(), this.governanceEngineGUID, error.getMessage()}), error.toString(), (Throwable)error);
            try {
                CompletionStatus completionStatus = this.governanceContext.getCompletionStatus();
                if (completionStatus == null) {
                    this.governanceContext.recordCompletionStatus(CompletionStatus.FAILED, null);
                    super.disconnect();
                }
            }
            catch (Exception statusError) {
                this.auditLog.logException("Run governance service", GovernanceActionAuditCode.EXC_ON_ERROR_STATUS_UPDATE.getMessageDefinition(new String[]{this.governanceEngineProperties.getDisplayName(), this.governanceServiceName, statusError.getClass().getName(), statusError.getMessage()}), statusError.toString(), (Throwable)statusError);
            }
        }
    }
}

