/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.governanceaction.context;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineClient;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.engineservices.governanceaction.context.GovernanceListenerManager;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.WatchdogGovernanceListener;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogEventType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IncidentDependency;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IncidentImpactedElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElements;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchClassifications;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.SequencingOrder;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceServiceHandler;

public class OpenMetadataStoreClient
extends OpenMetadataClient {
    private final String engineUserId;
    private final String connectorId = UUID.randomUUID().toString();
    private final GovernanceEngineClient governanceEngineClient;
    private final GovernanceListenerManager governanceListenerManager;
    private final GovernanceServiceHandler governanceServiceHandler;

    public OpenMetadataStoreClient(String serverName, String serverPlatformURLRoot, GovernanceEngineClient governanceEngineClient, GovernanceListenerManager governanceListenerManager, GovernanceServiceHandler governanceServiceHandler, String engineUserId) throws InvalidParameterException {
        super(serverPlatformURLRoot, serverName);
        String methodName = "Constructor (no security)";
        InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
        invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        invalidParameterHandler.validateUserId(engineUserId, "Constructor (no security)");
        this.governanceEngineClient = governanceEngineClient;
        this.governanceListenerManager = governanceListenerManager;
        this.governanceServiceHandler = governanceServiceHandler;
        this.engineUserId = engineUserId;
    }

    public OpenMetadataElement getMetadataElementByGUID(String elementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceEngineClient.getMetadataElementByGUID(this.engineUserId, elementGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public OpenMetadataElement getMetadataElementByUniqueName(String uniqueName, String uniquePropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceEngineClient.getMetadataElementByUniqueName(this.engineUserId, uniqueName, uniquePropertyName, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public String getMetadataElementGUIDByUniqueName(String uniqueName, String uniquePropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceEngineClient.getMetadataElementGUIDByUniqueName(this.engineUserId, uniqueName, uniquePropertyName, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public List<OpenMetadataElement> findMetadataElementsWithString(String searchString, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceEngineClient.findMetadataElementsWithString(this.engineUserId, searchString, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<RelatedMetadataElement> getRelatedMetadataElements(String elementGUID, int startingAtEnd, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceEngineClient.getRelatedMetadataElements(this.engineUserId, elementGUID, startingAtEnd, relationshipTypeName, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> findMetadataElements(String metadataElementTypeName, List<String> metadataElementSubtypeName, SearchProperties searchProperties, List<ElementStatus> limitResultsByStatus, SearchClassifications matchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceEngineClient.findMetadataElements(this.engineUserId, metadataElementTypeName, metadataElementSubtypeName, searchProperties, limitResultsByStatus, matchClassifications, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<RelatedMetadataElements> findRelationshipsBetweenMetadataElements(String relationshipTypeName, SearchProperties searchProperties, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceEngineClient.findRelationshipsBetweenMetadataElements(this.engineUserId, relationshipTypeName, searchProperties, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public String createMetadataElementInStore(String metadataElementTypeName, ElementStatus initialStatus, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String templateGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceEngineClient.createMetadataElementInStore(this.engineUserId, metadataElementTypeName, initialStatus, effectiveFrom, effectiveTo, properties, templateGUID);
    }

    public void updateMetadataElementInStore(String metadataElementGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceEngineClient.updateMetadataElementInStore(this.engineUserId, metadataElementGUID, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    public void updateMetadataElementStatusInStore(String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, ElementStatus newElementStatus, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceEngineClient.updateMetadataElementStatusInStore(this.engineUserId, metadataElementGUID, forLineage, forDuplicateProcessing, newElementStatus, effectiveTime);
    }

    public void updateMetadataElementEffectivityInStore(String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceEngineClient.updateMetadataElementEffectivityInStore(this.engineUserId, metadataElementGUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    public void deleteMetadataElementInStore(String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceEngineClient.deleteMetadataElementInStore(this.engineUserId, metadataElementGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void classifyMetadataElementInStore(String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceEngineClient.classifyMetadataElementInStore(this.engineUserId, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, properties, effectiveTime);
    }

    public void reclassifyMetadataElementInStore(String metadataElementGUID, String classificationName, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceEngineClient.reclassifyMetadataElementInStore(this.engineUserId, metadataElementGUID, classificationName, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    public void updateClassificationEffectivityInStore(String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceEngineClient.updateClassificationEffectivityInStore(this.engineUserId, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    public void unclassifyMetadataElementInStore(String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceEngineClient.unclassifyMetadataElementInStore(this.engineUserId, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public String createRelatedElementsInStore(String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceEngineClient.createRelatedElementsInStore(this.engineUserId, relationshipTypeName, metadataElement1GUID, metadataElement2GUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, properties, effectiveTime);
    }

    public void updateRelatedElementsInStore(String relationshipGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceEngineClient.updateRelatedElementsInStore(this.engineUserId, relationshipGUID, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    public void updateRelatedElementsEffectivityInStore(String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceEngineClient.updateRelatedElementsEffectivityInStore(this.engineUserId, relationshipGUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    public void deleteRelatedElementsInStore(String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceEngineClient.deleteRelatedElementsInStore(this.engineUserId, relationshipGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void updateActionTargetStatus(String actionTargetGUID, GovernanceActionStatus status, Date startDate, Date completionDate, String completionMessage) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceServiceHandler.updateActionTargetStatus(actionTargetGUID, status, startDate, completionDate, completionMessage);
    }

    public void recordCompletionStatus(CompletionStatus status, List<String> outputGuards, Map<String, String> requestParameters, List<NewActionTarget> newActionTargets, String completionMessage) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceServiceHandler.recordCompletionStatus(status, outputGuards, requestParameters, newActionTargets, completionMessage);
    }

    public String initiateGovernanceAction(String qualifiedName, int domainIdentifier, String displayName, String description, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Date startTime, String governanceEngineName, String requestType, Map<String, String> requestParameters, String processName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceEngineClient.initiateGovernanceAction(this.engineUserId, qualifiedName, domainIdentifier, displayName, description, requestSourceGUIDs, actionTargets, null, startTime, governanceEngineName, requestType, requestParameters, processName, null, this.governanceServiceHandler.getGovernanceServiceName(), this.governanceServiceHandler.getGovernanceEngineName());
    }

    public String initiateGovernanceActionProcess(String processQualifiedName, Map<String, String> requestParameters, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Date startTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceEngineClient.initiateGovernanceActionProcess(this.engineUserId, processQualifiedName, requestSourceGUIDs, actionTargets, startTime, requestParameters, this.governanceServiceHandler.getGovernanceServiceName(), this.governanceServiceHandler.getGovernanceEngineName());
    }

    public String createIncidentReport(String qualifiedName, int domainIdentifier, String background, List<IncidentImpactedElement> impactedResources, List<IncidentDependency> previousIncidents, Map<String, Integer> incidentClassifiers, Map<String, String> additionalProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceEngineClient.createIncidentReport(this.engineUserId, qualifiedName, domainIdentifier, background, impactedResources, previousIncidents, incidentClassifiers, additionalProperties, this.governanceServiceHandler.getGovernanceServiceGUID());
    }

    public void linkElementsAsPeerDuplicates(String metadataElement1GUID, String metadataElement2GUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, boolean setKnownDuplicate) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceEngineClient.linkElementsAsPeerDuplicates(this.engineUserId, metadataElement1GUID, metadataElement2GUID, statusIdentifier, steward, stewardTypeName, stewardPropertyName, source, notes, setKnownDuplicate);
    }

    public void linkConsolidatedDuplicate(String consolidatedElementGUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, List<String> sourceElementGUIDs) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceEngineClient.linkConsolidatedDuplicate(this.engineUserId, consolidatedElementGUID, statusIdentifier, steward, stewardTypeName, stewardPropertyName, source, notes, sourceElementGUIDs);
    }

    public void registerListener(WatchdogGovernanceListener listener, List<WatchdogEventType> interestingEventTypes, List<String> interestingMetadataTypes, String specificInstance) throws InvalidParameterException {
        this.governanceListenerManager.registerListener(this.connectorId, listener, interestingEventTypes, interestingMetadataTypes, specificInstance);
    }

    public void disconnectListener() {
        this.governanceListenerManager.removeListener(this.connectorId);
    }
}

