/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.governanceaction.handlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineClient;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceDescription;
import org.odpi.openmetadata.engineservices.governanceaction.context.GovernanceListenerManager;
import org.odpi.openmetadata.engineservices.governanceaction.handlers.GovernanceActionServiceHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogGovernanceEvent;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RequestSourceElement;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceEngineHandler;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceServiceCache;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceServiceHandler;

public class GovernanceActionEngineHandler
extends GovernanceEngineHandler {
    private final GovernanceEngineClient governanceEngineClient;
    private final GovernanceListenerManager governanceListenerManager;
    private final String partnerURLRoot;
    private final String partnerServerName;
    private static final String supportGovernanceEngineType = "GovernanceActionEngine";

    public GovernanceActionEngineHandler(EngineConfig engineConfig, String localServerName, String partnerServerName, String partnerURLRoot, String serverUserId, GovernanceEngineConfigurationClient configurationClient, GovernanceEngineClient serverClient, GovernanceEngineClient governanceEngineClient, AuditLog auditLog, int maxPageSize) {
        super(engineConfig, localServerName, serverUserId, EngineServiceDescription.GOVERNANCE_ACTION_OMES.getEngineServiceFullName(), configurationClient, serverClient, auditLog, maxPageSize);
        this.governanceEngineClient = governanceEngineClient;
        this.partnerServerName = partnerServerName;
        this.partnerURLRoot = partnerURLRoot;
        this.governanceListenerManager = new GovernanceListenerManager(auditLog, engineConfig.getEngineQualifiedName());
    }

    public void publishWatchdogEvent(WatchdogGovernanceEvent watchdogGovernanceEvent) throws InvalidParameterException {
        this.governanceListenerManager.processEvent(watchdogGovernanceEvent);
    }

    public GovernanceServiceHandler runGovernanceService(String governanceActionGUID, String governanceRequestType, Date startDate, Map<String, String> requestParameters, List<RequestSourceElement> requestSourceElements, List<ActionTargetElement> actionTargetElements) throws InvalidParameterException, PropertyServerException {
        String methodName = "runGovernanceService";
        super.validateGovernanceEngineInitialized(supportGovernanceEngineType, "runGovernanceService");
        GovernanceServiceCache governanceServiceCache = super.getServiceCache(governanceRequestType);
        if (governanceServiceCache != null) {
            GovernanceActionServiceHandler governanceActionServiceHandler = new GovernanceActionServiceHandler(this.governanceEngineProperties, this.governanceEngineGUID, this.serverUserId, governanceActionGUID, this.serverClient, governanceServiceCache.getServiceRequestType(), governanceServiceCache.getRequestParameters(requestParameters), requestSourceElements, actionTargetElements, governanceServiceCache.getGovernanceServiceGUID(), governanceServiceCache.getGovernanceServiceName(), governanceServiceCache.getNextGovernanceService(), this.partnerServerName, this.partnerURLRoot, this.governanceEngineClient, this.governanceListenerManager, this.auditLog);
            Thread thread = new Thread((Runnable)((Object)governanceActionServiceHandler), governanceServiceCache.getGovernanceServiceName() + governanceActionGUID + new Date());
            thread.start();
            return governanceActionServiceHandler;
        }
        return null;
    }
}

