/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.governanceaction.admin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineClient;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineConfigurationClient;
import org.odpi.openmetadata.accessservices.governanceengine.client.rest.GovernanceEngineRESTClient;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.engineservices.governanceaction.ffdc.GovernanceActionAuditCode;
import org.odpi.openmetadata.engineservices.governanceaction.ffdc.GovernanceActionErrorCode;
import org.odpi.openmetadata.engineservices.governanceaction.handlers.GovernanceActionEngineHandler;
import org.odpi.openmetadata.engineservices.governanceaction.server.GovernanceActionInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.EngineServiceAdmin;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceEngineHandler;

public class GovernanceActionAdmin
extends EngineServiceAdmin {
    private GovernanceActionInstance governanceActionInstance = null;

    public Map<String, GovernanceEngineHandler> initialize(String localServerId, String localServerName, AuditLog auditLog, String localServerUserId, String localServerPassword, int maxPageSize, GovernanceEngineConfigurationClient configurationClient, GovernanceEngineClient serverClient, EngineServiceConfig engineServiceConfig) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize engine service";
        String methodName = "initialize";
        this.auditLog = auditLog;
        this.localServerName = localServerName;
        auditLog.logMessage("initialize engine service", GovernanceActionAuditCode.ENGINE_SERVICE_INITIALIZING.getMessageDefinition(new String[]{localServerName}));
        try {
            GovernanceEngineClient governanceEngineClient;
            this.validateConfigDocument(engineServiceConfig);
            String accessServiceRootURL = this.getPartnerServiceRootURL(engineServiceConfig);
            String accessServiceServerName = this.getPartnerServiceServerName(engineServiceConfig);
            List governanceActionEngines = this.getEngines(engineServiceConfig);
            try {
                GovernanceEngineRESTClient restClient = localServerName != null && localServerPassword != null ? new GovernanceEngineRESTClient(accessServiceServerName, accessServiceRootURL, localServerUserId, localServerPassword) : new GovernanceEngineRESTClient(accessServiceServerName, accessServiceRootURL);
                governanceEngineClient = new GovernanceEngineClient(accessServiceServerName, accessServiceRootURL, restClient, maxPageSize);
            }
            catch (InvalidParameterException error) {
                throw new OMAGConfigurationErrorException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
            }
            Map<String, GovernanceActionEngineHandler> governanceActionEngineHandlers = this.getGovernanceActionEngineHandlers(governanceActionEngines, accessServiceRootURL, accessServiceServerName, localServerUserId, configurationClient, serverClient, governanceEngineClient, maxPageSize);
            if (governanceActionEngineHandlers == null) {
                auditLog.logMessage("initialize engine service", GovernanceActionAuditCode.NO_GOVERNANCE_ACTION_ENGINES_STARTED.getMessageDefinition(new String[]{localServerName}));
                throw new OMAGConfigurationErrorException(GovernanceActionErrorCode.NO_GOVERNANCE_ACTION_ENGINES_STARTED.getMessageDefinition(new String[]{localServerName}), ((Object)((Object)this)).getClass().getName(), "initialize");
            }
            this.governanceActionInstance = new GovernanceActionInstance(localServerName, EngineServiceDescription.GOVERNANCE_ACTION_OMES.getEngineServiceName(), auditLog, localServerUserId, maxPageSize, engineServiceConfig.getOMAGServerPlatformRootURL(), engineServiceConfig.getOMAGServerName(), governanceActionEngineHandlers);
            HashMap<String, GovernanceEngineHandler> governanceEngineHandlers = new HashMap<String, GovernanceEngineHandler>();
            for (String engineName : governanceActionEngineHandlers.keySet()) {
                if (engineName == null) continue;
                governanceEngineHandlers.put(engineName, governanceActionEngineHandlers.get(engineName));
            }
            return governanceEngineHandlers;
        }
        catch (Exception error) {
            auditLog.logException("initialize engine service", GovernanceActionAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{localServerName, error.getMessage()}), error.toString(), (Throwable)error);
            throw new OMAGConfigurationErrorException(GovernanceActionErrorCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{localServerName, error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "initialize", (Throwable)error);
        }
    }

    private Map<String, GovernanceActionEngineHandler> getGovernanceActionEngineHandlers(List<EngineConfig> governanceActionEngines, String accessServiceRootURL, String accessServiceServerName, String localServerUserId, GovernanceEngineConfigurationClient configurationClient, GovernanceEngineClient serverClient, GovernanceEngineClient governanceEngineClient, int maxPageSize) {
        HashMap<String, GovernanceActionEngineHandler> governanceActionEngineHandlers = new HashMap<String, GovernanceActionEngineHandler>();
        for (EngineConfig governanceActionEngine : governanceActionEngines) {
            if (governanceActionEngine == null) continue;
            GovernanceActionEngineHandler handler = new GovernanceActionEngineHandler(governanceActionEngine, this.localServerName, accessServiceServerName, accessServiceRootURL, localServerUserId, configurationClient, serverClient, governanceEngineClient, this.auditLog, maxPageSize);
            governanceActionEngineHandlers.put(governanceActionEngine.getEngineQualifiedName(), handler);
        }
        if (governanceActionEngineHandlers.isEmpty()) {
            return null;
        }
        return governanceActionEngineHandlers;
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        this.auditLog.logMessage("shutdown", GovernanceActionAuditCode.SERVER_SHUTTING_DOWN.getMessageDefinition(new String[]{this.localServerName}));
        this.governanceActionInstance.shutdown();
        this.auditLog.logMessage("shutdown", GovernanceActionAuditCode.SERVER_SHUTDOWN.getMessageDefinition(new String[]{this.localServerName}));
    }
}

