/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.governanceaction.admin;

import org.odpi.openmetadata.accessservices.governanceengine.api.GovernanceEngineEventListener;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineEventClient;
import org.odpi.openmetadata.accessservices.governanceengine.client.rest.GovernanceEngineRESTClient;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceEngineConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.engineservices.governanceaction.ffdc.GovernanceActionAuditCode;
import org.odpi.openmetadata.engineservices.governanceaction.ffdc.GovernanceActionErrorCode;
import org.odpi.openmetadata.engineservices.governanceaction.listener.GovernanceEngineOutTopicListener;
import org.odpi.openmetadata.engineservices.governanceaction.server.GovernanceActionInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.EngineServiceAdmin;
import org.odpi.openmetadata.governanceservers.enginehostservices.enginemap.GovernanceEngineMap;

public class GovernanceActionAdmin
extends EngineServiceAdmin {
    private GovernanceActionInstance governanceActionInstance = null;

    public void initialize(String localServerId, String localServerName, AuditLog auditLog, String localServerUserId, String localServerPassword, int maxPageSize, GovernanceEngineConfigurationClient configurationClient, EngineServiceConfig engineServiceConfig, GovernanceEngineMap governanceEngineMap) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize engine service";
        String methodName = "initialize";
        this.auditLog = auditLog;
        this.localServerName = localServerName;
        try {
            this.validateConfigDocument(engineServiceConfig);
            String accessServiceRootURL = this.getPartnerServiceRootURL(engineServiceConfig);
            String accessServiceServerName = this.getPartnerServiceServerName(engineServiceConfig);
            auditLog.logMessage("initialize engine service", GovernanceActionAuditCode.ENGINE_SERVICE_INITIALIZING.getMessageDefinition(new String[]{localServerName, accessServiceServerName, accessServiceRootURL}));
            governanceEngineMap.setGovernanceEngineProperties(engineServiceConfig.getEngines(), accessServiceServerName, accessServiceRootURL);
            this.governanceActionInstance = new GovernanceActionInstance(localServerName, EngineServiceDescription.GOVERNANCE_ACTION_OMES.getEngineServiceName(), auditLog, localServerUserId, maxPageSize, engineServiceConfig.getOMAGServerPlatformRootURL(), engineServiceConfig.getOMAGServerName());
            GovernanceEngineRESTClient governanceEngineRESTClient = localServerPassword != null ? new GovernanceEngineRESTClient(accessServiceServerName, accessServiceRootURL, localServerUserId, localServerPassword, auditLog) : new GovernanceEngineRESTClient(accessServiceServerName, accessServiceRootURL, auditLog);
            GovernanceEngineEventClient eventClient = new GovernanceEngineEventClient(accessServiceServerName, accessServiceRootURL, governanceEngineRESTClient, maxPageSize, auditLog, localServerId);
            eventClient.registerListener(localServerUserId, (GovernanceEngineEventListener)new GovernanceEngineOutTopicListener(governanceEngineMap, auditLog));
        }
        catch (Exception error) {
            auditLog.logException("initialize engine service", GovernanceActionAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{localServerName, error.getMessage()}), error.toString(), (Throwable)error);
            throw new OMAGConfigurationErrorException(GovernanceActionErrorCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{localServerName, error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "initialize", (Throwable)error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        this.auditLog.logMessage("shutdown", GovernanceActionAuditCode.SERVER_SHUTTING_DOWN.getMessageDefinition(new String[]{this.localServerName}));
        this.governanceActionInstance.shutdown();
        this.auditLog.logMessage("shutdown", GovernanceActionAuditCode.SERVER_SHUTDOWN.getMessageDefinition(new String[]{this.localServerName}));
    }
}

