/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.governanceaction.listener;

import org.odpi.openmetadata.accessservices.governanceengine.api.GovernanceEngineEventListener;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceEngineEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.WatchdogGovernanceServiceEvent;
import org.odpi.openmetadata.engineservices.governanceaction.ffdc.GovernanceActionAuditCode;
import org.odpi.openmetadata.engineservices.governanceaction.handlers.GovernanceActionEngineHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogGovernanceEvent;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceEngineHandler;
import org.odpi.openmetadata.governanceservers.enginehostservices.enginemap.GovernanceEngineMap;

public class GovernanceEngineOutTopicListener
extends GovernanceEngineEventListener {
    private final GovernanceEngineMap governanceEngineHandlers;
    private final AuditLog auditLog;

    public GovernanceEngineOutTopicListener(GovernanceEngineMap governanceEngineHandlers, AuditLog auditLog) {
        this.governanceEngineHandlers = governanceEngineHandlers;
        this.auditLog = auditLog;
    }

    public void processEvent(GovernanceEngineEvent event) {
        WatchdogGovernanceServiceEvent watchdogGovernanceServiceEvent;
        String actionDescription = "Process OutTopic event";
        if (event != null && event instanceof WatchdogGovernanceServiceEvent && (watchdogGovernanceServiceEvent = (WatchdogGovernanceServiceEvent)event).getWatchdogGovernanceEvent() != null) {
            WatchdogGovernanceEvent watchdogGovernanceEvent = watchdogGovernanceServiceEvent.getWatchdogGovernanceEvent();
            for (GovernanceEngineHandler governanceEngineHandler : this.governanceEngineHandlers.getGovernanceEngineHandlers()) {
                if (!(governanceEngineHandler instanceof GovernanceActionEngineHandler)) continue;
                GovernanceActionEngineHandler governanceActionEngineHandler = (GovernanceActionEngineHandler)governanceEngineHandler;
                try {
                    governanceActionEngineHandler.publishWatchdogEvent(watchdogGovernanceEvent);
                }
                catch (Exception error) {
                    this.auditLog.logException("Process OutTopic event", GovernanceActionAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), "Process OutTopic event", error.getMessage()}), (Throwable)error);
                }
            }
        }
    }
}

