/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.governanceaction.handlers;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceContextClient;
import org.odpi.openmetadata.accessservices.governanceserver.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.engineservices.governanceaction.ffdc.GovernanceActionAuditCode;
import org.odpi.openmetadata.engineservices.governanceaction.ffdc.GovernanceActionErrorCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.governanceaction.GeneralGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceActionContext;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceActionServiceConnector;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.ProvisioningGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.RemediationGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.TriageGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.VerificationGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.WatchdogGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.client.ActionControlInterface;
import org.odpi.openmetadata.frameworks.governanceaction.client.DuplicateManagementInterface;
import org.odpi.openmetadata.frameworks.governanceaction.client.GovernanceActionProcessInterface;
import org.odpi.openmetadata.frameworks.governanceaction.client.GovernanceCompletionInterface;
import org.odpi.openmetadata.frameworks.governanceaction.client.GovernanceConfiguration;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.client.WatchDogEventInterface;
import org.odpi.openmetadata.frameworks.governanceaction.controls.Guard;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceEngineProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RequestSourceElement;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceServiceHandler;

public class GovernanceActionServiceHandler
extends GovernanceServiceHandler {
    private final GovernanceActionServiceConnector governanceActionService;
    private final String governanceActionServiceType;
    private final GovernanceContext governanceContext;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    GovernanceActionServiceHandler(GovernanceEngineProperties governanceActionEngineProperties, String governanceActionEngineGUID, String governanceActionUserId, String engineActionGUID, GovernanceContextClient engineActionClient, String serviceRequestType, Map<String, String> requestParameters, String requesterUserId, List<RequestSourceElement> requestSourceElements, List<ActionTargetElement> actionTargetElements, String governanceActionServiceGUID, String governanceActionServiceName, Connector governanceActionServiceConnector, String partnerServerName, String partnerServerPlatformURLRoot, GovernanceContextClient governanceContextClient, GovernanceConfiguration governanceConfiguration, Date startDate, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(governanceActionEngineProperties, governanceActionEngineGUID, governanceActionUserId, engineActionGUID, engineActionClient, serviceRequestType, governanceActionServiceGUID, governanceActionServiceName, governanceActionServiceConnector, startDate, auditLog);
        String actionDescription = "Initializing GeneralGovernanceActionService";
        String governanceActionServiceConnectorParameterName = "governanceActionServiceConnector";
        String genericGovernanceActionServiceType = "General";
        String watchdogGovernanceActionServiceType = "Watchdog";
        String provisioningGovernanceActionServiceType = "Provisioning";
        String verificationGovernanceActionServiceType = "Verification";
        String triageGovernanceActionServiceType = "Triage";
        String remediationGovernanceActionServiceType = "Remediation";
        try {
            OpenMetadataStoreClient openMetadataClient = new OpenMetadataStoreClient(partnerServerName, partnerServerPlatformURLRoot, maxPageSize);
            if (!(governanceActionServiceConnector instanceof GovernanceActionServiceConnector)) {
                auditLog.logMessage("Initializing GeneralGovernanceActionService", GovernanceActionAuditCode.NOT_GOVERNANCE_ACTION_SERVICE.getMessageDefinition(new String[]{governanceActionServiceName, serviceRequestType, governanceActionServiceConnector.getClass().getName()}));
                throw new InvalidParameterException(GovernanceActionErrorCode.NOT_GOVERNANCE_ACTION_SERVICE.getMessageDefinition(new String[]{governanceActionServiceName, serviceRequestType, governanceActionServiceConnector.getClass().getName()}), ((Object)((Object)this)).getClass().getName(), "Initializing GeneralGovernanceActionService", "governanceActionServiceConnector");
            }
            GovernanceActionServiceConnector service = (GovernanceActionServiceConnector)governanceActionServiceConnector;
            GovernanceActionContext context = new GovernanceActionContext(governanceActionUserId, engineActionGUID, serviceRequestType, requestParameters, requesterUserId, requestSourceElements, actionTargetElements, (OpenMetadataClient)openMetadataClient, governanceConfiguration, (ActionControlInterface)governanceContextClient, (DuplicateManagementInterface)governanceContextClient, (GovernanceActionProcessInterface)governanceContextClient, (GovernanceCompletionInterface)governanceContextClient, (WatchDogEventInterface)governanceContextClient);
            service.setGovernanceContext(context);
            service.setAuditLog(auditLog);
            service.setGovernanceServiceName(this.governanceServiceName);
            this.governanceContext = context;
            this.governanceActionService = service;
            if (governanceActionServiceConnector instanceof GeneralGovernanceActionService) {
                this.governanceActionServiceType = "General";
            } else if (governanceActionServiceConnector instanceof WatchdogGovernanceActionService) {
                this.governanceActionServiceType = "Watchdog";
            } else if (governanceActionServiceConnector instanceof VerificationGovernanceActionService) {
                this.governanceActionServiceType = "Verification";
            } else if (governanceActionServiceConnector instanceof TriageGovernanceActionService) {
                this.governanceActionServiceType = "Triage";
            } else if (governanceActionServiceConnector instanceof RemediationGovernanceActionService) {
                this.governanceActionServiceType = "Remediation";
            } else {
                if (!(governanceActionServiceConnector instanceof ProvisioningGovernanceActionService)) {
                    auditLog.logMessage("Initializing GeneralGovernanceActionService", GovernanceActionAuditCode.UNKNOWN_GOVERNANCE_ACTION_SERVICE.getMessageDefinition(new String[]{governanceActionServiceName, serviceRequestType, governanceActionServiceConnector.getClass().getName()}));
                    throw new InvalidParameterException(GovernanceActionErrorCode.UNKNOWN_GOVERNANCE_ACTION_SERVICE.getMessageDefinition(new String[]{governanceActionServiceName, serviceRequestType, governanceActionServiceConnector.getClass().getName()}), ((Object)((Object)this)).getClass().getName(), "Initializing GeneralGovernanceActionService", "governanceActionServiceConnector");
                }
                this.governanceActionServiceType = "Provisioning";
            }
            auditLog.logMessage("Initializing GeneralGovernanceActionService", GovernanceActionAuditCode.GOVERNANCE_ACTION_INITIALIZED.getMessageDefinition(new String[]{governanceActionServiceName, governanceActionServiceConnector.getClass().getName(), serviceRequestType, this.getGovernanceEngineName()}));
            return;
        }
        catch (InvalidParameterException error) {
            throw error;
        }
        catch (Exception error) {
            auditLog.logException("Initializing GeneralGovernanceActionService", GovernanceActionAuditCode.INVALID_GOVERNANCE_ACTION_SERVICE.getMessageDefinition(new String[]{governanceActionServiceName, serviceRequestType, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            throw new InvalidParameterException(GovernanceActionErrorCode.INVALID_GOVERNANCE_ACTION_SERVICE.getMessageDefinition(new String[]{governanceActionServiceName, serviceRequestType, error.getClass().getName(), error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "Initializing GeneralGovernanceActionService", (Throwable)error, "governanceActionServiceConnector");
        }
    }

    public void run() {
        String actionDescription = "Run governance action service";
        try {
            super.waitForStartDate(this.engineHostUserId);
            this.auditLog.logMessage("Run governance action service", GovernanceActionAuditCode.GOVERNANCE_ACTION_SERVICE_STARTING.getMessageDefinition(new String[]{this.governanceActionServiceType, this.governanceServiceName, this.serviceRequestType, this.governanceEngineProperties.getQualifiedName(), this.governanceEngineGUID}));
            Date startTime = new Date();
            this.governanceActionService.start();
            Date endTime = new Date();
            CompletionStatus completionStatus = this.governanceContext.getCompletionStatus();
            if (completionStatus == null) {
                this.auditLog.logMessage("Run governance action service", GovernanceActionAuditCode.GOVERNANCE_ACTION_SERVICE_RETURNED.getMessageDefinition(new String[]{this.governanceActionServiceType, this.governanceServiceName, this.serviceRequestType}));
            } else {
                this.auditLog.logMessage("Run governance action service", GovernanceActionAuditCode.GOVERNANCE_ACTION_SERVICE_COMPLETE.getMessageDefinition(new String[]{this.governanceActionServiceType, this.governanceServiceName, this.serviceRequestType, completionStatus.getName(), Long.toString(endTime.getTime() - startTime.getTime())}));
                super.disconnect();
            }
        }
        catch (Exception error) {
            this.auditLog.logException("Run governance action service", GovernanceActionAuditCode.GOVERNANCE_ACTION_SERVICE_FAILED.getMessageDefinition(new String[]{this.governanceActionServiceType, this.governanceServiceName, error.getClass().getName(), this.governanceEngineProperties.getQualifiedName(), this.governanceEngineGUID, error.getMessage()}), error.toString(), (Throwable)error);
            try {
                CompletionStatus completionStatus = this.governanceContext.getCompletionStatus();
                if (completionStatus == null) {
                    this.governanceContext.recordCompletionStatus(Guard.SERVICE_FAILED.getCompletionStatus(), Collections.singletonList(Guard.SERVICE_FAILED.getName()), null, null, error.getMessage());
                    super.disconnect();
                }
            }
            catch (Exception statusError) {
                this.auditLog.logException("Run governance action service", GovernanceActionAuditCode.EXC_ON_ERROR_STATUS_UPDATE.getMessageDefinition(new String[]{this.governanceEngineProperties.getDisplayName(), this.governanceServiceName, statusError.getClass().getName(), statusError.getMessage()}), statusError.toString(), (Throwable)statusError);
            }
        }
    }
}

