/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.governanceaction.handlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceConfigurationClient;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceContextClient;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceDescription;
import org.odpi.openmetadata.engineservices.governanceaction.handlers.GovernanceActionServiceHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.governanceaction.client.GovernanceConfiguration;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogGovernanceEvent;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RequestSourceElement;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworkservices.gaf.client.GovernanceListenerManager;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceEngineHandler;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceServiceCache;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceServiceHandler;

public class GovernanceActionEngineHandler
extends GovernanceEngineHandler {
    private final GovernanceContextClient governanceContextClient;
    private final GovernanceListenerManager governanceListenerManager;
    private final String partnerURLRoot;
    private final String partnerServerName;
    private static final String supportGovernanceEngineType = "GovernanceActionEngine";

    public GovernanceActionEngineHandler(EngineConfig engineConfig, String localServerName, String partnerServerName, String partnerURLRoot, String serverUserId, GovernanceConfigurationClient configurationClient, GovernanceContextClient engineActionClient, GovernanceContextClient governanceContextClient, AuditLog auditLog, int maxPageSize) {
        super(engineConfig, localServerName, serverUserId, EngineServiceDescription.GOVERNANCE_ACTION_OMES.getEngineServiceFullName(), configurationClient, engineActionClient, auditLog, maxPageSize);
        this.partnerServerName = partnerServerName;
        this.partnerURLRoot = partnerURLRoot;
        this.governanceListenerManager = new GovernanceListenerManager(auditLog, engineConfig.getEngineQualifiedName());
        this.governanceContextClient = governanceContextClient;
        this.governanceContextClient.setListenerManager(this.governanceListenerManager, engineConfig.getEngineQualifiedName());
    }

    public void publishWatchdogEvent(WatchdogGovernanceEvent watchdogGovernanceEvent) throws InvalidParameterException {
        this.governanceListenerManager.processEvent(watchdogGovernanceEvent);
    }

    public void runGovernanceService(String engineActionGUID, String governanceRequestType, String requesterUserId, Date requestedStartDate, Map<String, String> requestParameters, List<RequestSourceElement> requestSourceElements, List<ActionTargetElement> actionTargetElements) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "runGovernanceService";
        super.validateGovernanceEngineInitialized(supportGovernanceEngineType, "runGovernanceService");
        GovernanceServiceCache governanceServiceCache = super.getServiceCache(governanceRequestType);
        if (governanceServiceCache != null) {
            GovernanceActionServiceHandler governanceActionServiceHandler = new GovernanceActionServiceHandler(this.governanceEngineProperties, this.governanceEngineGUID, this.serverUserId, engineActionGUID, this.engineActionClient, governanceServiceCache.getServiceRequestType(), governanceServiceCache.getRequestParameters(requestParameters), requesterUserId, requestSourceElements, actionTargetElements, governanceServiceCache.getGovernanceServiceGUID(), governanceServiceCache.getGovernanceServiceName(), governanceServiceCache.getNextGovernanceService(), this.partnerServerName, this.partnerURLRoot, this.governanceContextClient, (GovernanceConfiguration)this.configurationClient, requestedStartDate, this.auditLog, this.maxPageSize);
            super.startServiceExecutionThread(engineActionGUID, (GovernanceServiceHandler)governanceActionServiceHandler, governanceServiceCache.getGovernanceServiceName() + engineActionGUID + String.valueOf(new Date()));
        }
    }
}

