/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.governanceaction.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorReportResponse;
import org.odpi.openmetadata.engineservices.governanceaction.server.GovernanceActionRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/engine-services/governance-action/users/{userId}"})
@Tag(name="Engine Host: Governance Action OMES", description="The Governance Action OMES provide the core subsystem for driving requests for automated governance action services.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omes/governance-action/overview/"))
public class GovernanceActionEngineResource {
    private final GovernanceActionRESTServices restAPI = new GovernanceActionRESTServices();

    @GetMapping(path={"/validate-connector/{connectorProviderClassName}"})
    @Operation(summary="validateConnector", description="Validate the connector and return its connector type.  The engine service does not need to be running in the engine host in order for this call to be successful.  The engine service only needs to be registered with the engine host.", externalDocs=@ExternalDocumentation(description="Governance Action Service", url="https://egeria-project.org/concepts/governance-action-service"))
    public ConnectorReportResponse validateConnector(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectorProviderClassName) {
        return this.restAPI.validateConnector(serverName, userId, connectorProviderClassName);
    }
}

