/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.api.auditlog;

import java.text.MessageFormat;
import java.util.Arrays;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GovernanceEngineAuditCode {
    SERVICE_INITIALIZING("OMAS-GOVERNANCE-ENGINE-0001", OMRSAuditLogRecordSeverity.INFO, "The Governance Engine Open Metadata Access Service (OMAS) is initializing", "The local server has started up a new instance of the Governance Engine OMAS.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_REGISTERED_WITH_TOPIC("OMAS-GOVERNANCE-ENGINE-0002", OMRSAuditLogRecordSeverity.INFO, "The Governance Engine Open Metadata Access Service (OMAS) is registering a listener with the OMRS Topic for server instance {0}", "The Governance Engine OMAS is registering the server instance to receive events from the connected open metadata repositories.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INITIALIZED("OMAS-GOVERNANCE-ENGINE-0003", OMRSAuditLogRecordSeverity.INFO, "The Governance Engine Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The Governance Engine OMAS has completed initialization of a new instance.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_TERMINATING("OMAS-GOVERNANCE-ENGINE-0004", OMRSAuditLogRecordSeverity.INFO, "The Governance Engine Open Metadata Access Service (OMAS) is shutting down server instance {0}", "The local handlers has requested shut down of the Governance Engine OMAS.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_SHUTDOWN("OMAS-GOVERNANCE-ENGINE-0005", OMRSAuditLogRecordSeverity.INFO, "The Governance Engine Open Metadata Access Service (OMAS) has completed shutdown of server instance {0}", "The requested shutdown has now been processed", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INSTANCE_FAILURE("OMAS-GOVERNANCE-ENGINE-0006", OMRSAuditLogRecordSeverity.ERROR, "The Governance Engine Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    ERROR_INITIALIZING_TOPIC_CONNECTION("OMAS-GOVERNANCE-ENGINE-0007", OMRSAuditLogRecordSeverity.EXCEPTION, "Unable to initialize the Governance Engice Open Metadata Access Service (OMAS) topic connection {0} for server instance {1}; error message was: {2}", "The connection could not be initialized.", "Review the exception and resolve the configuration. ");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;
    private static final Logger log;

    private GovernanceEngineAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public OMRSAuditLogRecordSeverity getSeverity() {
        return this.severity;
    }

    public String getFormattedLogMessage(String ... params) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("==> OMRS Audit Code.getMessage(%s)", Arrays.toString(params)));
        }
        MessageFormat mf = new MessageFormat(this.logMessage);
        String result = mf.format(params);
        if (log.isDebugEnabled()) {
            log.debug(String.format("<== OMRS Audit Code.getMessage(%s): %s", Arrays.toString(params), result));
        }
        return result;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    static {
        log = LoggerFactory.getLogger(GovernanceEngineAuditCode.class);
    }
}

