/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.governanceengine.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GovernanceActionTypeProperties
extends ReferenceableProperties {
    private static final long serialVersionUID = 1L;
    private int domainIdentifier = 0;
    private String displayName = null;
    private String description = null;
    private List<String> supportedGuards = null;
    private String governanceEngineGUID = null;
    private String requestType = null;
    private Map<String, String> requestParameters = null;

    public GovernanceActionTypeProperties() {
    }

    public GovernanceActionTypeProperties(GovernanceActionTypeProperties template) {
        super(template);
        if (template != null) {
            this.domainIdentifier = template.getDomainIdentifier();
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.supportedGuards = template.getSupportedGuards();
            this.governanceEngineGUID = template.getGovernanceEngineGUID();
            this.requestType = template.getRequestType();
            this.requestParameters = template.getRequestParameters();
        }
    }

    public int getDomainIdentifier() {
        return this.domainIdentifier;
    }

    public void setDomainIdentifier(int domainIdentifier) {
        this.domainIdentifier = domainIdentifier;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getSupportedGuards() {
        return this.supportedGuards;
    }

    public void setSupportedGuards(List<String> supportedGuards) {
        this.supportedGuards = supportedGuards;
    }

    public String getGovernanceEngineGUID() {
        return this.governanceEngineGUID;
    }

    public void setGovernanceEngineGUID(String governanceEngineGUID) {
        this.governanceEngineGUID = governanceEngineGUID;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public Map<String, String> getRequestParameters() {
        if (this.requestParameters == null) {
            return null;
        }
        if (this.requestParameters.isEmpty()) {
            return null;
        }
        return this.requestParameters;
    }

    public void setRequestParameters(Map<String, String> requestParameters) {
        this.requestParameters = requestParameters;
    }

    @Override
    public String toString() {
        return "GovernanceActionTypeProperties{domainIdentifier=" + this.domainIdentifier + ", displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + ", supportedGuards=" + this.supportedGuards + ", governanceEngineGUID='" + this.governanceEngineGUID + '\'' + ", requestType='" + this.requestType + '\'' + ", requestParameters=" + this.requestParameters + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        GovernanceActionTypeProperties that = (GovernanceActionTypeProperties)objectToCompare;
        return this.domainIdentifier == that.domainIdentifier && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.description, that.description) && Objects.equals(this.supportedGuards, that.supportedGuards) && Objects.equals(this.governanceEngineGUID, that.governanceEngineGUID) && Objects.equals(this.requestType, that.requestType) && Objects.equals(this.requestParameters, that.requestParameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.domainIdentifier, this.displayName, this.description, this.supportedGuards, this.governanceEngineGUID, this.requestType, this.requestParameters);
    }
}

