/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.errorcode;

import java.text.MessageFormat;

public enum GovernanceEngineErrorCode {
    BAD_OUT_TOPIC_CONNECTION(400, "OMAS-GOVERNANCE-ENGINE-400-001 ", "The Governance Engine Open Metadata Access Service (OMAS) has been passed an invalid connection for publishing events.  The connection was {0}.  The resulting exception of {1} included the following message: {2}", "The access service has not been passed valid configuration for its out topic connection.", "Correct the configuration and restart the service."),
    NULL_TOPIC_CONNECTOR(400, "OMAS-GOVERNANCEENGINE-400-012", "Unable to send or receive events for source {0} because the connector to the OMRS Topic failed to initialize", "The local server will not connect to the cohort.", "The connection to the connector is configured in the server configuration.  Review previous error messages to determine the precise error in the start up configuration. Correct the configuration and reconnect the server to the cohort. "),
    OMRS_NOT_INITIALIZED(404, "OMAS-GOVERNANCE-ENGINE-404-001 ", "The open metadata repository services are not initialized for the {0} operation", "The system is unable to connect to the open metadata property handlers.", "Check that the handlers where the Asset Consumer OMAS is running initialized correctly.  Correct any errors discovered and retry the request when the open metadata services are available.");

    private int httpErrorCode;
    private String errorMessageId;
    private String errorMessage;
    private String systemAction;
    private String userAction;

    private GovernanceEngineErrorCode(int newHTTPErrorCode, String newErrorMessageId, String newErrorMessage, String newSystemAction, String newUserAction) {
        this.httpErrorCode = newHTTPErrorCode;
        this.errorMessageId = newErrorMessageId;
        this.errorMessage = newErrorMessage;
        this.systemAction = newSystemAction;
        this.userAction = newUserAction;
    }

    public int getHTTPErrorCode() {
        return this.httpErrorCode;
    }

    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    public String getFormattedErrorMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.errorMessage);
        return mf.format(params);
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }
}

