/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GovernanceActionRequestBody
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String qualifiedName = null;
    private int domainIdentifier = 0;
    private String displayName = null;
    private String description = null;
    private List<String> requestSourceGUIDs = null;
    private List<String> actionTargetGUIDs = null;
    private Date startTime = null;
    private String requestType = null;
    private Map<String, String> requestProperties = null;
    private String originatorServiceName = null;
    private String originatorEngineName = null;

    public GovernanceActionRequestBody() {
    }

    public GovernanceActionRequestBody(GovernanceActionRequestBody template) {
        if (template != null) {
            this.qualifiedName = template.getQualifiedName();
            this.domainIdentifier = template.getDomainIdentifier();
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.requestSourceGUIDs = template.getRequestSourceGUIDs();
            this.actionTargetGUIDs = template.getActionTargetGUIDs();
            this.startTime = template.getStartTime();
            this.requestType = template.getRequestType();
            this.requestProperties = template.getRequestProperties();
            this.originatorServiceName = template.getOriginatorServiceName();
            this.originatorEngineName = template.getOriginatorEngineName();
        }
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public int getDomainIdentifier() {
        return this.domainIdentifier;
    }

    public void setDomainIdentifier(int domainIdentifier) {
        this.domainIdentifier = domainIdentifier;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getRequestSourceGUIDs() {
        if (this.requestSourceGUIDs == null) {
            return null;
        }
        if (this.requestSourceGUIDs.isEmpty()) {
            return null;
        }
        return this.requestSourceGUIDs;
    }

    public void setRequestSourceGUIDs(List<String> requestSourceGUIDs) {
        this.requestSourceGUIDs = requestSourceGUIDs;
    }

    public List<String> getActionTargetGUIDs() {
        if (this.actionTargetGUIDs == null) {
            return null;
        }
        if (this.actionTargetGUIDs.isEmpty()) {
            return null;
        }
        return this.actionTargetGUIDs;
    }

    public void setActionTargetGUIDs(List<String> actionTargetGUIDs) {
        this.actionTargetGUIDs = actionTargetGUIDs;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public Map<String, String> getRequestProperties() {
        if (this.requestProperties == null) {
            return null;
        }
        if (this.requestProperties.isEmpty()) {
            return null;
        }
        return this.requestProperties;
    }

    public void setRequestProperties(Map<String, String> requestProperties) {
        this.requestProperties = requestProperties;
    }

    public String getOriginatorServiceName() {
        return this.originatorServiceName;
    }

    public void setOriginatorServiceName(String originatorServiceName) {
        this.originatorServiceName = originatorServiceName;
    }

    public String getOriginatorEngineName() {
        return this.originatorEngineName;
    }

    public void setOriginatorEngineName(String originatorEngineName) {
        this.originatorEngineName = originatorEngineName;
    }

    public String toString() {
        return "GovernanceActionRequestBody{qualifiedName='" + this.qualifiedName + '\'' + ", domainIdentifier=" + this.domainIdentifier + ", displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + ", requestSourceGUIDs=" + this.requestSourceGUIDs + ", actionTargetGUIDs=" + this.actionTargetGUIDs + ", startTime=" + this.startTime + ", requestType='" + this.requestType + '\'' + ", requestProperties=" + this.requestProperties + ", originatorServiceName=" + this.originatorServiceName + ", originatorEngineName=" + this.originatorEngineName + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        GovernanceActionRequestBody that = (GovernanceActionRequestBody)objectToCompare;
        return this.domainIdentifier == that.domainIdentifier && Objects.equals(this.qualifiedName, that.qualifiedName) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.description, that.description) && Objects.equals(this.requestSourceGUIDs, that.requestSourceGUIDs) && Objects.equals(this.actionTargetGUIDs, that.actionTargetGUIDs) && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.requestType, that.requestType) && Objects.equals(this.originatorServiceName, that.originatorServiceName) && Objects.equals(this.originatorEngineName, that.originatorEngineName) && Objects.equals(this.requestProperties, that.requestProperties);
    }

    public int hashCode() {
        return Objects.hash(this.qualifiedName, this.domainIdentifier, this.displayName, this.description, this.requestSourceGUIDs, this.actionTargetGUIDs, this.startTime, this.requestType, this.requestProperties, this.originatorServiceName, this.originatorEngineName);
    }
}

