/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.governanceengine.properties.OwnerCategory;
import org.odpi.openmetadata.accessservices.governanceengine.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GovernanceActionProcessProperties
extends ReferenceableProperties {
    private static final long serialVersionUID = 1L;
    private String displayName = null;
    private String summary = null;
    private String description = null;
    private String abbreviation = null;
    private String usage = null;
    private String technicalName = null;
    private String technicalDescription = null;
    private String owner = null;
    private OwnerCategory ownerCategory = null;
    private List<String> zoneMembership = null;
    private String originOrganizationGUID = null;
    private String originBusinessCapabilityGUID = null;
    private Map<String, String> otherOriginValues = null;
    private String formula = null;
    private String implementationLanguage = null;

    public GovernanceActionProcessProperties() {
    }

    public GovernanceActionProcessProperties(GovernanceActionProcessProperties template) {
        super(template);
        if (template != null) {
            this.displayName = template.getDisplayName();
            this.summary = template.getSummary();
            this.description = template.getDescription();
            this.abbreviation = template.getAbbreviation();
            this.usage = template.getUsage();
            this.technicalName = template.getTechnicalName();
            this.technicalDescription = template.getTechnicalDescription();
            this.owner = template.getOwner();
            this.ownerCategory = template.getOwnerCategory();
            this.zoneMembership = template.getZoneMembership();
            this.originOrganizationGUID = template.getOriginOrganizationGUID();
            this.originBusinessCapabilityGUID = template.getOriginBusinessCapabilityGUID();
            this.otherOriginValues = template.getOtherOriginValues();
            this.formula = template.getFormula();
            this.implementationLanguage = template.getImplementationLanguage();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getTechnicalName() {
        return this.technicalName;
    }

    public void setTechnicalName(String technicalName) {
        this.technicalName = technicalName;
    }

    public String getTechnicalDescription() {
        return this.technicalDescription;
    }

    public void setTechnicalDescription(String description) {
        this.technicalDescription = description;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public OwnerCategory getOwnerCategory() {
        return this.ownerCategory;
    }

    public void setOwnerCategory(OwnerCategory ownerType) {
        this.ownerCategory = ownerType;
    }

    public List<String> getZoneMembership() {
        if (this.zoneMembership == null) {
            return null;
        }
        if (this.zoneMembership.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.zoneMembership);
    }

    public void setZoneMembership(List<String> zoneMembership) {
        this.zoneMembership = zoneMembership;
    }

    public String getOriginOrganizationGUID() {
        return this.originOrganizationGUID;
    }

    public void setOriginOrganizationGUID(String originOrganizationGUID) {
        this.originOrganizationGUID = originOrganizationGUID;
    }

    public String getOriginBusinessCapabilityGUID() {
        return this.originBusinessCapabilityGUID;
    }

    public void setOriginBusinessCapabilityGUID(String originBusinessCapabilityGUID) {
        this.originBusinessCapabilityGUID = originBusinessCapabilityGUID;
    }

    public Map<String, String> getOtherOriginValues() {
        if (this.otherOriginValues == null) {
            return null;
        }
        if (this.otherOriginValues.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.otherOriginValues);
    }

    public void setOtherOriginValues(Map<String, String> otherOriginValues) {
        this.otherOriginValues = otherOriginValues;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getImplementationLanguage() {
        return this.implementationLanguage;
    }

    public void setImplementationLanguage(String implementationLanguage) {
        this.implementationLanguage = implementationLanguage;
    }

    @Override
    public String toString() {
        return "GovernanceActionProcessProperties{displayName='" + this.displayName + '\'' + ", summary='" + this.summary + '\'' + ", description='" + this.description + '\'' + ", abbreviation='" + this.abbreviation + '\'' + ", usage='" + this.usage + '\'' + ", technicalName='" + this.technicalName + '\'' + ", technicalDescription='" + this.technicalDescription + '\'' + ", owner='" + this.owner + '\'' + ", ownerCategory=" + this.ownerCategory + ", zoneMembership=" + this.zoneMembership + ", originOrganizationGUID='" + this.originOrganizationGUID + '\'' + ", originBusinessCapabilityGUID='" + this.originBusinessCapabilityGUID + '\'' + ", otherOriginValues=" + this.otherOriginValues + ", formula='" + this.formula + '\'' + ", implementationLanguage='" + this.implementationLanguage + '\'' + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        GovernanceActionProcessProperties that = (GovernanceActionProcessProperties)objectToCompare;
        return Objects.equals(this.displayName, that.displayName) && Objects.equals(this.summary, that.summary) && Objects.equals(this.description, that.description) && Objects.equals(this.abbreviation, that.abbreviation) && Objects.equals(this.usage, that.usage) && Objects.equals(this.technicalName, that.technicalName) && Objects.equals(this.technicalDescription, that.technicalDescription) && Objects.equals(this.owner, that.owner) && this.ownerCategory == that.ownerCategory && Objects.equals(this.zoneMembership, that.zoneMembership) && Objects.equals(this.originOrganizationGUID, that.originOrganizationGUID) && Objects.equals(this.originBusinessCapabilityGUID, that.originBusinessCapabilityGUID) && Objects.equals(this.otherOriginValues, that.otherOriginValues) && Objects.equals(this.formula, that.formula) && Objects.equals(this.implementationLanguage, that.implementationLanguage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.displayName, this.summary, this.description, this.abbreviation, this.usage, this.technicalName, this.technicalDescription, this.owner, this.ownerCategory, this.zoneMembership, this.originOrganizationGUID, this.originBusinessCapabilityGUID, this.otherOriginValues, this.formula, this.implementationLanguage);
    }
}

