/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IncidentDependency;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IncidentImpactedElement;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class IncidentReportRequestBody
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String qualifiedName = null;
    private int domainIdentifier = 0;
    private String background = null;
    private List<IncidentImpactedElement> impactedResources = null;
    private List<IncidentDependency> previousIncidents = null;
    private Map<String, Integer> incidentClassifiers = null;
    private Map<String, String> additionalProperties = null;
    private String originatorGUID = null;

    public IncidentReportRequestBody() {
    }

    public IncidentReportRequestBody(IncidentReportRequestBody template) {
        if (template != null) {
            this.qualifiedName = template.getQualifiedName();
            this.domainIdentifier = template.getDomainIdentifier();
            this.background = template.getBackground();
            this.impactedResources = template.getImpactedResources();
            this.previousIncidents = template.getPreviousIncidents();
            this.incidentClassifiers = template.getIncidentClassifiers();
            this.additionalProperties = template.getAdditionalProperties();
            this.originatorGUID = template.getOriginatorGUID();
        }
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public int getDomainIdentifier() {
        return this.domainIdentifier;
    }

    public void setDomainIdentifier(int domainIdentifier) {
        this.domainIdentifier = domainIdentifier;
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public List<IncidentImpactedElement> getImpactedResources() {
        if (this.impactedResources == null) {
            return null;
        }
        if (this.impactedResources.isEmpty()) {
            return null;
        }
        return this.impactedResources;
    }

    public void setImpactedResources(List<IncidentImpactedElement> impactedResources) {
        this.impactedResources = impactedResources;
    }

    public List<IncidentDependency> getPreviousIncidents() {
        if (this.previousIncidents == null) {
            return null;
        }
        if (this.previousIncidents.isEmpty()) {
            return null;
        }
        return this.previousIncidents;
    }

    public void setPreviousIncidents(List<IncidentDependency> previousIncidents) {
        this.previousIncidents = previousIncidents;
    }

    public Map<String, Integer> getIncidentClassifiers() {
        if (this.incidentClassifiers == null) {
            return null;
        }
        if (this.incidentClassifiers.isEmpty()) {
            return null;
        }
        return this.incidentClassifiers;
    }

    public void setIncidentClassifiers(Map<String, Integer> incidentClassifiers) {
        this.incidentClassifiers = incidentClassifiers;
    }

    public Map<String, String> getAdditionalProperties() {
        if (this.additionalProperties == null) {
            return null;
        }
        if (this.additionalProperties.isEmpty()) {
            return null;
        }
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public String getOriginatorGUID() {
        return this.originatorGUID;
    }

    public void setOriginatorGUID(String originatorGUID) {
        this.originatorGUID = originatorGUID;
    }

    public String toString() {
        return "IncidentReportRequestBody{qualifiedName='" + this.qualifiedName + '\'' + ", domainIdentifier=" + this.domainIdentifier + ", background='" + this.background + '\'' + ", impactedResources=" + this.impactedResources + ", previousIncidents=" + this.previousIncidents + ", incidentClassifiers=" + this.incidentClassifiers + ", additionalProperties=" + this.additionalProperties + ", originatorGUID=" + this.originatorGUID + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        IncidentReportRequestBody that = (IncidentReportRequestBody)objectToCompare;
        return this.domainIdentifier == that.domainIdentifier && Objects.equals(this.qualifiedName, that.qualifiedName) && Objects.equals(this.background, that.background) && Objects.equals(this.impactedResources, that.impactedResources) && Objects.equals(this.previousIncidents, that.previousIncidents) && Objects.equals(this.incidentClassifiers, that.incidentClassifiers) && Objects.equals(this.originatorGUID, that.originatorGUID) && Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.qualifiedName, this.domainIdentifier, this.background, this.impactedResources, this.previousIncidents, this.incidentClassifiers, this.originatorGUID, this.additionalProperties);
    }
}

