/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceActionEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceEngineConfigurationEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceEngineEventType;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceServiceConfigurationEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.WatchdogGovernanceServiceEvent;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=GovernanceEngineConfigurationEvent.class, name="GovernanceEngineConfigurationEvent"), @JsonSubTypes.Type(value=GovernanceServiceConfigurationEvent.class, name="GovernanceServiceConfigurationEvent"), @JsonSubTypes.Type(value=WatchdogGovernanceServiceEvent.class, name="WatchdogGovernanceServiceEvent"), @JsonSubTypes.Type(value=GovernanceActionEvent.class, name="GovernanceActionEvent")})
public abstract class GovernanceEngineEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long eventVersionId = 1L;
    private GovernanceEngineEventType eventType = null;
    private String governanceEngineGUID = null;
    private String governanceEngineName = null;

    GovernanceEngineEvent() {
    }

    GovernanceEngineEvent(GovernanceEngineEvent template) {
        if (template != null) {
            this.eventVersionId = template.getEventVersionId();
            this.eventType = template.getEventType();
            this.governanceEngineGUID = template.getGovernanceEngineGUID();
            this.governanceEngineName = template.getGovernanceEngineName();
        }
    }

    public long getEventVersionId() {
        return this.eventVersionId;
    }

    public void setEventVersionId(long eventVersionId) {
        this.eventVersionId = eventVersionId;
    }

    public GovernanceEngineEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(GovernanceEngineEventType eventType) {
        this.eventType = eventType;
    }

    public String getGovernanceEngineGUID() {
        return this.governanceEngineGUID;
    }

    public void setGovernanceEngineGUID(String governanceEngineGUID) {
        this.governanceEngineGUID = governanceEngineGUID;
    }

    public String getGovernanceEngineName() {
        return this.governanceEngineName;
    }

    public void setGovernanceEngineName(String governanceEngineName) {
        this.governanceEngineName = governanceEngineName;
    }

    public String toString() {
        return "GovernanceEngineEvent{eventVersionId=" + this.eventVersionId + ", eventType=" + this.eventType + ", governanceEngineGUID='" + this.governanceEngineGUID + '\'' + ", governanceEngineName='" + this.governanceEngineName + '\'' + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        GovernanceEngineEvent that = (GovernanceEngineEvent)objectToCompare;
        return this.eventVersionId == that.eventVersionId && this.eventType == that.eventType && Objects.equals(this.governanceEngineGUID, that.governanceEngineGUID) && Objects.equals(this.governanceEngineName, that.governanceEngineName);
    }

    public int hashCode() {
        return Objects.hash(this.eventVersionId, this.eventType, this.governanceEngineGUID, this.governanceEngineName);
    }
}

