/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum GovernanceEngineEventType implements Serializable
{
    UNKNOWN_GOVERNANCE_ENGINE_EVENT(0, "Unknown Event", "An event that is not recognized by the local server."),
    REFRESH_GOVERNANCE_ENGINE_EVENT(1, "Refresh Governance Engine Configuration", "The configuration for a governance engine has changed."),
    REFRESH_GOVERNANCE_SERVICE_EVENT(2, "Refresh Governance Service Configuration", "The configuration for a governance service has changed."),
    WATCHDOG_GOVERNANCE_SERVICE_EVENT(3, "Metadata change event", "Metadata change event for watchdog governance action services."),
    REQUESTED_GOVERNANCE_ACTION_EVENT(4, "Requested Governance Action", "New request to run a governance service.");

    private static final long serialVersionUID = 1L;
    private final int eventTypeCode;
    private final String eventTypeName;
    private final String eventTypeDescription;

    private GovernanceEngineEventType(int eventTypeCode, String eventTypeName, String eventTypeDescription) {
        this.eventTypeCode = eventTypeCode;
        this.eventTypeName = eventTypeName;
        this.eventTypeDescription = eventTypeDescription;
    }

    public int getEventTypeCode() {
        return this.eventTypeCode;
    }

    public String getEventTypeName() {
        return this.eventTypeName;
    }

    public String getEventTypeDescription() {
        return this.eventTypeDescription;
    }

    public String toString() {
        return "GovernanceEngineEventType{eventTypeCode=" + this.eventTypeCode + ", eventTypeName='" + this.eventTypeName + "', eventTypeDescription='" + this.eventTypeDescription + "'}";
    }
}

