/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum ElementStatus implements Serializable
{
    UNKNOWN(0, "<Unknown>", "Unknown instance status."),
    DRAFT(1, "Draft", "The content is incomplete."),
    PREPARED(2, "Prepared", "The content is ready for review."),
    PROPOSED(3, "Proposed", "The content is in review."),
    APPROVED(4, "Approved", "The content is approved."),
    REJECTED(5, "Rejected", "The request or proposal is rejected."),
    APPROVED_CONCEPT(6, "Approved concept", "The request or proposal is approved for development."),
    UNDER_DEVELOPMENT(7, "Under development", "The instance is being developed."),
    DEVELOPMENT_COMPLETE(8, "Development complete", "The development of the instance is complete."),
    APPROVED_FOR_DEPLOYMENT(9, "Approved for deployment", "The instance is approved for deployment."),
    STANDBY(10, "StandBy", "The instance is deployed in standby mode."),
    ACTIVE(15, "Active", "The instance is approved and in use."),
    FAILED(20, "Failed", "The instance is not in use due to failure."),
    DISABLED(21, "Disabled", "The instance is shutdown or disabled."),
    COMPLETE(22, "Complete", "The activity associated with the instance is complete."),
    DEPRECATED(30, "Deprecated", "The instance is out of date and should not be used."),
    OTHER(50, "Other", "The instance is in a locally defined state.");

    private static final long serialVersionUID = 1L;
    private int ordinal;
    private String name;
    private String description;

    private ElementStatus(int ordinal, String name, String description) {
        this.ordinal = ordinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "InstanceStatus{ordinal=" + this.ordinal + ", name='" + this.name + "', description='" + this.description + "'}";
    }
}

