/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceEngineEvent;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GovernanceServiceConfigurationEvent
extends GovernanceEngineEvent {
    private static final long serialVersionUID = 1L;
    private String registeredGovernanceServiceGUID = null;
    private String requestType = null;
    private Map<String, String> requestParameters = null;

    public GovernanceServiceConfigurationEvent() {
    }

    public GovernanceServiceConfigurationEvent(GovernanceServiceConfigurationEvent template) {
        super(template);
        if (template != null) {
            this.registeredGovernanceServiceGUID = template.getRegisteredGovernanceServiceGUID();
            this.requestType = template.getRequestType();
            this.requestParameters = template.getRequestParameters();
        }
    }

    public String getRegisteredGovernanceServiceGUID() {
        return this.registeredGovernanceServiceGUID;
    }

    public void setRegisteredGovernanceServiceGUID(String registeredGovernanceServiceGUID) {
        this.registeredGovernanceServiceGUID = registeredGovernanceServiceGUID;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public Map<String, String> getRequestParameters() {
        if (this.requestParameters == null) {
            return null;
        }
        if (this.requestParameters.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.requestParameters);
    }

    public void setRequestParameters(Map<String, String> requestParameters) {
        this.requestParameters = requestParameters;
    }

    @Override
    public String toString() {
        return "GovernanceServiceConfigurationEvent{registeredGovernanceServiceGUID='" + this.registeredGovernanceServiceGUID + "', requestType='" + this.requestType + "', requestParameters=" + this.requestParameters + ", eventVersionId=" + this.getEventVersionId() + ", eventType=" + this.getEventType() + ", governanceEngineGUID='" + this.getGovernanceEngineGUID() + "', governanceEngineName='" + this.getGovernanceEngineName() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        GovernanceServiceConfigurationEvent that = (GovernanceServiceConfigurationEvent)objectToCompare;
        return Objects.equals(this.registeredGovernanceServiceGUID, that.registeredGovernanceServiceGUID) && Objects.equals(this.requestType, that.requestType) && Objects.equals(this.requestParameters, that.requestParameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.registeredGovernanceServiceGUID, this.requestType, this.requestParameters);
    }
}

