/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateRequestBody;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class UpdatePropertiesRequestBody
extends UpdateRequestBody {
    private boolean replaceProperties = false;
    private ElementProperties properties = null;

    public UpdatePropertiesRequestBody() {
    }

    public UpdatePropertiesRequestBody(UpdatePropertiesRequestBody template) {
        super(template);
        if (template != null) {
            this.replaceProperties = template.getReplaceProperties();
            this.properties = template.getProperties();
        }
    }

    public boolean getReplaceProperties() {
        return this.replaceProperties;
    }

    public void setReplaceProperties(boolean replaceProperties) {
        this.replaceProperties = replaceProperties;
    }

    public ElementProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ElementProperties properties) {
        this.properties = properties;
    }

    @Override
    public String toString() {
        return "UpdatePropertiesRequestBody{replaceProperties=" + this.replaceProperties + ", properties=" + this.properties + ", forLineage=" + this.getForLineage() + ", forDuplicateProcessing=" + this.getForDuplicateProcessing() + ", effectiveTime=" + this.getEffectiveTime() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        UpdatePropertiesRequestBody that = (UpdatePropertiesRequestBody)objectToCompare;
        return this.replaceProperties == that.replaceProperties && Objects.equals(this.properties, that.properties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.replaceProperties, this.properties);
    }
}

