/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.governanceengine.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GovernanceActionTypeProperties
extends ReferenceableProperties {
    private int domainIdentifier = 0;
    private String displayName = null;
    private String description = null;
    private Map<String, String> producedGuards = null;
    private String governanceEngineGUID = null;
    private String requestType = null;
    private Map<String, String> requestParameters = null;
    private boolean ignoreMultipleTriggers = false;
    private int waitTime = 0;

    public GovernanceActionTypeProperties() {
    }

    public GovernanceActionTypeProperties(GovernanceActionTypeProperties template) {
        super(template);
        if (template != null) {
            this.domainIdentifier = template.getDomainIdentifier();
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.producedGuards = template.getProducedGuards();
            this.governanceEngineGUID = template.getGovernanceEngineGUID();
            this.requestType = template.getRequestType();
            this.requestParameters = template.getRequestParameters();
            this.ignoreMultipleTriggers = template.getIgnoreMultipleTriggers();
            this.waitTime = template.getWaitTime();
        }
    }

    public int getDomainIdentifier() {
        return this.domainIdentifier;
    }

    public void setDomainIdentifier(int domainIdentifier) {
        this.domainIdentifier = domainIdentifier;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, String> getProducedGuards() {
        return this.producedGuards;
    }

    public void setProducedGuards(Map<String, String> producedGuards) {
        this.producedGuards = producedGuards;
    }

    public String getGovernanceEngineGUID() {
        return this.governanceEngineGUID;
    }

    public void setGovernanceEngineGUID(String governanceEngineGUID) {
        this.governanceEngineGUID = governanceEngineGUID;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public Map<String, String> getRequestParameters() {
        if (this.requestParameters == null) {
            return null;
        }
        if (this.requestParameters.isEmpty()) {
            return null;
        }
        return this.requestParameters;
    }

    public void setRequestParameters(Map<String, String> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public boolean getIgnoreMultipleTriggers() {
        return this.ignoreMultipleTriggers;
    }

    public void setIgnoreMultipleTriggers(boolean ignoreMultipleTriggers) {
        this.ignoreMultipleTriggers = ignoreMultipleTriggers;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    @Override
    public String toString() {
        return "GovernanceActionTypeProperties{domainIdentifier=" + this.domainIdentifier + ", displayName='" + this.displayName + "', description='" + this.description + "', supportedGuards=" + this.producedGuards + ", governanceEngineGUID='" + this.governanceEngineGUID + "', requestType='" + this.requestType + "', requestParameters=" + this.requestParameters + ", ignoreMultipleTriggers=" + this.ignoreMultipleTriggers + ", waitTime=" + this.waitTime + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        GovernanceActionTypeProperties that = (GovernanceActionTypeProperties)objectToCompare;
        return this.domainIdentifier == that.domainIdentifier && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.description, that.description) && this.ignoreMultipleTriggers == that.ignoreMultipleTriggers && this.waitTime == that.waitTime && Objects.equals(this.producedGuards, that.producedGuards) && Objects.equals(this.governanceEngineGUID, that.governanceEngineGUID) && Objects.equals(this.requestType, that.requestType) && Objects.equals(this.requestParameters, that.requestParameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.domainIdentifier, this.displayName, this.description, this.producedGuards, this.governanceEngineGUID, this.requestType, this.requestParameters, this.ignoreMultipleTriggers, this.waitTime);
    }
}

