/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.errorcode.GovernanceEngineErrorCode;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.ClassificationNotFoundException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.GuidNotFoundException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.MetadataServerException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.TypeNotFoundException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceClassificationDef;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceClassificationDefAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceClassificationDefListAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceEngineOMASAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAsset;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAssetAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAssetListAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class GovernanceEngineImpl
implements GovernanceEngineClient {
    private String omasServerURL;
    private RestTemplate restTemplate;
    private static final Logger log = LoggerFactory.getLogger(GovernanceEngineImpl.class);

    public GovernanceEngineImpl(String newServerURL) {
        this.omasServerURL = newServerURL;
        this.restTemplate = new RestTemplate();
    }

    @Override
    public List<GovernedAsset> getGovernedAssetList(String userId, String classification, String type) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerException, ClassificationNotFoundException, TypeNotFoundException {
        String methodName = "getGovernedAssetList";
        String urlTemplate = "/{0}/assets?classification={1}&type={2}";
        log.debug("Calling method: getGovernedAssetList");
        this.validateOMASServerURL("getGovernedAssetList");
        this.validateUserId(userId, "getGovernedAssetList");
        GovernedAssetListAPIResponse restResult = this.callGovernedAssetListREST("getGovernedAssetList", this.omasServerURL + "/{0}/assets?classification={1}&type={2}", userId, type, classification);
        this.detectAndThrowInvalidParameterException("getGovernedAssetList", (GovernanceEngineOMASAPIResponse)restResult);
        this.detectAndThrowClassificationNotFoundException("getGovernedAssetList", (GovernanceEngineOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getGovernedAssetList", (GovernanceEngineOMASAPIResponse)restResult);
        this.detectAndThrowTypeNotFoundException("getGovernedAssetList", (GovernanceEngineOMASAPIResponse)restResult);
        return restResult.getGovernedAssetList();
    }

    @Override
    public List<GovernanceClassificationDef> getGovernanceClassificationDefList(String userId, String classification) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerException, ClassificationNotFoundException {
        String methodName = "getGovernanceClassificationDefList";
        String urlTemplate = "/{0}/classificationdefs?classification={1}";
        log.debug("Calling method: getGovernanceClassificationDefList");
        this.validateOMASServerURL("getGovernanceClassificationDefList");
        this.validateUserId(userId, "getGovernanceClassificationDefList");
        GovernanceClassificationDefListAPIResponse restResult = this.callClassificationDefListREST("getGovernanceClassificationDefList", this.omasServerURL + "/{0}/classificationdefs?classification={1}", userId, classification);
        this.detectAndThrowInvalidParameterException("getGovernanceClassificationDefList", (GovernanceEngineOMASAPIResponse)restResult);
        this.detectAndThrowClassificationNotFoundException("getGovernanceClassificationDefList", (GovernanceEngineOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getGovernanceClassificationDefList", (GovernanceEngineOMASAPIResponse)restResult);
        return restResult.getTagList();
    }

    @Override
    public GovernedAsset getGovernedAsset(String userId, String assetGuid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerException, GuidNotFoundException {
        String methodName = "getGovernedAssetList";
        String urlTemplate = "/{0}/assets/{1}";
        log.debug("Calling method: getGovernedAssetList");
        this.validateOMASServerURL("getGovernedAssetList");
        this.validateUserId(userId, "getGovernedAssetList");
        this.validateGuid(assetGuid, "getGovernedAssetList");
        GovernedAssetAPIResponse restResult = this.callGovernedAssetREST("getGovernedAssetList", this.omasServerURL + "/{0}/assets/{1}", userId, assetGuid);
        this.detectAndThrowInvalidParameterException("getGovernedAssetList", (GovernanceEngineOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getGovernedAssetList", (GovernanceEngineOMASAPIResponse)restResult);
        this.detectAndThrowGuidNotFoundException("getGovernedAssetList", (GovernanceEngineOMASAPIResponse)restResult);
        return restResult.getAsset();
    }

    @Override
    public GovernanceClassificationDef getGovernanceClassificationDef(String userId, String classificationGuid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerException, GuidNotFoundException {
        String methodName = "getGovernanceClassificationDef";
        String urlTemplate = "/{0}/assets?classification={1}";
        log.debug("Calling method: getGovernanceClassificationDef");
        this.validateOMASServerURL("getGovernanceClassificationDef");
        this.validateUserId(userId, "getGovernanceClassificationDef");
        this.validateGuid(classificationGuid, "getGovernanceClassificationDef");
        GovernanceClassificationDefAPIResponse restResult = this.callClassificationDefREST("getGovernanceClassificationDef", this.omasServerURL + "/{0}/assets?classification={1}", userId, classificationGuid);
        this.detectAndThrowInvalidParameterException("getGovernanceClassificationDef", (GovernanceEngineOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getGovernanceClassificationDef", (GovernanceEngineOMASAPIResponse)restResult);
        this.detectAndThrowGuidNotFoundException("getGovernanceClassificationDef", (GovernanceEngineOMASAPIResponse)restResult);
        return restResult.getGovernanceClassificationDef();
    }

    private void validateOMASServerURL(String methodName) throws InvalidParameterException {
        if (StringUtils.isEmpty((Object)this.omasServerURL)) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.SERVER_URL_NOT_SPECIFIED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private void validateUserId(String userId, String methodName) throws InvalidParameterException {
        if (StringUtils.isEmpty((Object)userId)) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.EMPTY_USER_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private void validateGuid(String guid, String methodName) throws InvalidParameterException {
        if (StringUtils.isEmpty((Object)guid)) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.NULL_GUID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private GovernanceClassificationDefListAPIResponse callClassificationDefListREST(String methodName, String urlTemplate, Object ... params) throws MetadataServerException {
        GovernanceClassificationDefListAPIResponse restResult = new GovernanceClassificationDefListAPIResponse();
        try {
            restResult = (GovernanceClassificationDefListAPIResponse)this.restTemplate.getForObject(urlTemplate, restResult.getClass(), params);
        }
        catch (Throwable error) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, this.omasServerURL, error.getMessage()});
            throw new MetadataServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
        return restResult;
    }

    private GovernanceClassificationDefAPIResponse callClassificationDefREST(String methodName, String urlTemplate, Object ... params) throws MetadataServerException {
        GovernanceClassificationDefAPIResponse restResult = new GovernanceClassificationDefAPIResponse();
        try {
            restResult = (GovernanceClassificationDefAPIResponse)this.restTemplate.getForObject(urlTemplate, restResult.getClass(), params);
        }
        catch (Throwable error) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, this.omasServerURL, error.getMessage()});
            throw new MetadataServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
        return restResult;
    }

    private GovernedAssetListAPIResponse callGovernedAssetListREST(String methodName, String urlTemplate, Object ... params) throws MetadataServerException {
        GovernedAssetListAPIResponse restResult = new GovernedAssetListAPIResponse();
        try {
            restResult = (GovernedAssetListAPIResponse)this.restTemplate.getForObject(urlTemplate, restResult.getClass(), params);
        }
        catch (Throwable error) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, this.omasServerURL, error.getMessage()});
            throw new MetadataServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
        return restResult;
    }

    private GovernedAssetAPIResponse callGovernedAssetREST(String methodName, String urlTemplate, Object ... params) throws MetadataServerException {
        GovernedAssetAPIResponse restResult = new GovernedAssetAPIResponse();
        try {
            restResult = (GovernedAssetAPIResponse)this.restTemplate.getForObject(urlTemplate, restResult.getClass(), params);
        }
        catch (Throwable error) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, this.omasServerURL, error.getMessage()});
            throw new MetadataServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
        return restResult;
    }

    private void detectAndThrowInvalidParameterException(String methodName, GovernanceEngineOMASAPIResponse restResult) throws InvalidParameterException {
        String exceptionClassName = InvalidParameterException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new InvalidParameterException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction());
        }
    }

    private void detectAndThrowGuidNotFoundException(String methodName, GovernanceEngineOMASAPIResponse restResult) throws GuidNotFoundException {
        String exceptionClassName = GuidNotFoundException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new GuidNotFoundException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction());
        }
    }

    private void detectAndThrowClassificationNotFoundException(String methodName, GovernanceEngineOMASAPIResponse restResult) throws ClassificationNotFoundException {
        String exceptionClassName = ClassificationNotFoundException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new ClassificationNotFoundException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction());
        }
    }

    private void detectAndThrowTypeNotFoundException(String methodName, GovernanceEngineOMASAPIResponse restResult) throws TypeNotFoundException {
        String exceptionClassName = TypeNotFoundException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new TypeNotFoundException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction());
        }
    }

    private void detectAndThrowUserNotAuthorizedException(String methodName, GovernanceEngineOMASAPIResponse restResult) throws UserNotAuthorizedException {
        String exceptionClassName = UserNotAuthorizedException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new UserNotAuthorizedException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction());
        }
    }
}

