/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.client;

import java.util.Collections;
import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.errorcode.GovernanceEngineErrorCode;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAsset;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAssetAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAssetListAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.SoftwareServerCapability;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.SoftwareServerCapabilityResponse;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class GovernanceEngine
implements GovernanceEngineInterface {
    private static final Logger log = LoggerFactory.getLogger(GovernanceEngine.class);
    private String serverName;
    private String omasServerURL;
    private RestTemplate restTemplate;

    public GovernanceEngine(String serverName, String newServerURL) {
        this.serverName = serverName;
        this.omasServerURL = newServerURL;
        this.restTemplate = new RestTemplate();
    }

    @Override
    public List<GovernedAsset> getGovernedAssetList(String userId, String classification, String type) throws InvalidParameterException {
        String methodName = "getGovernedAssetList";
        log.debug("Calling method: {}", (Object)"getGovernedAssetList");
        this.validateOMASServerURL("getGovernedAssetList");
        this.validateUserId(userId, "getGovernedAssetList");
        String url = "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/assets?type={2}";
        GovernedAssetListAPIResponse response = this.getRestCall("/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/assets?type={2}", GovernedAssetListAPIResponse.class, this.serverName, userId, type, classification);
        if (response != null) {
            return response.getGovernedAssetList();
        }
        return Collections.emptyList();
    }

    @Override
    public GovernedAsset getGovernedAsset(String userId, String assetGuid) throws InvalidParameterException {
        String methodName = "getGovernedAssetList";
        log.debug("Calling method: {}", (Object)"getGovernedAssetList");
        this.validateOMASServerURL("getGovernedAssetList");
        this.validateUserId(userId, "getGovernedAssetList");
        this.validateGuid(assetGuid, "getGovernedAssetList");
        String url = "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/assets/{2}";
        GovernedAssetAPIResponse response = this.getRestCall("/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/assets/{2}", GovernedAssetAPIResponse.class, this.serverName, userId, assetGuid);
        if (response != null) {
            return response.getAsset();
        }
        return null;
    }

    @Override
    public SoftwareServerCapability createSoftwareServerCapability(String userId, SoftwareServerCapability softwareServerCapability) throws InvalidParameterException {
        String methodName = "createSoftwareServerCapability";
        log.debug("Calling method: {}", (Object)"createSoftwareServerCapability");
        this.validateOMASServerURL("createSoftwareServerCapability");
        this.validateUserId(userId, "createSoftwareServerCapability");
        String url = "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/software-server-capabilities";
        SoftwareServerCapabilityResponse response = this.postRestCall("/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/software-server-capabilities", softwareServerCapability, SoftwareServerCapabilityResponse.class, this.serverName, userId);
        return response.getServerCapability();
    }

    @Override
    public SoftwareServerCapability getSoftwareServerCapabilityByGUID(String userId, String guid) throws InvalidParameterException {
        String methodName = "getSoftwareServerCapabilityByGUID";
        log.debug("Calling method: {}", (Object)"getSoftwareServerCapabilityByGUID");
        this.validateOMASServerURL("getSoftwareServerCapabilityByGUID");
        this.validateUserId(userId, "getSoftwareServerCapabilityByGUID");
        String url = "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/software-server-capabilities/{2}";
        SoftwareServerCapabilityResponse response = this.getRestCall("/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/software-server-capabilities/{2}", SoftwareServerCapabilityResponse.class, this.serverName, userId, guid);
        return response.getServerCapability();
    }

    private void validateOMASServerURL(String methodName) throws InvalidParameterException {
        if (StringUtils.isEmpty((Object)this.omasServerURL)) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.SERVER_URL_NOT_SPECIFIED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private void validateUserId(String userId, String methodName) throws InvalidParameterException {
        if (StringUtils.isEmpty((Object)userId)) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.EMPTY_USER_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private void validateGuid(String guid, String methodName) throws InvalidParameterException {
        if (StringUtils.isEmpty((Object)guid)) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.NULL_GUID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private <T> T postRestCall(String url, Object requestBody, Class<T> clazz, Object ... params) {
        return (T)this.restTemplate.postForObject(this.omasServerURL + url, requestBody, clazz, params);
    }

    private <T> T getRestCall(String url, Class<T> clazz, Object ... params) {
        return (T)this.restTemplate.getForObject(this.omasServerURL + url, clazz, params);
    }
}

