/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.client;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.api.GovernanceProcessingInterface;
import org.odpi.openmetadata.accessservices.governanceengine.api.MetadataElementInterface;
import org.odpi.openmetadata.accessservices.governanceengine.api.SpecialGovernanceActionInterface;
import org.odpi.openmetadata.accessservices.governanceengine.client.rest.GovernanceEngineRESTClient;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceActionElement;
import org.odpi.openmetadata.accessservices.governanceengine.rest.ActionTargetStatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.CompletionStatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.ConsolidatedDuplicatesRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.FindRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionProcessRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.IncidentReportRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NewClassificationRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NewMetadataElementRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NewRelatedElementsRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.OpenMetadataElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.OpenMetadataElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.PeerDuplicatesRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.RelatedMetadataElementListResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.RelatedMetadataElementsListResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.StatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateEffectivityDatesRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdatePropertiesRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateStatusRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IncidentDependency;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IncidentImpactedElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElements;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchClassifications;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.SequencingOrder;

public class GovernanceEngineClient
implements MetadataElementInterface,
GovernanceProcessingInterface,
SpecialGovernanceActionInterface {
    private final String serverName;
    private final String serverPlatformURLRoot;
    private final GovernanceEngineRESTClient restClient;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final NullRequestBody nullRequestBody = new NullRequestBody();

    public GovernanceEngineClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceEngineRESTClient(serverName, serverPlatformURLRoot);
    }

    public GovernanceEngineClient(String serverName, String serverPlatformURLRoot, String serverUserId, String serverPassword) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceEngineRESTClient(serverName, serverPlatformURLRoot, serverUserId, serverPassword);
    }

    public GovernanceEngineClient(String serverName, String serverPlatformURLRoot, GovernanceEngineRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    private long getEffectiveTimeAsLong(Date effectiveTime) {
        long effectiveTimeLong = 0L;
        if (effectiveTime != null) {
            effectiveTimeLong = effectiveTime.getTime();
        }
        return effectiveTimeLong;
    }

    public OpenMetadataElement getMetadataElementByGUID(String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementByGUID";
        String guidParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/metadata-elements/{2}?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementByGUID");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getMetadataElementByGUID");
        OpenMetadataElementResponse restResult = this.restClient.callOpenMetadataElementGetRESTCall("getMetadataElementByGUID", urlTemplate, this.serverName, userId, elementGUID, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime));
        return restResult.getElement();
    }

    public OpenMetadataElement getMetadataElementByUniqueName(String userId, String uniqueName, String uniquePropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementByUniqueName";
        String defaultPropertyName = "qualifiedName";
        String nameParameterName = "uniqueName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/metadata-elements/by-unique-name?forLineage={2}&forDuplicateProcessing={3}&effectiveTime={4}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementByUniqueName");
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", "getMetadataElementByUniqueName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(uniqueName);
        requestBody.setNameParameterName("uniqueName");
        if (uniquePropertyName != null) {
            requestBody.setNamePropertyName(uniquePropertyName);
        } else {
            requestBody.setNamePropertyName("qualifiedName");
        }
        OpenMetadataElementResponse restResult = this.restClient.callOpenMetadataElementPostRESTCall("getMetadataElementByUniqueName", urlTemplate, requestBody, this.serverName, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime));
        return restResult.getElement();
    }

    public String getMetadataElementGUIDByUniqueName(String userId, String uniqueName, String uniquePropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementGUIDByUniqueName";
        String defaultPropertyName = "qualifiedName";
        String nameParameterName = "uniqueName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/metadata-elements/guid-by-unique-name?forLineage={2}&forDuplicateProcessing={3}&effectiveTime={4}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementGUIDByUniqueName");
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", "getMetadataElementGUIDByUniqueName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(uniqueName);
        requestBody.setNameParameterName("uniqueName");
        if (uniquePropertyName != null) {
            requestBody.setNamePropertyName(uniquePropertyName);
        } else {
            requestBody.setNamePropertyName("qualifiedName");
        }
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("getMetadataElementGUIDByUniqueName", urlTemplate, requestBody, new Object[]{this.serverName, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime)});
        return restResult.getGUID();
    }

    public List<OpenMetadataElement> findMetadataElementsWithString(String userId, String searchString, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findMetadataElementsWithString";
        String searchStringParameterName = "searchString";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/metadata-elements/by-search-string?forLineage={2}&forDuplicateProcessing={3}&effectiveTime={4}&startFrom={5}&pageSize={6}";
        this.invalidParameterHandler.validateUserId(userId, "findMetadataElementsWithString");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findMetadataElementsWithString");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        OpenMetadataElementsResponse restResult = this.restClient.callOpenMetadataElementsPostRESTCall("findMetadataElementsWithString", urlTemplate, requestBody, this.serverName, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElementList();
    }

    public List<RelatedMetadataElement> getRelatedMetadataElements(String userId, String elementGUID, int startingAtEnd, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelatedMetadataElements";
        String guidParameterName = "elementGUID";
        String typeNameParameterName = "relationshipTypeName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/related-elements/{2}/type/{3}?startingAtEnd={4}&forLineage={5}&forDuplicateProcessing={6}&effectiveTime={7}&startFrom={8}&pageSize={9}";
        this.invalidParameterHandler.validateUserId(userId, "getRelatedMetadataElements");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getRelatedMetadataElements");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "getRelatedMetadataElements");
        RelatedMetadataElementListResponse restResult = this.restClient.callRelatedMetadataElementListGetRESTCall("getRelatedMetadataElements", urlTemplate, this.serverName, userId, elementGUID, relationshipTypeName, Integer.toString(startingAtEnd), forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElementList();
    }

    public List<OpenMetadataElement> findMetadataElements(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeName, SearchProperties searchProperties, List<ElementStatus> limitResultsByStatus, SearchClassifications matchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findMetadataElements";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/metadata-elements/by-search-specification?forLineage={2}&forDuplicateProcessing={3}&effectiveTime={4}&startFrom={5}&pageSize={6}";
        this.invalidParameterHandler.validateUserId(userId, "findMetadataElements");
        FindRequestBody requestBody = new FindRequestBody();
        requestBody.setMetadataElementTypeName(metadataElementTypeName);
        requestBody.setMetadataElementSubtypeName(metadataElementSubtypeName);
        requestBody.setSearchProperties(searchProperties);
        requestBody.setLimitResultsByStatus(limitResultsByStatus);
        requestBody.setMatchClassifications(matchClassifications);
        requestBody.setSequencingProperty(sequencingProperty);
        requestBody.setSequencingOrder(sequencingOrder);
        OpenMetadataElementsResponse restResult = this.restClient.callOpenMetadataElementsPostRESTCall("findMetadataElements", urlTemplate, requestBody, this.serverName, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElementList();
    }

    public List<RelatedMetadataElements> findRelationshipsBetweenMetadataElements(String userId, String relationshipTypeName, SearchProperties searchProperties, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findRelationshipsBetweenMetadataElements";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/related-elements/by-search-specification?forLineage={2}&forDuplicateProcessing={3}&effectiveTime={4}&startFrom={5}&pageSize={6}";
        this.invalidParameterHandler.validateUserId(userId, "findRelationshipsBetweenMetadataElements");
        FindRequestBody requestBody = new FindRequestBody();
        requestBody.setMetadataElementTypeName(relationshipTypeName);
        requestBody.setSearchProperties(searchProperties);
        requestBody.setSequencingProperty(sequencingProperty);
        requestBody.setSequencingOrder(sequencingOrder);
        RelatedMetadataElementsListResponse restResult = this.restClient.callRelatedMetadataElementsListPostRESTCall("findRelationshipsBetweenMetadataElements", urlTemplate, requestBody, this.serverName, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElementList();
    }

    public String createMetadataElementInStore(String userId, String metadataElementTypeName, ElementStatus initialStatus, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String templateGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createMetadataElementInStore";
        String elementTypeParameterName = "metadataElementTypeName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/metadata-elements/new";
        this.invalidParameterHandler.validateUserId(userId, "createMetadataElementInStore");
        this.invalidParameterHandler.validateName(metadataElementTypeName, "metadataElementTypeName", "createMetadataElementInStore");
        NewMetadataElementRequestBody requestBody = new NewMetadataElementRequestBody();
        requestBody.setTypeName(metadataElementTypeName);
        requestBody.setInitialStatus(initialStatus);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setProperties(properties);
        requestBody.setTemplateGUID(templateGUID);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createMetadataElementInStore", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updateMetadataElementInStore(String userId, String metadataElementGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/metadata-elements/{2}/update-properties";
        this.invalidParameterHandler.validateUserId(userId, "updateMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateMetadataElementInStore");
        UpdatePropertiesRequestBody requestBody = new UpdatePropertiesRequestBody();
        requestBody.setReplaceProperties(replaceProperties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("updateMetadataElementInStore", urlTemplate, requestBody, new Object[]{this.serverName, userId, metadataElementGUID});
    }

    public void updateMetadataElementStatusInStore(String userId, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, ElementStatus newElementStatus, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementStatusInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/metadata-elements/{2}/update-status";
        this.invalidParameterHandler.validateUserId(userId, "updateMetadataElementStatusInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateMetadataElementStatusInStore");
        UpdateStatusRequestBody requestBody = new UpdateStatusRequestBody();
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setNewStatus(newElementStatus);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("updateMetadataElementStatusInStore", urlTemplate, requestBody, new Object[]{this.serverName, userId, metadataElementGUID});
    }

    public void updateMetadataElementEffectivityInStore(String userId, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementEffectivityInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/metadata-elements/{2}/update-effectivity";
        this.invalidParameterHandler.validateUserId(userId, "updateMetadataElementEffectivityInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateMetadataElementEffectivityInStore");
        UpdateEffectivityDatesRequestBody requestBody = new UpdateEffectivityDatesRequestBody();
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("updateMetadataElementEffectivityInStore", urlTemplate, requestBody, new Object[]{this.serverName, userId, metadataElementGUID});
    }

    public void deleteMetadataElementInStore(String userId, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/metadata-elements/{2}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "deleteMetadataElementInStore");
        UpdateRequestBody requestBody = new UpdateRequestBody();
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("deleteMetadataElementInStore", urlTemplate, requestBody, new Object[]{this.serverName, userId, metadataElementGUID});
    }

    public void classifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "classifyMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/metadata-elements/{2}/classifications/{3}/new";
        this.invalidParameterHandler.validateUserId(userId, "classifyMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "classifyMetadataElementInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "classifyMetadataElementInStore");
        NewClassificationRequestBody requestBody = new NewClassificationRequestBody();
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setProperties(properties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("classifyMetadataElementInStore", urlTemplate, requestBody, new Object[]{this.serverName, userId, metadataElementGUID, classificationName});
    }

    public void reclassifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "reclassifyMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/metadata-elements/{2}/classifications/{3}/update-properties";
        this.invalidParameterHandler.validateUserId(userId, "reclassifyMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "reclassifyMetadataElementInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "reclassifyMetadataElementInStore");
        UpdatePropertiesRequestBody requestBody = new UpdatePropertiesRequestBody();
        requestBody.setReplaceProperties(replaceProperties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("reclassifyMetadataElementInStore", urlTemplate, requestBody, new Object[]{this.serverName, userId, metadataElementGUID, classificationName});
    }

    public void updateClassificationEffectivityInStore(String userId, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateClassificationEffectivityInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/metadata-elements/{2}/classifications/{3}/update-effectivity";
        this.invalidParameterHandler.validateUserId(userId, "updateClassificationEffectivityInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateClassificationEffectivityInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "updateClassificationEffectivityInStore");
        UpdateEffectivityDatesRequestBody requestBody = new UpdateEffectivityDatesRequestBody();
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("updateClassificationEffectivityInStore", urlTemplate, requestBody, new Object[]{this.serverName, userId, metadataElementGUID, classificationName});
    }

    public void unclassifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unclassifyMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/metadata-elements/{2}/classifications/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "unclassifyMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "unclassifyMetadataElementInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "unclassifyMetadataElementInStore");
        UpdateRequestBody requestBody = new UpdateRequestBody();
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("unclassifyMetadataElementInStore", urlTemplate, requestBody, new Object[]{this.serverName, userId, metadataElementGUID, classificationName});
    }

    public String createRelatedElementsInStore(String userId, String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createRelatedElementsInStore";
        String elementTypeParameterName = "relationshipTypeName";
        String end1ParameterName = "metadataElement1GUID";
        String end2ParameterName = "metadataElement2GUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/related-elements/new";
        this.invalidParameterHandler.validateUserId(userId, "createRelatedElementsInStore");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "createRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(metadataElement1GUID, "metadataElement1GUID", "createRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(metadataElement2GUID, "metadataElement2GUID", "createRelatedElementsInStore");
        NewRelatedElementsRequestBody requestBody = new NewRelatedElementsRequestBody();
        requestBody.setTypeName(relationshipTypeName);
        requestBody.setMetadataElement1GUID(metadataElement1GUID);
        requestBody.setMetadataElement2GUID(metadataElement2GUID);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createRelatedElementsInStore", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updateRelatedElementsInStore(String userId, String relationshipGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateRelatedElementsInStore";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/related-elements/{2}/update-properties";
        this.invalidParameterHandler.validateUserId(userId, "updateRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "updateRelatedElementsInStore");
        UpdatePropertiesRequestBody requestBody = new UpdatePropertiesRequestBody();
        requestBody.setReplaceProperties(replaceProperties);
        requestBody.setProperties(properties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("updateRelatedElementsInStore", urlTemplate, requestBody, new Object[]{this.serverName, userId, relationshipGUID});
    }

    public void updateRelatedElementsEffectivityInStore(String userId, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateRelatedElementsEffectivityInStore";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/related-elements/{2}/update-effectivity";
        this.invalidParameterHandler.validateUserId(userId, "updateRelatedElementsEffectivityInStore");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "updateRelatedElementsEffectivityInStore");
        UpdateEffectivityDatesRequestBody requestBody = new UpdateEffectivityDatesRequestBody();
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("updateRelatedElementsEffectivityInStore", urlTemplate, requestBody, new Object[]{this.serverName, userId, relationshipGUID});
    }

    public void deleteRelatedElementsInStore(String userId, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteRelatedElementsInStore";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/related-elements/{2}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "deleteRelatedElementsInStore");
        UpdateRequestBody requestBody = new UpdateRequestBody();
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("deleteRelatedElementsInStore", urlTemplate, requestBody, new Object[]{this.serverName, userId, relationshipGUID});
    }

    public void updateActionTargetStatus(String userId, String actionTargetGUID, GovernanceActionStatus status, Date startDate, Date completionDate) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateActionTargetStatus";
        String guidParameterName = "actionTargetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions/action-targets/update";
        this.invalidParameterHandler.validateUserId(userId, "updateActionTargetStatus");
        this.invalidParameterHandler.validateGUID(actionTargetGUID, "actionTargetGUID", "updateActionTargetStatus");
        ActionTargetStatusRequestBody requestBody = new ActionTargetStatusRequestBody();
        requestBody.setActionTargetGUID(actionTargetGUID);
        requestBody.setStatus(status);
        requestBody.setStartDate(startDate);
        requestBody.setCompletionDate(completionDate);
        this.restClient.callVoidPostRESTCall("updateActionTargetStatus", urlTemplate, requestBody, new Object[]{this.serverName, userId});
    }

    public void updateGovernanceActionStatus(String userId, String governanceActionGUID, GovernanceActionStatus governanceActionStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceActionStatus";
        String guidParameterName = "governanceActionGUID";
        String statusParameterName = "governanceActionStatus";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions/{2}/status/update";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceActionStatus");
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", "updateGovernanceActionStatus");
        this.invalidParameterHandler.validateEnum((Object)governanceActionStatus, "governanceActionStatus", "updateGovernanceActionStatus");
        StatusRequestBody requestBody = new StatusRequestBody();
        requestBody.setStatus(governanceActionStatus);
        this.restClient.callVoidPostRESTCall("updateGovernanceActionStatus", urlTemplate, requestBody, new Object[]{this.serverName, userId, governanceActionGUID});
    }

    public void recordCompletionStatus(String userId, String governanceActionGUID, Map<String, String> requestParameters, CompletionStatus status, List<String> outputGuards, List<NewActionTarget> newActionTargets) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "recordCompletionStatus";
        String statusParameterName = "status";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions/{2}/completion-status";
        this.invalidParameterHandler.validateUserId(userId, "recordCompletionStatus");
        this.invalidParameterHandler.validateEnum((Object)status, "status", "recordCompletionStatus");
        CompletionStatusRequestBody requestBody = new CompletionStatusRequestBody();
        requestBody.setRequestParameters(requestParameters);
        requestBody.setStatus(status);
        requestBody.setOutputGuards(outputGuards);
        requestBody.setNewActionTargets(newActionTargets);
        this.restClient.callVoidPostRESTCall("recordCompletionStatus", urlTemplate, requestBody, new Object[]{this.serverName, userId, governanceActionGUID});
    }

    public String initiateGovernanceAction(String userId, String qualifiedName, int domainIdentifier, String displayName, String description, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, List<String> receivedGuards, Date startTime, String governanceEngineName, String requestType, Map<String, String> requestParameters, String originatorServiceName, String originatorEngineName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "initiateGovernanceAction";
        String qualifiedNameParameterName = "qualifiedName";
        String engineNameParameterName = "governanceEngineName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-engines/{2}/governance-actions/initiate";
        this.invalidParameterHandler.validateUserId(userId, "initiateGovernanceAction");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "initiateGovernanceAction");
        this.invalidParameterHandler.validateName(governanceEngineName, "governanceEngineName", "initiateGovernanceAction");
        GovernanceActionRequestBody requestBody = new GovernanceActionRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDomainIdentifier(domainIdentifier);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setRequestSourceGUIDs(requestSourceGUIDs);
        requestBody.setActionTargets(actionTargets);
        requestBody.setReceivedGuards(receivedGuards);
        requestBody.setStartTime(startTime);
        requestBody.setRequestType(requestType);
        requestBody.setRequestParameters(requestParameters);
        requestBody.setOriginatorServiceName(originatorServiceName);
        requestBody.setOriginatorEngineName(originatorEngineName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("initiateGovernanceAction", urlTemplate, requestBody, new Object[]{this.serverName, userId, governanceEngineName});
        return restResult.getGUID();
    }

    public String initiateGovernanceActionProcess(String userId, String processQualifiedName, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Date startTime, Map<String, String> requestParameters, String originatorServiceName, String originatorEngineName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "initiateGovernanceAction";
        String qualifiedNameParameterName = "processQualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-processes/initiate";
        this.invalidParameterHandler.validateUserId(userId, "initiateGovernanceAction");
        this.invalidParameterHandler.validateName(processQualifiedName, "processQualifiedName", "initiateGovernanceAction");
        GovernanceActionProcessRequestBody requestBody = new GovernanceActionProcessRequestBody();
        requestBody.setProcessQualifiedName(processQualifiedName);
        requestBody.setRequestSourceGUIDs(requestSourceGUIDs);
        requestBody.setActionTargets(actionTargets);
        requestBody.setStartTime(startTime);
        requestBody.setRequestParameters(requestParameters);
        requestBody.setOriginatorServiceName(originatorServiceName);
        requestBody.setOriginatorEngineName(originatorEngineName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("initiateGovernanceAction", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public GovernanceActionElement getGovernanceAction(String userId, String governanceActionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceAction";
        String guidParameterName = "governanceActionGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceAction");
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", "getGovernanceAction");
        GovernanceActionElementResponse restResult = this.restClient.callGovernanceActionGetRESTCall("getGovernanceAction", urlTemplate, this.serverName, userId, governanceActionGUID);
        return restResult.getElement();
    }

    public void claimGovernanceAction(String userId, String governanceActionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "claimGovernanceAction";
        String guidParameterName = "governanceActionGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions/{2}/claim";
        this.invalidParameterHandler.validateUserId(userId, "claimGovernanceAction");
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", "claimGovernanceAction");
        this.restClient.callVoidPostRESTCall("claimGovernanceAction", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, governanceActionGUID});
    }

    public List<GovernanceActionElement> getGovernanceActions(String userId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActions";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActions");
        GovernanceActionElementsResponse restResult = this.restClient.callGovernanceActionsGetRESTCall("getGovernanceActions", urlTemplate, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<GovernanceActionElement> getActiveGovernanceActions(String userId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getActiveGovernanceActions";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions/active?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "getActiveGovernanceActions");
        GovernanceActionElementsResponse restResult = this.restClient.callGovernanceActionsGetRESTCall("getActiveGovernanceActions", urlTemplate, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<GovernanceActionElement> getActiveClaimedGovernanceActions(String userId, String governanceEngineGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getActiveClaimedGovernanceActions";
        String guidParameterName = "governanceEngineGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-engines/{2}/active-governance-actions?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getActiveClaimedGovernanceActions");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "getActiveClaimedGovernanceActions");
        GovernanceActionElementsResponse restResult = this.restClient.callGovernanceActionsGetRESTCall("getActiveClaimedGovernanceActions", urlTemplate, this.serverName, userId, governanceEngineGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public String createIncidentReport(String userId, String qualifiedName, int domainIdentifier, String background, List<IncidentImpactedElement> impactedResources, List<IncidentDependency> previousIncidents, Map<String, Integer> incidentClassifiers, Map<String, String> additionalProperties, String originatorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createIncidentReport";
        String qualifiedNameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/incident-reports";
        this.invalidParameterHandler.validateUserId(userId, "createIncidentReport");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createIncidentReport");
        IncidentReportRequestBody requestBody = new IncidentReportRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDomainIdentifier(domainIdentifier);
        requestBody.setBackground(background);
        requestBody.setImpactedResources(impactedResources);
        requestBody.setPreviousIncidents(previousIncidents);
        requestBody.setIncidentClassifiers(incidentClassifiers);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setOriginatorGUID(originatorGUID);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createIncidentReport", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void linkElementsAsPeerDuplicates(String userId, String metadataElement1GUID, String metadataElement2GUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, boolean setKnownDuplicate) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkElementsAsPeerDuplicates";
        String end1ParameterName = "metadataElement1GUID";
        String end2ParameterName = "metadataElement2GUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/related-elements/link-as-peer-duplicate";
        this.invalidParameterHandler.validateUserId(userId, "linkElementsAsPeerDuplicates");
        this.invalidParameterHandler.validateGUID(metadataElement1GUID, "metadataElement1GUID", "linkElementsAsPeerDuplicates");
        this.invalidParameterHandler.validateGUID(metadataElement2GUID, "metadataElement2GUID", "linkElementsAsPeerDuplicates");
        PeerDuplicatesRequestBody requestBody = new PeerDuplicatesRequestBody();
        requestBody.setMetadataElement1GUID(metadataElement1GUID);
        requestBody.setMetadataElement2GUID(metadataElement2GUID);
        requestBody.setStatusIdentifier(statusIdentifier);
        requestBody.setSteward(steward);
        requestBody.setStewardTypeName(stewardTypeName);
        requestBody.setStewardPropertyName(stewardPropertyName);
        requestBody.setSource(source);
        requestBody.setNotes(notes);
        requestBody.setSetKnownDuplicate(setKnownDuplicate);
        this.restClient.callVoidPostRESTCall("linkElementsAsPeerDuplicates", urlTemplate, requestBody, new Object[]{this.serverName, userId});
    }

    public void linkConsolidatedDuplicate(String userId, String consolidatedElementGUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, List<String> sourceElementGUIDs) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkConsolidatedDuplicate";
        String consolidatedElementGUIDParameterName = "consolidatedElementGUID";
        String sourceElementGUIDsParameterName = "sourceElementGUIDs";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/related-elements/link-as-consolidated-duplicate";
        this.invalidParameterHandler.validateUserId(userId, "linkConsolidatedDuplicate");
        this.invalidParameterHandler.validateGUID(consolidatedElementGUID, "consolidatedElementGUID", "linkConsolidatedDuplicate");
        this.invalidParameterHandler.validateObject(sourceElementGUIDs, "sourceElementGUIDs", "linkConsolidatedDuplicate");
        ConsolidatedDuplicatesRequestBody requestBody = new ConsolidatedDuplicatesRequestBody();
        requestBody.setConsolidatedElementGUID(consolidatedElementGUID);
        requestBody.setStatusIdentifier(statusIdentifier);
        requestBody.setSteward(steward);
        requestBody.setStewardTypeName(stewardTypeName);
        requestBody.setStewardPropertyName(stewardPropertyName);
        requestBody.setSource(source);
        requestBody.setNotes(notes);
        requestBody.setSourceElementGUIDs(sourceElementGUIDs);
        this.restClient.callVoidPostRESTCall("linkConsolidatedDuplicate", urlTemplate, requestBody, new Object[]{this.serverName, userId});
    }
}

