/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.client.rest.GovernanceEngineRESTClient;
import org.odpi.openmetadata.accessservices.governanceengine.connectors.outtopic.GovernanceEngineOutTopicClientConnector;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceEngineElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceServiceElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.RegisteredGovernanceServiceElement;
import org.odpi.openmetadata.accessservices.governanceengine.rest.DeleteRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceEngineElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceEngineElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceServiceElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceServiceElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceServiceRegistrationRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NewGovernanceEngineRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NewGovernanceServiceRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.RegisteredGovernanceServiceResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateGovernanceEngineRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateGovernanceServiceRequestBody;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

public class GovernanceEngineConfigurationClient {
    private String serverName;
    private String serverPlatformURLRoot;
    private GovernanceEngineRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();
    private NullRequestBody nullRequestBody = new NullRequestBody();
    private AuditLog auditLog = null;
    private static final String serviceName = AccessServiceDescription.GOVERNANCE_ENGINE_OMAS.getAccessServiceFullName();
    private GovernanceEngineOutTopicClientConnector configurationEventTopicConnector = null;

    public GovernanceEngineConfigurationClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceEngineRESTClient(serverName, serverPlatformURLRoot);
    }

    public GovernanceEngineConfigurationClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceEngineRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceEngineConfigurationClient(String serverName, String serverPlatformURLRoot, GovernanceEngineRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
        this.auditLog = auditLog;
    }

    public String getConfigurationServerName() {
        return this.serverName;
    }

    public String createGovernanceEngine(String userId, String governanceEngineType, String qualifiedName, String displayName, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceEngine";
        String engineTypeParameterName = "governanceEngineType";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-engines/new/{2}";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceEngine");
        this.invalidParameterHandler.validateName(governanceEngineType, "governanceEngineType", "createGovernanceEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createGovernanceEngine");
        NewGovernanceEngineRequestBody requestBody = new NewGovernanceEngineRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGovernanceEngine", urlTemplate, requestBody, new Object[]{this.serverName, userId, governanceEngineType});
        return restResult.getGUID();
    }

    public GovernanceEngineElement getGovernanceEngineByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceEngineByGUID";
        String guidParameterName = "guid";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-engines/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceEngineByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getGovernanceEngineByGUID");
        GovernanceEngineElementResponse restResult = this.restClient.callGovernanceEngineGetRESTCall("getGovernanceEngineByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }

    public GovernanceEngineElement getGovernanceEngineByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceEngineByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-engines/by-name/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceEngineByName");
        this.invalidParameterHandler.validateName(name, "name", "getGovernanceEngineByName");
        GovernanceEngineElementResponse restResult = this.restClient.callGovernanceEngineGetRESTCall("getGovernanceEngineByName", urlTemplate, this.serverName, userId, name);
        return restResult.getElement();
    }

    public List<GovernanceEngineElement> getAllGovernanceEngines(String userId, String governanceEngineType, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllGovernanceEngines";
        String engineTypeParameterName = "governanceEngineType";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-engines/{2}?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getAllGovernanceEngines");
        this.invalidParameterHandler.validateName(governanceEngineType, "governanceEngineType", "getAllGovernanceEngines");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getAllGovernanceEngines");
        GovernanceEngineElementsResponse restResult = this.restClient.callGovernanceEnginesGetRESTCall("getAllGovernanceEngines", urlTemplate, this.serverName, userId, governanceEngineType, Integer.toString(startingFrom), Integer.toString(maximumResults));
        return restResult.getElements();
    }

    public void updateGovernanceEngine(String userId, String guid, String qualifiedName, String displayName, String description, String typeDescription, String version, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceEngine";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-engines/{2}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceEngine");
        this.invalidParameterHandler.validateGUID(guid, "guid", "updateGovernanceEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updateGovernanceEngine");
        UpdateGovernanceEngineRequestBody requestBody = new UpdateGovernanceEngineRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setTypeDescription(typeDescription);
        requestBody.setVersion(version);
        requestBody.setPatchLevel(patchLevel);
        requestBody.setSource(source);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExtendedProperties(extendedProperties);
        this.restClient.callVoidPostRESTCall("updateGovernanceEngine", urlTemplate, requestBody, new Object[]{this.serverName, userId, guid});
    }

    public void deleteGovernanceEngine(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteGovernanceEngine";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-engines/{2}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteGovernanceEngine");
        this.invalidParameterHandler.validateGUID(guid, "guid", "deleteGovernanceEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteGovernanceEngine");
        DeleteRequestBody requestBody = new DeleteRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        this.restClient.callVoidPostRESTCall("deleteGovernanceEngine", urlTemplate, requestBody, new Object[]{this.serverName, userId, guid});
    }

    public String createGovernanceService(String userId, String governanceServiceType, String qualifiedName, String displayName, String description, Connection connection) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceService";
        String serviceTypeParameterName = "governanceServiceType";
        String nameParameterName = "qualifiedName";
        String connectionParameterName = "connection";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-services/new/{2}";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceService");
        this.invalidParameterHandler.validateName(governanceServiceType, "governanceServiceType", "createGovernanceService");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createGovernanceService");
        this.invalidParameterHandler.validateConnection(connection, "connection", "createGovernanceService");
        NewGovernanceServiceRequestBody requestBody = new NewGovernanceServiceRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setConnection(connection);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGovernanceService", urlTemplate, requestBody, new Object[]{this.serverName, userId, governanceServiceType});
        return restResult.getGUID();
    }

    public GovernanceServiceElement getGovernanceServiceByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceServiceByGUID";
        String guidParameterName = "guid";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-services/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceServiceByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getGovernanceServiceByGUID");
        GovernanceServiceElementResponse restResult = this.restClient.callGovernanceServiceGetRESTCall("getGovernanceServiceByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }

    public GovernanceServiceElement getGovernanceServiceByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceServiceByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-services/by-name/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceServiceByName");
        this.invalidParameterHandler.validateName(name, "name", "getGovernanceServiceByName");
        GovernanceServiceElementResponse restResult = this.restClient.callGovernanceServiceGetRESTCall("getGovernanceServiceByName", urlTemplate, this.serverName, userId, name);
        return restResult.getElement();
    }

    public List<GovernanceServiceElement> getAllGovernanceServices(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllGovernanceServices";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-services?startingFrom={2}&maximumResults={3}";
        this.invalidParameterHandler.validateUserId(userId, "getAllGovernanceServices");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getAllGovernanceServices");
        GovernanceServiceElementsResponse restResult = this.restClient.callGovernanceServicesGetRESTCall("getAllGovernanceServices", urlTemplate, this.serverName, userId, Integer.toString(startingFrom), Integer.toString(maximumResults));
        return restResult.getElements();
    }

    public List<String> getGovernanceServiceRegistrations(String userId, String governanceServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceServiceRegistrations";
        String guidParameter = "governanceServiceGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-services/{2}/registrations";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceServiceRegistrations");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "getGovernanceServiceRegistrations");
        GUIDListResponse restResult = this.restClient.callGUIDListGetRESTCall("getGovernanceServiceRegistrations", urlTemplate, new Object[]{this.serverName, userId, governanceServiceGUID});
        return restResult.getGUIDs();
    }

    public void updateGovernanceService(String userId, String guid, String qualifiedName, String displayName, String description, Connection connection, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceService";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String connectionParameterName = "connection";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-services/{2}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceService");
        this.invalidParameterHandler.validateGUID(guid, "guid", "updateGovernanceService");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updateGovernanceService");
        this.invalidParameterHandler.validateConnection(connection, "connection", "updateGovernanceService");
        UpdateGovernanceServiceRequestBody requestBody = new UpdateGovernanceServiceRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setConnection(connection);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExtendedProperties(extendedProperties);
        this.restClient.callVoidPostRESTCall("updateGovernanceService", urlTemplate, requestBody, new Object[]{this.serverName, userId, guid});
    }

    public void deleteGovernanceService(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteGovernanceService";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-services/{2}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteGovernanceService");
        this.invalidParameterHandler.validateGUID(guid, "guid", "deleteGovernanceService");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteGovernanceService");
        DeleteRequestBody requestBody = new DeleteRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        this.restClient.callVoidPostRESTCall("deleteGovernanceService", urlTemplate, requestBody, new Object[]{this.serverName, userId, guid});
    }

    public void registerGovernanceServiceWithEngine(String userId, String governanceEngineGUID, String governanceServiceGUID, String governanceRequestType, Map<String, String> requestParameters) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "registerGovernanceServiceWithEngine";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        String governanceRequestTypesParameter = "governanceRequestType";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-engines/{2}/governance-services";
        this.invalidParameterHandler.validateUserId(userId, "registerGovernanceServiceWithEngine");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "registerGovernanceServiceWithEngine");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "registerGovernanceServiceWithEngine");
        this.invalidParameterHandler.validateName(governanceRequestType, "governanceRequestType", "registerGovernanceServiceWithEngine");
        GovernanceServiceRegistrationRequestBody requestBody = new GovernanceServiceRegistrationRequestBody();
        requestBody.setGovernanceServiceGUID(governanceServiceGUID);
        requestBody.setRequestType(governanceRequestType);
        requestBody.setRequestParameters(requestParameters);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("registerGovernanceServiceWithEngine", urlTemplate, requestBody, new Object[]{this.serverName, userId, governanceEngineGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
    }

    public RegisteredGovernanceServiceElement getRegisteredGovernanceService(String userId, String governanceEngineGUID, String governanceServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredGovernanceService";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-engines/{2}/governance-services/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredGovernanceService");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "getRegisteredGovernanceService");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "getRegisteredGovernanceService");
        RegisteredGovernanceServiceResponse restResult = this.restClient.callRegisteredGovernanceServiceGetRESTCall("getRegisteredGovernanceService", urlTemplate, this.serverName, userId, governanceEngineGUID, governanceServiceGUID);
        return restResult.getRegisteredGovernanceService();
    }

    public List<String> getRegisteredGovernanceServices(String userId, String governanceEngineGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredGovernanceServices";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-engines/{2}/governance-services?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredGovernanceServices");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "getRegisteredGovernanceServices");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getRegisteredGovernanceServices");
        GUIDListResponse restResult = this.restClient.callGUIDListGetRESTCall("getRegisteredGovernanceServices", urlTemplate, new Object[]{this.serverName, userId, governanceEngineGUID, startingFrom, maximumResults});
        return restResult.getGUIDs();
    }

    public void unregisterGovernanceServiceFromEngine(String userId, String governanceEngineGUID, String governanceServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unregisterGovernanceServiceFromEngine";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-engines/{2}/governance-services/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "unregisterGovernanceServiceFromEngine");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "unregisterGovernanceServiceFromEngine");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "unregisterGovernanceServiceFromEngine");
        this.restClient.callVoidPostRESTCall("unregisterGovernanceServiceFromEngine", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, governanceEngineGUID, governanceServiceGUID});
    }
}

