/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.client;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.api.GovernanceProcessingInterface;
import org.odpi.openmetadata.accessservices.governanceengine.api.SpecialGovernanceActionInterface;
import org.odpi.openmetadata.accessservices.governanceengine.client.rest.GovernanceEngineRESTClient;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceActionElement;
import org.odpi.openmetadata.accessservices.governanceengine.rest.ActionTargetStatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.CompletionStatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.ConsolidatedDuplicatesRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionProcessRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.PeerDuplicatesRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.StatusRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.gaf.client.OpenMetadataStoreClientBase;
import org.odpi.openmetadata.commonservices.gaf.client.rest.OpenMetadataStoreRESTClient;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;

public class GovernanceEngineClient
extends OpenMetadataStoreClientBase
implements GovernanceProcessingInterface,
SpecialGovernanceActionInterface {
    private final GovernanceEngineRESTClient restClient;
    private final NullRequestBody nullRequestBody = new NullRequestBody();
    private static final String serviceURLMarker = "governance-engine";

    public GovernanceEngineClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot);
        this.restClient = new GovernanceEngineRESTClient(serverName, serverPlatformURLRoot);
    }

    public GovernanceEngineClient(String serverName, String serverPlatformURLRoot, String serverUserId, String serverPassword) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot, serverUserId, serverPassword);
        this.restClient = new GovernanceEngineRESTClient(serverName, serverPlatformURLRoot, serverUserId, serverPassword);
    }

    public GovernanceEngineClient(String serverName, String serverPlatformURLRoot, GovernanceEngineRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot, (OpenMetadataStoreRESTClient)restClient, maxPageSize);
        this.restClient = restClient;
    }

    public void updateActionTargetStatus(String userId, String actionTargetGUID, GovernanceActionStatus status, Date startDate, Date completionDate, String completionMessage) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateActionTargetStatus";
        String guidParameterName = "actionTargetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions/action-targets/update";
        this.invalidParameterHandler.validateUserId(userId, "updateActionTargetStatus");
        this.invalidParameterHandler.validateGUID(actionTargetGUID, "actionTargetGUID", "updateActionTargetStatus");
        ActionTargetStatusRequestBody requestBody = new ActionTargetStatusRequestBody();
        requestBody.setActionTargetGUID(actionTargetGUID);
        requestBody.setStatus(status);
        requestBody.setStartDate(startDate);
        requestBody.setCompletionDate(completionDate);
        requestBody.setCompletionMessage(completionMessage);
        this.restClient.callVoidPostRESTCall("updateActionTargetStatus", urlTemplate, requestBody, new Object[]{this.serverName, userId});
    }

    public void updateGovernanceActionStatus(String userId, String governanceActionGUID, GovernanceActionStatus governanceActionStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceActionStatus";
        String guidParameterName = "governanceActionGUID";
        String statusParameterName = "governanceActionStatus";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions/{2}/status/update";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceActionStatus");
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", "updateGovernanceActionStatus");
        this.invalidParameterHandler.validateEnum((Object)governanceActionStatus, "governanceActionStatus", "updateGovernanceActionStatus");
        StatusRequestBody requestBody = new StatusRequestBody();
        requestBody.setStatus(governanceActionStatus);
        this.restClient.callVoidPostRESTCall("updateGovernanceActionStatus", urlTemplate, requestBody, new Object[]{this.serverName, userId, governanceActionGUID});
    }

    public void recordCompletionStatus(String userId, String governanceActionGUID, Map<String, String> requestParameters, CompletionStatus status, List<String> outputGuards, List<NewActionTarget> newActionTargets, String completionMessage) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "recordCompletionStatus";
        String statusParameterName = "status";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions/{2}/completion-status";
        this.invalidParameterHandler.validateUserId(userId, "recordCompletionStatus");
        this.invalidParameterHandler.validateEnum((Object)status, "status", "recordCompletionStatus");
        CompletionStatusRequestBody requestBody = new CompletionStatusRequestBody();
        requestBody.setRequestParameters(requestParameters);
        requestBody.setStatus(status);
        requestBody.setOutputGuards(outputGuards);
        requestBody.setNewActionTargets(newActionTargets);
        requestBody.setCompletionMessage(completionMessage);
        this.restClient.callVoidPostRESTCall("recordCompletionStatus", urlTemplate, requestBody, new Object[]{this.serverName, userId, governanceActionGUID});
    }

    public String initiateGovernanceAction(String userId, String qualifiedName, int domainIdentifier, String displayName, String description, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, List<String> receivedGuards, Date startTime, String governanceEngineName, String requestType, Map<String, String> requestParameters, String processName, String requestSourceName, String originatorServiceName, String originatorEngineName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "initiateGovernanceAction";
        String qualifiedNameParameterName = "qualifiedName";
        String engineNameParameterName = "governanceEngineName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-engines/{2}/governance-actions/initiate";
        this.invalidParameterHandler.validateUserId(userId, "initiateGovernanceAction");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "initiateGovernanceAction");
        this.invalidParameterHandler.validateName(governanceEngineName, "governanceEngineName", "initiateGovernanceAction");
        GovernanceActionRequestBody requestBody = new GovernanceActionRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDomainIdentifier(domainIdentifier);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setRequestSourceGUIDs(requestSourceGUIDs);
        requestBody.setActionTargets(actionTargets);
        requestBody.setReceivedGuards(receivedGuards);
        requestBody.setStartTime(startTime);
        requestBody.setRequestType(requestType);
        requestBody.setRequestParameters(requestParameters);
        requestBody.setProcessName(processName);
        requestBody.setRequestSourceName(requestSourceName);
        requestBody.setOriginatorServiceName(originatorServiceName);
        requestBody.setOriginatorEngineName(originatorEngineName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("initiateGovernanceAction", urlTemplate, requestBody, new Object[]{this.serverName, userId, governanceEngineName});
        return restResult.getGUID();
    }

    public String initiateGovernanceActionProcess(String userId, String processQualifiedName, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Date startTime, Map<String, String> requestParameters, String originatorServiceName, String originatorEngineName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "initiateGovernanceAction";
        String qualifiedNameParameterName = "processQualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-processes/initiate";
        this.invalidParameterHandler.validateUserId(userId, "initiateGovernanceAction");
        this.invalidParameterHandler.validateName(processQualifiedName, "processQualifiedName", "initiateGovernanceAction");
        GovernanceActionProcessRequestBody requestBody = new GovernanceActionProcessRequestBody();
        requestBody.setProcessQualifiedName(processQualifiedName);
        requestBody.setRequestSourceGUIDs(requestSourceGUIDs);
        requestBody.setActionTargets(actionTargets);
        requestBody.setStartTime(startTime);
        requestBody.setRequestParameters(requestParameters);
        requestBody.setOriginatorServiceName(originatorServiceName);
        requestBody.setOriginatorEngineName(originatorEngineName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("initiateGovernanceAction", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public GovernanceActionElement getGovernanceAction(String userId, String governanceActionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceAction";
        String guidParameterName = "governanceActionGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceAction");
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", "getGovernanceAction");
        GovernanceActionElementResponse restResult = this.restClient.callGovernanceActionGetRESTCall("getGovernanceAction", urlTemplate, this.serverName, userId, governanceActionGUID);
        return restResult.getElement();
    }

    public void claimGovernanceAction(String userId, String governanceActionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "claimGovernanceAction";
        String guidParameterName = "governanceActionGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions/{2}/claim";
        this.invalidParameterHandler.validateUserId(userId, "claimGovernanceAction");
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", "claimGovernanceAction");
        this.restClient.callVoidPostRESTCall("claimGovernanceAction", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, governanceActionGUID});
    }

    public List<GovernanceActionElement> getGovernanceActions(String userId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActions";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActions");
        GovernanceActionElementsResponse restResult = this.restClient.callGovernanceActionsGetRESTCall("getGovernanceActions", urlTemplate, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<GovernanceActionElement> getActiveGovernanceActions(String userId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getActiveGovernanceActions";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions/active?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "getActiveGovernanceActions");
        GovernanceActionElementsResponse restResult = this.restClient.callGovernanceActionsGetRESTCall("getActiveGovernanceActions", urlTemplate, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<GovernanceActionElement> getActiveClaimedGovernanceActions(String userId, String governanceEngineGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getActiveClaimedGovernanceActions";
        String guidParameterName = "governanceEngineGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-engines/{2}/active-governance-actions?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getActiveClaimedGovernanceActions");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "getActiveClaimedGovernanceActions");
        GovernanceActionElementsResponse restResult = this.restClient.callGovernanceActionsGetRESTCall("getActiveClaimedGovernanceActions", urlTemplate, this.serverName, userId, governanceEngineGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<GovernanceActionElement> findGovernanceActions(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGovernanceActionTypes";
        String searchStringParameterName = "searchString";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions/by-search-string?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "findGovernanceActionTypes");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGovernanceActionTypes");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        GovernanceActionElementsResponse restResult = this.restClient.callGovernanceActionsGetRESTCall("findGovernanceActionTypes", urlTemplate, requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<GovernanceActionElement> getGovernanceActionsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActionsByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions/by-name?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActionsByName");
        this.invalidParameterHandler.validateName(name, "name", "getGovernanceActionsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        GovernanceActionElementsResponse restResult = this.restClient.callGovernanceActionsGetRESTCall("getGovernanceActionsByName", urlTemplate, requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public void linkElementsAsPeerDuplicates(String userId, String metadataElement1GUID, String metadataElement2GUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, boolean setKnownDuplicate) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkElementsAsPeerDuplicates";
        String end1ParameterName = "metadataElement1GUID";
        String end2ParameterName = "metadataElement2GUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/related-elements/link-as-peer-duplicate";
        this.invalidParameterHandler.validateUserId(userId, "linkElementsAsPeerDuplicates");
        this.invalidParameterHandler.validateGUID(metadataElement1GUID, "metadataElement1GUID", "linkElementsAsPeerDuplicates");
        this.invalidParameterHandler.validateGUID(metadataElement2GUID, "metadataElement2GUID", "linkElementsAsPeerDuplicates");
        PeerDuplicatesRequestBody requestBody = new PeerDuplicatesRequestBody();
        requestBody.setMetadataElement1GUID(metadataElement1GUID);
        requestBody.setMetadataElement2GUID(metadataElement2GUID);
        requestBody.setStatusIdentifier(statusIdentifier);
        requestBody.setSteward(steward);
        requestBody.setStewardTypeName(stewardTypeName);
        requestBody.setStewardPropertyName(stewardPropertyName);
        requestBody.setSource(source);
        requestBody.setNotes(notes);
        requestBody.setSetKnownDuplicate(setKnownDuplicate);
        this.restClient.callVoidPostRESTCall("linkElementsAsPeerDuplicates", urlTemplate, requestBody, new Object[]{this.serverName, userId});
    }

    public void linkConsolidatedDuplicate(String userId, String consolidatedElementGUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, List<String> sourceElementGUIDs) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkConsolidatedDuplicate";
        String consolidatedElementGUIDParameterName = "consolidatedElementGUID";
        String sourceElementGUIDsParameterName = "sourceElementGUIDs";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/open-metadata-store/related-elements/link-as-consolidated-duplicate";
        this.invalidParameterHandler.validateUserId(userId, "linkConsolidatedDuplicate");
        this.invalidParameterHandler.validateGUID(consolidatedElementGUID, "consolidatedElementGUID", "linkConsolidatedDuplicate");
        this.invalidParameterHandler.validateObject(sourceElementGUIDs, "sourceElementGUIDs", "linkConsolidatedDuplicate");
        ConsolidatedDuplicatesRequestBody requestBody = new ConsolidatedDuplicatesRequestBody();
        requestBody.setConsolidatedElementGUID(consolidatedElementGUID);
        requestBody.setStatusIdentifier(statusIdentifier);
        requestBody.setSteward(steward);
        requestBody.setStewardTypeName(stewardTypeName);
        requestBody.setStewardPropertyName(stewardPropertyName);
        requestBody.setSource(source);
        requestBody.setNotes(notes);
        requestBody.setSourceElementGUIDs(sourceElementGUIDs);
        this.restClient.callVoidPostRESTCall("linkConsolidatedDuplicate", urlTemplate, requestBody, new Object[]{this.serverName, userId});
    }
}

