/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.client;

import org.odpi.openmetadata.accessservices.governanceengine.api.GovernanceEngineEventListener;
import org.odpi.openmetadata.accessservices.governanceengine.client.rest.GovernanceEngineRESTClient;
import org.odpi.openmetadata.accessservices.governanceengine.connectors.outtopic.GovernanceEngineOutTopicClientConnector;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.ffdc.OMAGOCFErrorCode;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

public class GovernanceEngineEventClient {
    private final String serverName;
    private final String serverPlatformURLRoot;
    private final GovernanceEngineRESTClient restClient;
    private final String callerId;
    private final AuditLog auditLog;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private static final String serviceName = AccessServiceDescription.GOVERNANCE_ENGINE_OMAS.getAccessServiceFullName();
    private GovernanceEngineOutTopicClientConnector configurationEventTopicConnector = null;

    public GovernanceEngineEventClient(String serverName, String serverPlatformURLRoot, GovernanceEngineRESTClient restClient, int maxPageSize, AuditLog auditLog, String callerId) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
        this.auditLog = auditLog;
        this.callerId = callerId;
    }

    public void registerListener(String userId, GovernanceEngineEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "registerListener";
        String nameParameter = "listener";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/topics/out-topic-connection/{2}";
        this.invalidParameterHandler.validateUserId(userId, "registerListener");
        this.invalidParameterHandler.validateObject((Object)listener, "listener", "registerListener");
        if (this.configurationEventTopicConnector == null) {
            ConnectorBroker connectorBroker = new ConnectorBroker(this.auditLog);
            ConnectionResponse restResult = this.restClient.callOCFConnectionGetRESTCall("registerListener", urlTemplate, new Object[]{this.serverName, userId, this.callerId});
            Connection topicConnection = restResult.getConnection();
            Connector connector = connectorBroker.getConnector(topicConnection);
            if (connector == null) {
                throw new ConnectorCheckedException(OMAGOCFErrorCode.NULL_CONNECTOR_RETURNED.getMessageDefinition(new String[]{topicConnection.getQualifiedName(), serviceName, this.serverName, this.serverPlatformURLRoot}), this.getClass().getName(), "registerListener");
            }
            if (connector instanceof GovernanceEngineOutTopicClientConnector) {
                this.configurationEventTopicConnector = (GovernanceEngineOutTopicClientConnector)connector;
                this.configurationEventTopicConnector.start();
            } else {
                throw new ConnectorCheckedException(OMAGOCFErrorCode.WRONG_TYPE_OF_CONNECTOR.getMessageDefinition(new String[]{topicConnection.getQualifiedName(), serviceName, this.serverName, this.serverPlatformURLRoot, GovernanceEngineOutTopicClientConnector.class.getName()}), this.getClass().getName(), "registerListener");
            }
        }
        this.configurationEventTopicConnector.registerListener(userId, listener);
    }
}

