/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.api.GovernanceActionProcessInterface;
import org.odpi.openmetadata.accessservices.governanceengine.client.rest.GovernanceEngineRESTClient;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceActionProcessElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceActionTypeElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.NextGovernanceActionTypeElement;
import org.odpi.openmetadata.accessservices.governanceengine.properties.GovernanceActionProcessProperties;
import org.odpi.openmetadata.accessservices.governanceengine.properties.GovernanceActionTypeProperties;
import org.odpi.openmetadata.accessservices.governanceengine.properties.ProcessStatus;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionProcessElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionProcessElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionTypeElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionTypeElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NewGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NextGovernanceActionTypeElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NextGovernanceActionTypeRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateGovernanceActionTypeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GovernanceActionProcessClient
implements GovernanceActionProcessInterface {
    private final String serverName;
    private final String serverPlatformURLRoot;
    private final GovernanceEngineRESTClient restClient;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final NullRequestBody nullRequestBody = new NullRequestBody();

    public GovernanceActionProcessClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceEngineRESTClient(serverName, serverPlatformURLRoot);
    }

    public GovernanceActionProcessClient(String serverName, String serverPlatformURLRoot, String serverUserId, String serverPassword) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceEngineRESTClient(serverName, serverPlatformURLRoot, serverUserId, serverPassword);
    }

    public GovernanceActionProcessClient(String serverName, String serverPlatformURLRoot, GovernanceEngineRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    public String createGovernanceActionProcess(String userId, GovernanceActionProcessProperties processProperties, ProcessStatus initialStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceActionProcess";
        String propertiesParameterName = "processProperties";
        String qualifiedNameParameterName = "processProperties.getQualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-processes/new";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceActionProcess");
        this.invalidParameterHandler.validateObject((Object)processProperties, "processProperties", "createGovernanceActionProcess");
        this.invalidParameterHandler.validateName(processProperties.getQualifiedName(), "processProperties.getQualifiedName", "createGovernanceActionProcess");
        NewGovernanceActionProcessRequestBody requestBody = new NewGovernanceActionProcessRequestBody();
        requestBody.setProcessStatus(initialStatus);
        requestBody.setProperties(processProperties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGovernanceActionProcess", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updateGovernanceActionProcess(String userId, String processGUID, boolean isMergeUpdate, ProcessStatus processStatus, GovernanceActionProcessProperties processProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceActionProcess";
        String guidParameterName = "processGUID";
        String propertiesParameterName = "processProperties";
        String qualifiedNameParameterName = "processProperties.getQualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-processes/{2}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceActionProcess");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "updateGovernanceActionProcess");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateObject((Object)processProperties, "processProperties", "updateGovernanceActionProcess");
            this.invalidParameterHandler.validateName(processProperties.getQualifiedName(), "processProperties.getQualifiedName", "updateGovernanceActionProcess");
        }
        UpdateGovernanceActionProcessRequestBody requestBody = new UpdateGovernanceActionProcessRequestBody();
        requestBody.setMergeUpdate(isMergeUpdate);
        requestBody.setProcessStatus(processStatus);
        requestBody.setProperties(processProperties);
        this.restClient.callVoidPostRESTCall("updateGovernanceActionProcess", urlTemplate, requestBody, new Object[]{this.serverName, userId, processGUID});
    }

    public void publishGovernanceActionProcess(String userId, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishGovernanceActionProcess";
        String guidParameterName = "processGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-processes/{2}/publish";
        this.invalidParameterHandler.validateUserId(userId, "publishGovernanceActionProcess");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "publishGovernanceActionProcess");
        this.restClient.callVoidPostRESTCall("publishGovernanceActionProcess", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, processGUID});
    }

    public void withdrawGovernanceActionProcess(String userId, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawGovernanceActionProcess";
        String guidParameterName = "processGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-processes/{2}/withdraw";
        this.invalidParameterHandler.validateUserId(userId, "withdrawGovernanceActionProcess");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "withdrawGovernanceActionProcess");
        this.restClient.callVoidPostRESTCall("withdrawGovernanceActionProcess", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, processGUID});
    }

    public void removeGovernanceActionProcess(String userId, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGovernanceActionProcess";
        String guidParameterName = "processGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-processes/{2}/remove";
        this.invalidParameterHandler.validateUserId(userId, "removeGovernanceActionProcess");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "removeGovernanceActionProcess");
        this.restClient.callVoidPostRESTCall("removeGovernanceActionProcess", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, processGUID});
    }

    public List<GovernanceActionProcessElement> findGovernanceActionProcesses(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGovernanceActionProcesses";
        String searchStringParameterName = "searchString";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-processes/by-search-string?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "findGovernanceActionProcesses");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGovernanceActionProcesses");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        GovernanceActionProcessElementsResponse restResult = this.restClient.callGovernanceActionProcessElementsPostRESTCall("findGovernanceActionProcesses", urlTemplate, requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<GovernanceActionProcessElement> getGovernanceActionProcessesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActionProcessesByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-processes/by-name?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActionProcessesByName");
        this.invalidParameterHandler.validateName(name, "name", "getGovernanceActionProcessesByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        GovernanceActionProcessElementsResponse restResult = this.restClient.callGovernanceActionProcessElementsPostRESTCall("getGovernanceActionProcessesByName", urlTemplate, requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public GovernanceActionProcessElement getGovernanceActionProcessByGUID(String userId, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActionProcessByGUID";
        String guidParameterName = "processGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-processes/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActionProcessByGUID");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "getGovernanceActionProcessByGUID");
        GovernanceActionProcessElementResponse restResult = this.restClient.callGovernanceActionProcessGetRESTCall("getGovernanceActionProcessByGUID", urlTemplate, this.serverName, userId, processGUID);
        return restResult.getElement();
    }

    public String createGovernanceActionType(String userId, GovernanceActionTypeProperties actionTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceActionType";
        String propertiesParameterName = "actionTypeProperties";
        String qualifiedNameParameterName = "actionTypeProperties.getQualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-types/new";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceActionType");
        this.invalidParameterHandler.validateObject((Object)actionTypeProperties, "actionTypeProperties", "createGovernanceActionType");
        this.invalidParameterHandler.validateName(actionTypeProperties.getQualifiedName(), "actionTypeProperties.getQualifiedName", "createGovernanceActionType");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGovernanceActionType", urlTemplate, actionTypeProperties, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updateGovernanceActionType(String userId, String actionTypeGUID, boolean isMergeUpdate, GovernanceActionTypeProperties actionTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceActionProcess";
        String guidParameterName = "actionTypeGUID";
        String propertiesParameterName = "actionTypeProperties";
        String qualifiedNameParameterName = "actionTypeProperties.getQualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-types/{2}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceActionProcess");
        this.invalidParameterHandler.validateGUID(actionTypeGUID, "actionTypeGUID", "updateGovernanceActionProcess");
        this.invalidParameterHandler.validateObject((Object)actionTypeProperties, "actionTypeProperties", "updateGovernanceActionProcess");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(actionTypeProperties.getQualifiedName(), "actionTypeProperties.getQualifiedName", "updateGovernanceActionProcess");
        }
        UpdateGovernanceActionTypeRequestBody requestBody = new UpdateGovernanceActionTypeRequestBody();
        requestBody.setMergeUpdate(isMergeUpdate);
        requestBody.setProperties(actionTypeProperties);
        this.restClient.callVoidPostRESTCall("updateGovernanceActionProcess", urlTemplate, requestBody, new Object[]{this.serverName, userId, actionTypeGUID});
    }

    public void removeGovernanceActionType(String userId, String actionTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGovernanceActionType";
        String guidParameterName = "actionTypeGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-types/{2}/remove";
        this.invalidParameterHandler.validateUserId(userId, "removeGovernanceActionType");
        this.invalidParameterHandler.validateGUID(actionTypeGUID, "actionTypeGUID", "removeGovernanceActionType");
        this.restClient.callVoidPostRESTCall("removeGovernanceActionType", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, actionTypeGUID});
    }

    public List<GovernanceActionTypeElement> findGovernanceActionTypes(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGovernanceActionTypes";
        String searchStringParameterName = "searchString";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-types/by-search-string?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "findGovernanceActionTypes");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGovernanceActionTypes");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        GovernanceActionTypeElementsResponse restResult = this.restClient.callGovernanceActionTypeElementsPostRESTCall("findGovernanceActionTypes", urlTemplate, requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<GovernanceActionTypeElement> getGovernanceActionTypesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActionTypesByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-types/by-name?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActionTypesByName");
        this.invalidParameterHandler.validateName(name, "name", "getGovernanceActionTypesByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        GovernanceActionTypeElementsResponse restResult = this.restClient.callGovernanceActionTypeElementsPostRESTCall("getGovernanceActionTypesByName", urlTemplate, requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public GovernanceActionTypeElement getGovernanceActionTypeByGUID(String userId, String actionTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActionTypeByGUID";
        String guidParameterName = "actionTypeGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-types/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActionTypeByGUID");
        this.invalidParameterHandler.validateGUID(actionTypeGUID, "actionTypeGUID", "getGovernanceActionTypeByGUID");
        GovernanceActionTypeElementResponse restResult = this.restClient.callGovernanceActionTypeGetRESTCall("getGovernanceActionTypeByGUID", urlTemplate, this.serverName, userId, actionTypeGUID);
        return restResult.getElement();
    }

    public void setupFirstActionType(String userId, String processGUID, String actionTypeGUID, String guard) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupFirstActionType";
        String processGUIDParameterName = "processGUID";
        String actionTypeGUIDParameterName = "actionTypeGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-processes/{2}/first-action-type/{3}/new";
        this.invalidParameterHandler.validateUserId(userId, "setupFirstActionType");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "setupFirstActionType");
        this.invalidParameterHandler.validateGUID(actionTypeGUID, "actionTypeGUID", "setupFirstActionType");
        this.restClient.callVoidPostRESTCall("setupFirstActionType", urlTemplate, guard, new Object[]{this.serverName, userId, processGUID, actionTypeGUID});
    }

    public GovernanceActionTypeElement getFirstActionType(String userId, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFirstActionType";
        String guidParameterName = "processGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-processes/{2}/first-action-type";
        this.invalidParameterHandler.validateUserId(userId, "getFirstActionType");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "getFirstActionType");
        GovernanceActionTypeElementResponse restResult = this.restClient.callGovernanceActionTypeGetRESTCall("getFirstActionType", urlTemplate, this.serverName, userId, processGUID);
        return restResult.getElement();
    }

    public void removeFirstActionType(String userId, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeFirstActionType";
        String guidParameterName = "processGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-processes/{2}/first-action-type/remove";
        this.invalidParameterHandler.validateUserId(userId, "removeFirstActionType");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "removeFirstActionType");
        this.restClient.callVoidPostRESTCall("removeFirstActionType", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, processGUID});
    }

    public String setupNextActionType(String userId, String currentActionTypeGUID, String nextActionTypeGUID, String guard, boolean mandatoryGuard, boolean ignoreMultipleTriggers) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupNextActionType";
        String currentGUIDParameterName = "currentActionTypeGUID";
        String nextGUIDParameterName = "nextActionTypeGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-types/{2}/next-action-types/{3}/new";
        this.invalidParameterHandler.validateUserId(userId, "setupNextActionType");
        this.invalidParameterHandler.validateGUID(currentActionTypeGUID, "currentActionTypeGUID", "setupNextActionType");
        this.invalidParameterHandler.validateGUID(nextActionTypeGUID, "nextActionTypeGUID", "setupNextActionType");
        NextGovernanceActionTypeRequestBody requestBody = new NextGovernanceActionTypeRequestBody();
        requestBody.setGuard(guard);
        requestBody.setMandatoryGuard(mandatoryGuard);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("setupNextActionType", urlTemplate, requestBody, new Object[]{this.serverName, userId, currentActionTypeGUID, nextActionTypeGUID});
        return restResult.getGUID();
    }

    public void updateNextActionType(String userId, String nextActionLinkGUID, String guard, boolean mandatoryGuard, boolean ignoreMultipleTriggers) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateNextActionType";
        String guidParameterName = "nextActionLinkGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/next-action-types/{2}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateNextActionType");
        this.invalidParameterHandler.validateGUID(nextActionLinkGUID, "nextActionLinkGUID", "updateNextActionType");
        NextGovernanceActionTypeRequestBody requestBody = new NextGovernanceActionTypeRequestBody();
        requestBody.setGuard(guard);
        requestBody.setMandatoryGuard(mandatoryGuard);
        this.restClient.callVoidPostRESTCall("updateNextActionType", urlTemplate, requestBody, new Object[]{this.serverName, userId, nextActionLinkGUID});
    }

    public List<NextGovernanceActionTypeElement> getNextGovernanceActionTypes(String userId, String actionTypeGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNextGovernanceActionTypes";
        String guidParameterName = "actionTypeGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-types/{2}/next-action-type?startFrom={4}&pageSize={5}";
        this.invalidParameterHandler.validateUserId(userId, "getNextGovernanceActionTypes");
        this.invalidParameterHandler.validateGUID(actionTypeGUID, "actionTypeGUID", "getNextGovernanceActionTypes");
        NextGovernanceActionTypeElementsResponse restResult = this.restClient.callNextGovernanceActionTypesGetRESTCall("getNextGovernanceActionTypes", urlTemplate, this.serverName, userId, actionTypeGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public void removeNextActionType(String userId, String actionLinkGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeFirstActionType";
        String guidParameterName = "processGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-action-types/next-action-type/{2}/remove";
        this.invalidParameterHandler.validateUserId(userId, "removeFirstActionType");
        this.invalidParameterHandler.validateGUID(actionLinkGUID, "processGUID", "removeFirstActionType");
        this.restClient.callVoidPostRESTCall("removeFirstActionType", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, actionLinkGUID});
    }
}

