/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.api.GovernanceProcessingInterface;
import org.odpi.openmetadata.accessservices.governanceengine.client.rest.GovernanceEngineRESTClient;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceActionElement;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.StatusRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworkservices.gaf.client.OpenGovernanceClientBase;
import org.odpi.openmetadata.frameworkservices.gaf.client.rest.GAFRESTClient;

public class GovernanceEngineClient
extends OpenGovernanceClientBase
implements GovernanceProcessingInterface {
    private final GovernanceEngineRESTClient restClient;
    private final NullRequestBody nullRequestBody = new NullRequestBody();
    private static final String serviceURLMarker = "governance-engine";

    public GovernanceEngineClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot);
        this.restClient = new GovernanceEngineRESTClient(serverName, serverPlatformURLRoot);
    }

    public GovernanceEngineClient(String serverName, String serverPlatformURLRoot, String serverUserId, String serverPassword) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot, serverUserId, serverPassword);
        this.restClient = new GovernanceEngineRESTClient(serverName, serverPlatformURLRoot, serverUserId, serverPassword);
    }

    public GovernanceEngineClient(String serverName, String serverPlatformURLRoot, GovernanceEngineRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot, (GAFRESTClient)restClient, maxPageSize);
        this.restClient = restClient;
    }

    public void updateGovernanceActionStatus(String userId, String governanceActionGUID, GovernanceActionStatus governanceActionStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceActionStatus";
        String guidParameterName = "governanceActionGUID";
        String statusParameterName = "governanceActionStatus";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions/{2}/status/update";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceActionStatus");
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", "updateGovernanceActionStatus");
        this.invalidParameterHandler.validateEnum((Object)governanceActionStatus, "governanceActionStatus", "updateGovernanceActionStatus");
        StatusRequestBody requestBody = new StatusRequestBody();
        requestBody.setStatus(governanceActionStatus);
        this.restClient.callVoidPostRESTCall("updateGovernanceActionStatus", urlTemplate, requestBody, new Object[]{this.serverName, userId, governanceActionGUID});
    }

    public GovernanceActionElement getGovernanceAction(String userId, String governanceActionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceAction";
        String guidParameterName = "governanceActionGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceAction");
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", "getGovernanceAction");
        GovernanceActionElementResponse restResult = this.restClient.callGovernanceActionGetRESTCall("getGovernanceAction", urlTemplate, this.serverName, userId, governanceActionGUID);
        return restResult.getElement();
    }

    public void claimGovernanceAction(String userId, String governanceActionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "claimGovernanceAction";
        String guidParameterName = "governanceActionGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions/{2}/claim";
        this.invalidParameterHandler.validateUserId(userId, "claimGovernanceAction");
        this.invalidParameterHandler.validateGUID(governanceActionGUID, "governanceActionGUID", "claimGovernanceAction");
        this.restClient.callVoidPostRESTCall("claimGovernanceAction", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, governanceActionGUID});
    }

    public List<GovernanceActionElement> getGovernanceActions(String userId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActions";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActions");
        GovernanceActionElementsResponse restResult = this.restClient.callGovernanceActionsGetRESTCall("getGovernanceActions", urlTemplate, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<GovernanceActionElement> getActiveGovernanceActions(String userId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getActiveGovernanceActions";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions/active?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "getActiveGovernanceActions");
        GovernanceActionElementsResponse restResult = this.restClient.callGovernanceActionsGetRESTCall("getActiveGovernanceActions", urlTemplate, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<GovernanceActionElement> getActiveClaimedGovernanceActions(String userId, String governanceEngineGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getActiveClaimedGovernanceActions";
        String guidParameterName = "governanceEngineGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-engines/{2}/active-governance-actions?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getActiveClaimedGovernanceActions");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "getActiveClaimedGovernanceActions");
        GovernanceActionElementsResponse restResult = this.restClient.callGovernanceActionsGetRESTCall("getActiveClaimedGovernanceActions", urlTemplate, this.serverName, userId, governanceEngineGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<GovernanceActionElement> findGovernanceActions(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGovernanceActionTypes";
        String searchStringParameterName = "searchString";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions/by-search-string?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "findGovernanceActionTypes");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGovernanceActionTypes");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        GovernanceActionElementsResponse restResult = this.restClient.callGovernanceActionsGetRESTCall("findGovernanceActionTypes", urlTemplate, requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<GovernanceActionElement> getGovernanceActionsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActionsByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/governance-actions/by-name?startFrom={2}&pageSize={3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActionsByName");
        this.invalidParameterHandler.validateName(name, "name", "getGovernanceActionsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        GovernanceActionElementsResponse restResult = this.restClient.callGovernanceActionsGetRESTCall("getGovernanceActionsByName", urlTemplate, requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }
}

