/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.api.IntegrationGroupConfiguration;
import org.odpi.openmetadata.accessservices.governanceengine.client.rest.GovernanceEngineRESTClient;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.IntegrationConnectorElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.IntegrationGroupElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.RegisteredIntegrationConnectorElement;
import org.odpi.openmetadata.accessservices.governanceengine.properties.CatalogTargetProperties;
import org.odpi.openmetadata.accessservices.governanceengine.properties.IntegrationConnectorProperties;
import org.odpi.openmetadata.accessservices.governanceengine.properties.IntegrationGroupProperties;
import org.odpi.openmetadata.accessservices.governanceengine.properties.RegisteredIntegrationConnectorProperties;
import org.odpi.openmetadata.accessservices.governanceengine.rest.CatalogTargetResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.CatalogTargetsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.DeleteRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.IntegrationConnectorElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.IntegrationConnectorElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.IntegrationGroupElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.IntegrationGroupElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.RegisteredIntegrationConnectorResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.RegisteredIntegrationConnectorsResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.integration.properties.CatalogTarget;

public class IntegrationGroupConfigurationClient
implements IntegrationGroupConfiguration {
    private final String serverName;
    private final String serverPlatformURLRoot;
    private final GovernanceEngineRESTClient restClient;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final NullRequestBody nullRequestBody = new NullRequestBody();
    private AuditLog auditLog = null;

    public IntegrationGroupConfigurationClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceEngineRESTClient(serverName, serverPlatformURLRoot);
    }

    public IntegrationGroupConfigurationClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new GovernanceEngineRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public IntegrationGroupConfigurationClient(String serverName, String serverPlatformURLRoot, GovernanceEngineRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
        this.auditLog = auditLog;
    }

    public String getConfigurationServerName() {
        return this.serverName;
    }

    public String createIntegrationGroup(String userId, IntegrationGroupProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createIntegrationGroup";
        String propertiesParameterName = "properties";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-groups/new";
        this.invalidParameterHandler.validateUserId(userId, "createIntegrationGroup");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createIntegrationGroup");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "createIntegrationGroup");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createIntegrationGroup", urlTemplate, properties, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public IntegrationGroupElement getIntegrationGroupByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationGroupByGUID";
        String guidParameterName = "guid";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-groups/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationGroupByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getIntegrationGroupByGUID");
        IntegrationGroupElementResponse restResult = this.restClient.callIntegrationGroupGetRESTCall("getIntegrationGroupByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }

    public IntegrationGroupElement getIntegrationGroupByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationGroupByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-groups/by-name/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationGroupByName");
        this.invalidParameterHandler.validateName(name, "name", "getIntegrationGroupByName");
        IntegrationGroupElementResponse restResult = this.restClient.callIntegrationGroupGetRESTCall("getIntegrationGroupByName", urlTemplate, this.serverName, userId, name);
        return restResult.getElement();
    }

    public List<IntegrationGroupElement> getAllIntegrationGroups(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllIntegrationGroups";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-groups?startingFrom={2}&maximumResults={3}";
        this.invalidParameterHandler.validateUserId(userId, "getAllIntegrationGroups");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getAllIntegrationGroups");
        IntegrationGroupElementsResponse restResult = this.restClient.callIntegrationGroupsGetRESTCall("getAllIntegrationGroups", urlTemplate, this.serverName, userId, startingFrom, maximumResults);
        return restResult.getElements();
    }

    public void updateIntegrationGroup(String userId, String guid, boolean isMergeUpdate, IntegrationGroupProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateIntegrationGroup";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String propertiesParameterName = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-groups/{2}/update?isMergeUpdate={3}";
        this.invalidParameterHandler.validateUserId(userId, "updateIntegrationGroup");
        this.invalidParameterHandler.validateGUID(guid, "guid", "updateIntegrationGroup");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateIntegrationGroup");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "updateIntegrationGroup");
        }
        this.restClient.callVoidPostRESTCall("updateIntegrationGroup", urlTemplate, properties, new Object[]{this.serverName, userId, guid, isMergeUpdate});
    }

    public void deleteIntegrationGroup(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteIntegrationGroup";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-groups/{2}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteIntegrationGroup");
        this.invalidParameterHandler.validateGUID(guid, "guid", "deleteIntegrationGroup");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteIntegrationGroup");
        DeleteRequestBody requestBody = new DeleteRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        this.restClient.callVoidPostRESTCall("deleteIntegrationGroup", urlTemplate, requestBody, new Object[]{this.serverName, userId, guid});
    }

    public String createIntegrationConnector(String userId, IntegrationConnectorProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createIntegrationConnector";
        String nameParameterName = "qualifiedName";
        String connectionParameterName = "connection";
        String propertiesParameterName = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-connectors/new";
        this.invalidParameterHandler.validateUserId(userId, "createIntegrationConnector");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createIntegrationConnector");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "createIntegrationConnector");
        this.invalidParameterHandler.validateConnection(properties.getConnection(), "connection", "createIntegrationConnector");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createIntegrationConnector", urlTemplate, properties, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public IntegrationConnectorElement getIntegrationConnectorByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationConnectorByGUID";
        String guidParameterName = "guid";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-connectors/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationConnectorByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getIntegrationConnectorByGUID");
        IntegrationConnectorElementResponse restResult = this.restClient.callIntegrationConnectorGetRESTCall("getIntegrationConnectorByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }

    public IntegrationConnectorElement getIntegrationConnectorByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationConnectorByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-connectors/by-name/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationConnectorByName");
        this.invalidParameterHandler.validateName(name, "name", "getIntegrationConnectorByName");
        IntegrationConnectorElementResponse restResult = this.restClient.callIntegrationConnectorGetRESTCall("getIntegrationConnectorByName", urlTemplate, this.serverName, userId, name);
        return restResult.getElement();
    }

    public List<IntegrationConnectorElement> getAllIntegrationConnectors(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllIntegrationConnectors";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-connectors?startingFrom={2}&maximumResults={3}";
        this.invalidParameterHandler.validateUserId(userId, "getAllIntegrationConnectors");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getAllIntegrationConnectors");
        IntegrationConnectorElementsResponse restResult = this.restClient.callIntegrationConnectorsGetRESTCall("getAllIntegrationConnectors", urlTemplate, this.serverName, userId, startingFrom, maximumResults);
        return restResult.getElements();
    }

    public List<String> getIntegrationConnectorRegistrations(String userId, String integrationConnectorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationConnectorRegistrations";
        String guidParameter = "integrationConnectorGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-connectors/{2}/registrations";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationConnectorRegistrations");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getIntegrationConnectorRegistrations");
        GUIDListResponse restResult = this.restClient.callGUIDListGetRESTCall("getIntegrationConnectorRegistrations", urlTemplate, new Object[]{this.serverName, userId, integrationConnectorGUID});
        return restResult.getGUIDs();
    }

    public void updateIntegrationConnector(String userId, String guid, boolean isMergeUpdate, IntegrationConnectorProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateIntegrationConnector";
        String guidParameterName = "guid";
        String propertiesParameterName = "properties";
        String nameParameterName = "qualifiedName";
        String connectionParameterName = "connection";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-connectors/{2}/update?isMergeUpdate={3}";
        this.invalidParameterHandler.validateUserId(userId, "updateIntegrationConnector");
        this.invalidParameterHandler.validateGUID(guid, "guid", "updateIntegrationConnector");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateIntegrationConnector");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "updateIntegrationConnector");
            this.invalidParameterHandler.validateConnection(properties.getConnection(), "connection", "updateIntegrationConnector");
        }
        this.restClient.callVoidPostRESTCall("updateIntegrationConnector", urlTemplate, properties, new Object[]{this.serverName, userId, guid, isMergeUpdate});
    }

    public void deleteIntegrationConnector(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteIntegrationConnector";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-connectors/{2}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteIntegrationConnector");
        this.invalidParameterHandler.validateGUID(guid, "guid", "deleteIntegrationConnector");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteIntegrationConnector");
        DeleteRequestBody requestBody = new DeleteRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        this.restClient.callVoidPostRESTCall("deleteIntegrationConnector", urlTemplate, requestBody, new Object[]{this.serverName, userId, guid});
    }

    public void registerIntegrationConnectorWithGroup(String userId, String integrationGroupGUID, String integrationConnectorGUID, RegisteredIntegrationConnectorProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "registerIntegrationConnectorWithGroup";
        String integrationGroupGUIDParameter = "integrationGroupGUID";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String propertiesParameterName = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-groups/{2}/integration-connectors{3}";
        this.invalidParameterHandler.validateUserId(userId, "registerIntegrationConnectorWithGroup");
        this.invalidParameterHandler.validateGUID(integrationGroupGUID, "integrationGroupGUID", "registerIntegrationConnectorWithGroup");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "registerIntegrationConnectorWithGroup");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "registerIntegrationConnectorWithGroup");
        this.restClient.callVoidPostRESTCall("registerIntegrationConnectorWithGroup", urlTemplate, properties, new Object[]{this.serverName, userId, integrationGroupGUID, integrationConnectorGUID});
    }

    public RegisteredIntegrationConnectorElement getRegisteredIntegrationConnector(String userId, String integrationGroupGUID, String integrationConnectorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredIntegrationConnector";
        String integrationGroupGUIDParameter = "integrationGroupGUID";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-groups/{2}/integration-connectors/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredIntegrationConnector");
        this.invalidParameterHandler.validateGUID(integrationGroupGUID, "integrationGroupGUID", "getRegisteredIntegrationConnector");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getRegisteredIntegrationConnector");
        RegisteredIntegrationConnectorResponse restResult = this.restClient.callRegisteredIntegrationConnectorGetRESTCall("getRegisteredIntegrationConnector", urlTemplate, this.serverName, userId, integrationGroupGUID, integrationConnectorGUID);
        return restResult.getRegisteredIntegrationConnector();
    }

    public List<RegisteredIntegrationConnectorElement> getRegisteredIntegrationConnectors(String userId, String integrationGroupGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredIntegrationConnectors";
        String integrationGroupGUIDParameter = "integrationGroupGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-groups/{2}/integration-connectors?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredIntegrationConnectors");
        this.invalidParameterHandler.validateGUID(integrationGroupGUID, "integrationGroupGUID", "getRegisteredIntegrationConnectors");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getRegisteredIntegrationConnectors");
        RegisteredIntegrationConnectorsResponse restResult = this.restClient.callRegisteredIntegrationConnectorsGetRESTCall("getRegisteredIntegrationConnectors", urlTemplate, this.serverName, userId, integrationGroupGUID, startingFrom, maximumResults);
        return restResult.getElements();
    }

    public void unregisterIntegrationConnectorFromGroup(String userId, String integrationGroupGUID, String integrationConnectorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unregisterIntegrationConnectorFromGroup";
        String integrationGroupGUIDParameter = "integrationGroupGUID";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-groups/{2}/integration-connectors/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "unregisterIntegrationConnectorFromGroup");
        this.invalidParameterHandler.validateGUID(integrationGroupGUID, "integrationGroupGUID", "unregisterIntegrationConnectorFromGroup");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "unregisterIntegrationConnectorFromGroup");
        this.restClient.callVoidPostRESTCall("unregisterIntegrationConnectorFromGroup", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, integrationGroupGUID, integrationConnectorGUID});
    }

    public void addCatalogTarget(String userId, String integrationConnectorGUID, String metadataElementGUID, CatalogTargetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addCatalogTarget";
        String propertiesParameterName = "properties";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String metadataElementGUIDParameter = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-connectors/{2}/catalog-targets/{3}";
        this.invalidParameterHandler.validateUserId(userId, "addCatalogTarget");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "addCatalogTarget");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "addCatalogTarget");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "addCatalogTarget");
        this.restClient.callVoidPostRESTCall("addCatalogTarget", urlTemplate, properties, new Object[]{this.serverName, userId, integrationConnectorGUID, metadataElementGUID});
    }

    public CatalogTarget getCatalogTarget(String userId, String integrationConnectorGUID, String metadataElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCatalogTarget";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-connectors/{2}/catalog-targets/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getCatalogTarget");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getCatalogTarget");
        CatalogTargetResponse restResult = this.restClient.callCatalogTargetGetRESTCall("getCatalogTarget", urlTemplate, this.serverName, userId, integrationConnectorGUID, metadataElementGUID);
        return restResult.getElement();
    }

    public List<CatalogTarget> getCatalogTargets(String userId, String integrationConnectorGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCatalogTargets";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-connectors/{2}/catalog-targets?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getCatalogTargets");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getCatalogTargets");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getCatalogTargets");
        CatalogTargetsResponse restResult = this.restClient.callCatalogTargetsGetRESTCall("getCatalogTargets", urlTemplate, this.serverName, userId, integrationConnectorGUID, startingFrom, maximumResults);
        return restResult.getElements();
    }

    public void removeCatalogTarget(String userId, String integrationConnectorGUID, String metadataElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeCatalogTarget";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String metadataElementGUIDParameter = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/governance-engine/users/{1}/integration-connectors/{2}/catalog-targets/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeCatalogTarget");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "removeCatalogTarget");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "removeCatalogTarget");
        this.restClient.callVoidPostRESTCall("removeCatalogTarget", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, integrationConnectorGUID, metadataElementGUID});
    }
}

