/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.fvt;

import java.io.IOException;
import org.odpi.openmetadata.accessservices.governanceengine.fvt.clientconstructors.ClientConstructorTest;
import org.odpi.openmetadata.accessservices.governanceengine.fvt.duplicates.CreateDuplicatesTest;
import org.odpi.openmetadata.accessservices.governanceengine.fvt.engines.CreateEngineTest;
import org.odpi.openmetadata.accessservices.governanceengine.fvt.errorhandling.InvalidParameterTest;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.FVTSuiteBase;
import org.odpi.openmetadata.http.HttpHelper;

public class GovernanceEngineOMASFVTSuite
extends FVTSuiteBase {
    public static void main(String[] args) {
        int exitCode;
        try {
            String url = GovernanceEngineOMASFVTSuite.getUrl((String[])args);
            String serverName = GovernanceEngineOMASFVTSuite.getServerName((String[])args);
            String userId = GovernanceEngineOMASFVTSuite.getUserId((String[])args);
            GovernanceEngineOMASFVTSuite fvtSuite = new GovernanceEngineOMASFVTSuite();
            exitCode = fvtSuite.performFVT(serverName, url, userId);
        }
        catch (IOException error) {
            System.out.println("Error getting user input");
            error.printStackTrace();
            exitCode = -99;
        }
        System.exit(exitCode);
    }

    public int performFVT(String serverName, String serverPlatformRootURL, String userId) {
        HttpHelper.noStrictSSL();
        int returnCode = 0;
        FVTResults results = CreateDuplicatesTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = ClientConstructorTest.performFVT(serverName, serverPlatformRootURL);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = InvalidParameterTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = CreateEngineTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        return returnCode;
    }
}

