/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.handlers;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.errorcode.GovernanceEngineErrorCode;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.InvalidParameterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class GovernanceEngineValidator {
    private static final Logger log = LoggerFactory.getLogger(GovernanceEngineValidator.class);

    private GovernanceEngineValidator() {
    }

    public static void validateUserId(String userId, String methodName) throws InvalidParameterException {
        if (StringUtils.isEmpty((Object)userId)) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.EMPTY_USER_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), MethodHandles.lookup().lookupClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public static void validateGUID(String guid, String parameterName, String methodName) throws InvalidParameterException {
        if (StringUtils.isEmpty((Object)guid)) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.NULL_GUID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), MethodHandles.lookup().lookupClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public static void validateClassification(List<String> rootClassification, String parameterName, String methodName) throws InvalidParameterException {
    }

    public static void validateType(List<String> rootAssetType, String parameterName, String methodName) throws InvalidParameterException {
    }
}

