/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.errorcode.GovernanceEngineErrorCode;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.ClassificationNotFoundException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.GovernanceEngineCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.GuidNotFoundException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.MetadataServerException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.TypeNotFoundException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceClassificationDefAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceClassificationDefListAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceEngineOMASAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAssetAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAssetListAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.server.admin.GovernanceEngineAdmin;
import org.odpi.openmetadata.accessservices.governanceengine.server.handlers.GovernanceClassificationDefHandler;
import org.odpi.openmetadata.accessservices.governanceengine.server.handlers.GovernedAssetHandler;
import org.odpi.openmetadata.adminservices.OMAGAccessServiceRegistration;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistration;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovernanceEngineRESTServices {
    private static String accessServiceName = null;
    private static OMRSRepositoryConnector repositoryConnector = null;
    private static OMRSMetadataCollection metadataCollection;
    private static final Logger log;

    public static void setRepositoryConnector(String accessServiceName, OMRSRepositoryConnector repositoryConnector) {
        GovernanceEngineRESTServices.accessServiceName = accessServiceName;
        GovernanceEngineRESTServices.repositoryConnector = repositoryConnector;
        try {
            metadataCollection = repositoryConnector.getMetadataCollection();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public GovernanceEngineRESTServices() {
        AccessServiceDescription myDescription = AccessServiceDescription.GOVERNANCE_ENGINE_OMAS;
        AccessServiceRegistration myRegistration = new AccessServiceRegistration(myDescription.getAccessServiceCode(), myDescription.getAccessServiceName(), myDescription.getAccessServiceDescription(), myDescription.getAccessServiceWiki(), AccessServiceOperationalStatus.ENABLED, GovernanceEngineAdmin.class.getName());
        OMAGAccessServiceRegistration.registerAccessService((AccessServiceRegistration)myRegistration);
    }

    public GovernanceClassificationDefListAPIResponse getGovernanceClassificationDefs(String userId, List<String> classification) {
        String methodName = "getGovernanceClassificationDefs";
        if (log.isDebugEnabled()) {
            log.debug("Calling method: getGovernanceClassificationDefs");
        }
        GovernanceClassificationDefListAPIResponse response = new GovernanceClassificationDefListAPIResponse();
        try {
            this.validateInitialization("getGovernanceClassificationDefs");
            GovernanceClassificationDefHandler governanceClassificationDefHandler = new GovernanceClassificationDefHandler(accessServiceName, repositoryConnector);
            response.setClassificationDefsList(governanceClassificationDefHandler.getGovernanceClassificationDefs(userId, classification));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (MetadataServerException error) {
            this.captureMetadataServerException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (ClassificationNotFoundException error) {
            this.captureClassificationNotFoundException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceEngineOMASAPIResponse)response, error);
        }
        if (log.isDebugEnabled()) {
            log.debug("Returning from method: getGovernanceClassificationDefs with response: " + response.toString());
        }
        return response;
    }

    public GovernanceClassificationDefAPIResponse getClassificationDefs(String userId, String classificationGuid) {
        String methodName = "getClassificationDefs";
        if (log.isDebugEnabled()) {
            log.debug("Calling method: getClassificationDefs");
        }
        GovernanceClassificationDefAPIResponse response = new GovernanceClassificationDefAPIResponse();
        try {
            this.validateInitialization("getClassificationDefs");
            GovernanceClassificationDefHandler tagHandler = new GovernanceClassificationDefHandler(accessServiceName, repositoryConnector);
            response.setGovernanceClassificationDef(tagHandler.getGovernanceClassificationDef(userId, classificationGuid));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (MetadataServerException error) {
            this.captureMetadataServerException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (GuidNotFoundException error) {
            this.captureGuidNotFoundException((GovernanceEngineOMASAPIResponse)response, error);
        }
        if (log.isDebugEnabled()) {
            log.debug("Returning from method: getClassificationDefs with response: " + response.toString());
        }
        return response;
    }

    public GovernedAssetListAPIResponse getGovernedAssets(String userId, List<String> classification, List<String> type) {
        String methodName = "getGovernedAssets";
        if (log.isDebugEnabled()) {
            log.debug("Calling method: getGovernedAssets");
        }
        GovernedAssetListAPIResponse response = new GovernedAssetListAPIResponse();
        try {
            this.validateInitialization("getGovernedAssets");
            GovernedAssetHandler governedAssetHandler = new GovernedAssetHandler(accessServiceName, repositoryConnector);
            response.setGovernedAssetList(governedAssetHandler.getGovernedAssets(userId, classification, type));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (MetadataServerException error) {
            this.captureMetadataServerException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (ClassificationNotFoundException error) {
            this.captureClassificationNotFoundException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (TypeNotFoundException error) {
            this.captureTypeNotFoundException((GovernanceEngineOMASAPIResponse)response, error);
        }
        if (log.isDebugEnabled()) {
            log.debug("Returning from method: getGovernedAssets with response: " + response.toString());
        }
        return response;
    }

    public GovernedAssetAPIResponse getGovernedAsset(String userId, String assetGuid) {
        String methodName = "getGovernedAsset";
        if (log.isDebugEnabled()) {
            log.debug("Calling method: getGovernedAsset");
        }
        GovernedAssetAPIResponse response = new GovernedAssetAPIResponse();
        try {
            this.validateInitialization("getGovernedAsset");
            GovernedAssetHandler governedAssetHandler = new GovernedAssetHandler(accessServiceName, repositoryConnector);
            response.setAsset(governedAssetHandler.getGovernedAsset(userId, assetGuid));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (MetadataServerException error) {
            this.captureMetadataServerException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (GuidNotFoundException error) {
            this.captureGuidNotFoundException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((GovernanceEngineOMASAPIResponse)response, error);
        }
        if (log.isDebugEnabled()) {
            log.debug("Returning from method: getGovernedAsset with response: " + response.toString());
        }
        return response;
    }

    private void validateInitialization(String methodName) throws MetadataServerException {
        if (repositoryConnector == null) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.SERVICE_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new MetadataServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private void captureCheckedException(GovernanceEngineOMASAPIResponse response, GovernanceEngineCheckedExceptionBase error, String exceptionClassName) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
    }

    private void captureInvalidParameterException(GovernanceEngineOMASAPIResponse response, InvalidParameterException error) {
        this.captureCheckedException(response, (GovernanceEngineCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureMetadataServerException(GovernanceEngineOMASAPIResponse response, MetadataServerException error) {
        this.captureCheckedException(response, (GovernanceEngineCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureClassificationNotFoundException(GovernanceEngineOMASAPIResponse response, ClassificationNotFoundException error) {
        this.captureCheckedException(response, (GovernanceEngineCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureUserNotAuthorizedException(GovernanceEngineOMASAPIResponse response, UserNotAuthorizedException error) {
        this.captureCheckedException(response, (GovernanceEngineCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeNotFoundException(GovernanceEngineOMASAPIResponse response, TypeNotFoundException error) {
        this.captureCheckedException(response, (GovernanceEngineCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureGuidNotFoundException(GovernanceEngineOMASAPIResponse response, GuidNotFoundException error) {
        this.captureCheckedException(response, (GovernanceEngineCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    static {
        log = LoggerFactory.getLogger(GovernanceEngineRESTServices.class);
    }
}

