/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.admin;

import org.odpi.openmetadata.accessservices.governanceengine.api.auditlog.GovernanceEngineAuditCode;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineRESTServices;
import org.odpi.openmetadata.accessservices.governanceengine.server.listeners.GovernanceEngineOMRSTopicListener;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovernanceEngineAdmin
implements AccessServiceAdmin {
    private static final Logger log = LoggerFactory.getLogger(GovernanceEngineAdmin.class);
    private AccessServiceConfig accessServiceConfig = null;
    private OMRSAuditLog auditLog = null;
    private String serverUserName = null;
    private OMRSRepositoryConnector repositoryConnector = null;
    private OMRSTopicConnector omrsTopicConnector = null;
    private GovernanceEngineOMRSTopicListener omrsTopicListener = null;

    public synchronized void initialize(AccessServiceConfig accessServiceConfigurationProperties, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector enterpriseOMRSRepositoryConnector, OMRSAuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        log.debug(">>initialize");
        GovernanceEngineAuditCode auditCode = GovernanceEngineAuditCode.SERVICE_INITIALIZING;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        this.repositoryConnector = enterpriseOMRSRepositoryConnector;
        GovernanceEngineRESTServices.setRepositoryConnector(accessServiceConfigurationProperties.getAccessServiceName(), this.repositoryConnector);
        this.accessServiceConfig = accessServiceConfigurationProperties;
        this.omrsTopicConnector = enterpriseOMRSTopicConnector;
        if (this.omrsTopicConnector != null) {
            auditCode = GovernanceEngineAuditCode.SERVICE_REGISTERED_WITH_TOPIC;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            this.omrsTopicListener = new GovernanceEngineOMRSTopicListener(this.accessServiceConfig.getAccessServiceOutTopic(), this.repositoryConnector.getRepositoryHelper(), this.repositoryConnector.getRepositoryValidator(), this.accessServiceConfig.getAccessServiceName());
            this.omrsTopicConnector.registerListener((OMRSTopicListener)this.omrsTopicListener);
        }
        this.auditLog = auditLog;
        this.serverUserName = serverUserName;
        auditCode = GovernanceEngineAuditCode.SERVICE_INITIALIZED;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        log.debug("<<initialize");
    }

    public synchronized void shutdown() {
        String actionDescription = "shutdown";
        log.debug(">>shutdown");
        GovernanceEngineAuditCode auditCode = GovernanceEngineAuditCode.SERVICE_TERMINATING;
        this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        this.repositoryConnector = null;
        this.accessServiceConfig = null;
        this.omrsTopicConnector = null;
        auditCode = GovernanceEngineAuditCode.SERVICE_SHUTDOWN;
        this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        log.debug("<<shutdown");
    }
}

