/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.errorcode.GovernanceEngineErrorCode;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.ClassificationNotFoundException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.GuidNotFoundException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.MetadataServerException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceClassificationDef;
import org.odpi.openmetadata.accessservices.governanceengine.server.handlers.GovernanceEngineValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;

public class GovernanceClassificationDefHandler {
    private OMRSMetadataCollection metadataCollection = null;
    private String serviceName;
    private OMRSRepositoryHelper repositoryHelper = null;
    private String serverName = null;
    private static GovernanceEngineValidator validator;

    public GovernanceClassificationDefHandler(String serviceName, OMRSRepositoryConnector repositoryConnector) throws MetadataServerException {
        String methodName = "GovernanceClassificationDefHandler";
        this.serviceName = serviceName;
        if (repositoryConnector != null) {
            try {
                this.repositoryHelper = repositoryConnector.getRepositoryHelper();
                this.serverName = repositoryConnector.getServerName();
                this.metadataCollection = repositoryConnector.getMetadataCollection();
            }
            catch (Throwable error) {
                GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.NO_METADATA_COLLECTION;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"GovernanceClassificationDefHandler"});
                throw new MetadataServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "GovernanceClassificationDefHandler", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        }
    }

    public List<GovernanceClassificationDef> getGovernanceClassificationDefs(String userId, List<String> classification) throws InvalidParameterException, MetadataServerException, ClassificationNotFoundException, UserNotAuthorizedException {
        String methodName = "getGovernanceClassificationDefs";
        String nameParameter = "name";
        ArrayList<GovernanceClassificationDef> defsToReturn = new ArrayList<GovernanceClassificationDef>();
        GovernanceEngineValidator.validateUserId(userId, "getGovernanceClassificationDefs");
        GovernanceEngineValidator.validateClassification(classification, "name", "getGovernanceClassificationDefs");
        try {
            List typeDefsByCategory = this.metadataCollection.findTypeDefsByCategory(userId, TypeDefCategory.CLASSIFICATION_DEF);
            if (typeDefsByCategory != null) {
                typeDefsByCategory.forEach(td -> {
                    GovernanceClassificationDef gcd = new GovernanceClassificationDef();
                    gcd.setName(td.getName());
                    HashMap gdca = new HashMap();
                    List prop = td.getPropertiesDefinition();
                    if (prop != null) {
                        prop.forEach(tda -> gdca.put(tda.getAttributeName(), tda.getAttributeType().getName()));
                    }
                    gcd.setAttributeDefinitions(gdca);
                    defsToReturn.add(gcd);
                });
            }
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.USER_NOT_AUTHORIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{userId, "getGovernanceClassificationDefs"});
            throw new UserNotAuthorizedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getGovernanceClassificationDefs", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException | RepositoryErrorException e) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.METADATA_QUERY_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getGovernanceClassificationDefs"});
            throw new MetadataServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getGovernanceClassificationDefs", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return defsToReturn;
    }

    public GovernanceClassificationDef getGovernanceClassificationDef(String userId, String tagguid) throws InvalidParameterException, MetadataServerException, UserNotAuthorizedException, GuidNotFoundException {
        GovernanceClassificationDef defToReturn = new GovernanceClassificationDef();
        String methodName = "getGovernanceClassificationDef";
        GovernanceEngineValidator.validateUserId(userId, "getGovernanceClassificationDef");
        GovernanceEngineValidator.validateGUID(tagguid, "tagguid", "getGovernanceClassificationDef");
        try {
            TypeDef td = this.metadataCollection.getTypeDefByGUID(userId, tagguid);
            GovernanceClassificationDef gcd = new GovernanceClassificationDef();
            gcd.setName(td.getName());
            HashMap gdca = new HashMap();
            td.getPropertiesDefinition().forEach(tda -> gdca.put(tda.getAttributeName(), tda.getAttributeType().getName()));
            gcd.setAttributeDefinitions(gdca);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.USER_NOT_AUTHORIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{userId, "getGovernanceClassificationDef"});
            throw new UserNotAuthorizedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getGovernanceClassificationDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException | RepositoryErrorException e) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.METADATA_QUERY_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getGovernanceClassificationDef"});
            throw new MetadataServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getGovernanceClassificationDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        catch (TypeDefNotKnownException e) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.GUID_NOT_FOUND_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getGovernanceClassificationDef"});
            throw new GuidNotFoundException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getGovernanceClassificationDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return defToReturn;
    }
}

