/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.errorcode.GovernanceEngineErrorCode;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.ClassificationNotFoundException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.GuidNotFoundException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.MetadataServerException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.TypeNotFoundException;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceClassificationUsage;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAsset;
import org.odpi.openmetadata.accessservices.governanceengine.server.handlers.GovernanceEngineValidator;
import org.odpi.openmetadata.accessservices.governanceengine.server.util.PropertyUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class GovernedAssetHandler {
    private OMRSMetadataCollection metadataCollection = null;
    private String serviceName;
    private OMRSRepositoryHelper repositoryHelper = null;
    private String serverName = null;
    private static GovernanceEngineValidator errorHandler;

    public GovernedAssetHandler(String serviceName, OMRSRepositoryConnector repositoryConnector) throws MetadataServerException {
        String methodName = "GovernedAssetHandler";
        this.serviceName = serviceName;
        if (repositoryConnector != null) {
            try {
                this.repositoryHelper = repositoryConnector.getRepositoryHelper();
                this.serverName = repositoryConnector.getServerName();
                this.metadataCollection = repositoryConnector.getMetadataCollection();
            }
            catch (Throwable error) {
                GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.NO_METADATA_COLLECTION;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"GovernedAssetHandler"});
                throw new MetadataServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "GovernedAssetHandler", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        }
    }

    public List<GovernedAsset> getGovernedAssets(String userId, List<String> classification, List<String> type) throws InvalidParameterException, org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.UserNotAuthorizedException, MetadataServerException, ClassificationNotFoundException, TypeNotFoundException {
        String methodName = "getGovernedAssets";
        String classificationParameter = "classification";
        String typeParameter = "type";
        ArrayList<GovernedAsset> assetsToReturn = new ArrayList<GovernedAsset>();
        GovernanceEngineValidator.validateUserId(userId, "getGovernedAssets");
        GovernanceEngineValidator.validateClassification(classification, "classification", "getGovernedAssets");
        GovernanceEngineValidator.validateType(classification, "type", "getGovernedAssets");
        if (type == null) {
            this.addToAssetListByType(assetsToReturn, null, classification, userId);
        } else {
            type.forEach(typesearch -> this.addToAssetListByType((List<GovernedAsset>)assetsToReturn, (String)typesearch, classification, userId));
        }
        return assetsToReturn;
    }

    private void addToAssetListByType(List<GovernedAsset> assetsToReturn, String type, List<String> classification, String userId) {
        if (classification == null) {
            List allClassifications = null;
            try {
                allClassifications = this.metadataCollection.findTypeDefsByCategory(userId, TypeDefCategory.CLASSIFICATION_DEF);
            }
            catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException invalidParameterException) {
            }
            catch (RepositoryErrorException repositoryErrorException) {
            }
            catch (UserNotAuthorizedException userNotAuthorizedException) {
                // empty catch block
            }
            if (allClassifications != null) {
                allClassifications.forEach(classificationTypedef -> this.addToAssetListByClassification(assetsToReturn, type, classificationTypedef.getName(), userId));
            }
        } else {
            classification.forEach(classificationsearch -> this.addToAssetListByClassification(assetsToReturn, type, (String)classificationsearch, userId));
        }
    }

    private void addToAssetListByClassification(List<GovernedAsset> assetsToReturn, String type, String classification, String userId) {
        Iterable entities = null;
        String typeGuid = this.getTypeGuidFromTypeName(type, userId);
        try {
            entities = this.metadataCollection.findEntitiesByClassification(userId, typeGuid, classification, null, null, 0, null, null, null, null, 0);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            e.printStackTrace();
        }
        catch (TypeErrorException e) {
            e.printStackTrace();
        }
        catch (RepositoryErrorException e) {
            e.printStackTrace();
        }
        catch (ClassificationErrorException e) {
            e.printStackTrace();
        }
        catch (PropertyErrorException e) {
            e.printStackTrace();
        }
        catch (PagingErrorException e) {
            e.printStackTrace();
        }
        catch (FunctionNotSupportedException e) {
            e.printStackTrace();
        }
        catch (UserNotAuthorizedException e) {
            e.printStackTrace();
        }
        if (entities != null) {
            entities.forEach(entity -> {
                GovernedAsset entry = this.addEntityIfDoesntExist(assetsToReturn, (EntityDetail)entity);
                this.addClassificationInfoToEntry(entry, (EntityDetail)entity, classification);
            });
        }
    }

    private void addClassificationInfoToEntry(GovernedAsset entry, EntityDetail entity, String classification) {
        ArrayList<GovernanceClassificationUsage> usageList = entry.getAssignedGovernanceClassifications();
        if (usageList == null) {
            usageList = new ArrayList<GovernanceClassificationUsage>();
        }
        GovernanceClassificationUsage usage = new GovernanceClassificationUsage();
        Classification entityClassification = entity.getClassifications().stream().filter(c -> classification.equals(c.getName())).findAny().orElse(null);
        if (entityClassification != null) {
            Map ip;
            usage.setName(classification);
            HashMap m = new HashMap();
            InstanceProperties ip2 = entityClassification.getProperties();
            if (ip2 != null && (ip = ip2.getInstanceProperties()) != null) {
                ip.entrySet().stream().forEach(props -> m.put(props.getKey(), PropertyUtils.getStringForPropertyValue((InstancePropertyValue)props.getValue())));
            }
            usage.setAttributeValues(m);
            usageList.add(usage);
            entry.setAssignedGovernanceClassifications(usageList);
        }
    }

    private GovernedAsset addEntityIfDoesntExist(List<GovernedAsset> assetsToReturn, EntityDetail entity) {
        GovernedAsset ga = new GovernedAsset();
        ga.setGuid(entity.getGUID());
        ga.setType(entity.getType().getTypeDefName());
        ga.setFqName(this.getGovernanceResourceNameFromEntity(entity));
        GovernedAsset existingEntry = assetsToReturn.stream().filter(govasset -> ga.getGuid().equals(govasset.getGuid())).findAny().orElse(null);
        if (existingEntry == null) {
            assetsToReturn.add(ga);
            existingEntry = ga;
        }
        return existingEntry;
    }

    private String getTypeGuidFromTypeName(String type, String userId) {
        String guid = null;
        try {
            guid = this.metadataCollection.getTypeDefByName(userId, type).getGUID();
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException invalidParameterException) {
        }
        catch (RepositoryErrorException repositoryErrorException) {
        }
        catch (TypeDefNotKnownException typeDefNotKnownException) {
        }
        catch (UserNotAuthorizedException userNotAuthorizedException) {
            // empty catch block
        }
        return guid;
    }

    private String getGovernanceResourceNameFromEntity(EntityDetail entityDetail) {
        String typeDefName;
        String resourceName = null;
        switch (typeDefName = entityDetail.getType().getTypeDefName()) {
            case "RelationalColumn": {
                resourceName = "MyColumn <placeholder>";
                break;
            }
            case "RelationalTable": {
                resourceName = "MyTable <placeholder>";
                break;
            }
            default: {
                resourceName = "MyResourceWithAnotherName <placeholder>";
            }
        }
        return resourceName;
    }

    public GovernedAsset getGovernedAsset(String userId, String assetGuid) throws InvalidParameterException, MetadataServerException, org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.UserNotAuthorizedException, GuidNotFoundException {
        String methodName = "getGovernedAsset";
        String assetParm = "assetGuid";
        GovernedAsset defToReturn = new GovernedAsset();
        GovernanceEngineValidator.validateUserId(userId, "getGovernedAsset");
        GovernanceEngineValidator.validateGUID(assetGuid, "assetGuid", "getGovernedAsset");
        return defToReturn;
    }

    private String getPropertyValue(InstanceProperties instanceProperties, String propertyName) {
        PrimitivePropertyValue value = (PrimitivePropertyValue)instanceProperties.getPropertyValue(propertyName);
        if (value != null) {
            return (String)value.getPrimitiveValue();
        }
        return null;
    }
}

