/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server;

import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.errorcode.GovernanceEngineErrorCode;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineRegistration;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineServicesInstance;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineServicesInstanceMap;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

class GovernanceEngineInstanceHandler {
    private static GovernanceEngineServicesInstanceMap instanceMap = new GovernanceEngineServicesInstanceMap();
    private static AccessServiceDescription myDescription = AccessServiceDescription.GOVERNANCE_ENGINE_OMAS;

    GovernanceEngineInstanceHandler() {
        GovernanceEngineRegistration.registerAccessService();
    }

    public String getAccessServiceName(String serverName) throws PropertyServerException {
        GovernanceEngineServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getAccessServiceName();
        }
        String methodName = "getAccessServiceName";
        GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.SERVICE_NOT_INITIALIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, "getAccessServiceName"});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getAccessServiceName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    OMRSMetadataCollection getMetadataCollection(String serverName) throws PropertyServerException {
        GovernanceEngineServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getMetadataCollection();
        }
        String methodName = "getMetadataCollection";
        GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.SERVICE_NOT_INITIALIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, "getMetadataCollection"});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getMetadataCollection", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public OMRSRepositoryConnector getRepositoryConnector(String serverName) throws PropertyServerException {
        GovernanceEngineServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getRepositoryConnector();
        }
        String methodName = "getRepositoryConnector";
        GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.SERVICE_NOT_INITIALIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, "getRepositoryConnector"});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getRepositoryConnector", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }
}

