/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.GuidNotFoundException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.MetadataServerException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceClassificationDefAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceClassificationDefListAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceEngineOMASAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAssetAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAssetListAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineInstanceHandler;
import org.odpi.openmetadata.accessservices.governanceengine.server.handlers.GovernanceClassificationDefHandler;
import org.odpi.openmetadata.accessservices.governanceengine.server.handlers.GovernedAssetHandler;
import org.odpi.openmetadata.accessservices.governanceengine.server.util.ExceptionHandler;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovernanceEngineRESTServices {
    private static final Logger log = LoggerFactory.getLogger(GovernanceEngineRESTServices.class);
    private static GovernanceEngineInstanceHandler instanceHandler = new GovernanceEngineInstanceHandler();
    private ExceptionHandler exceptionHandler = new ExceptionHandler();

    public GovernanceClassificationDefListAPIResponse getGovernanceClassificationDefs(String serverName, String userId, List<String> classification) {
        GovernanceClassificationDefListAPIResponse response = new GovernanceClassificationDefListAPIResponse();
        try {
            GovernanceClassificationDefHandler governanceClassificationDefHandler = new GovernanceClassificationDefHandler(instanceHandler.getAccessServiceName(serverName), instanceHandler.getRepositoryConnector(serverName));
            response.setClassificationDefsList(governanceClassificationDefHandler.getGovernanceClassificationDefs(userId, classification));
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (MetadataServerException error) {
            this.exceptionHandler.captureMetadataServerException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.UserNotAuthorizedException error) {
            this.exceptionHandler.captureUserNotAuthorizedException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.exceptionHandler.capturePropertyServerException((GovernanceEngineOMASAPIResponse)response, error);
        }
        return response;
    }

    public GovernanceClassificationDefAPIResponse getClassificationDefs(String serverName, String userId, String classificationGuid) {
        GovernanceClassificationDefAPIResponse response = new GovernanceClassificationDefAPIResponse();
        try {
            GovernanceClassificationDefHandler tagHandler = new GovernanceClassificationDefHandler(instanceHandler.getAccessServiceName(serverName), instanceHandler.getRepositoryConnector(serverName));
            response.setGovernanceClassificationDef(tagHandler.getGovernanceClassificationDef(userId, classificationGuid));
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (MetadataServerException error) {
            this.exceptionHandler.captureMetadataServerException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.UserNotAuthorizedException error) {
            this.exceptionHandler.captureUserNotAuthorizedException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (GuidNotFoundException error) {
            this.exceptionHandler.captureGuidNotFoundException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.exceptionHandler.capturePropertyServerException((GovernanceEngineOMASAPIResponse)response, error);
        }
        return response;
    }

    public GovernedAssetListAPIResponse getGovernedAssets(String serverName, String userId, List<String> classification, List<String> type) {
        log.debug("Calling method: getGovernedAssets");
        GovernedAssetListAPIResponse response = new GovernedAssetListAPIResponse();
        try {
            GovernedAssetHandler governedAssetHandler = new GovernedAssetHandler(instanceHandler.getRepositoryConnector(serverName));
            response.setGovernedAssetList(governedAssetHandler.getGovernedAssets(userId, classification, type));
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (MetadataServerException error) {
            this.exceptionHandler.captureMetadataServerException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.exceptionHandler.capturePropertyServerException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | FunctionNotSupportedException | org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeDefNotKnownException | TypeErrorException | UserNotAuthorizedException e) {
            log.error(e.getErrorMessage());
        }
        return response;
    }

    public GovernedAssetAPIResponse getGovernedAsset(String serverName, String userId, String assetGuid) {
        GovernedAssetAPIResponse response = new GovernedAssetAPIResponse();
        try {
            GovernedAssetHandler governedAssetHandler = new GovernedAssetHandler(instanceHandler.getRepositoryConnector(serverName));
            response.setAsset(governedAssetHandler.getGovernedAsset(userId, assetGuid));
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (MetadataServerException error) {
            this.exceptionHandler.captureMetadataServerException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.exceptionHandler.capturePropertyServerException((GovernanceEngineOMASAPIResponse)response, error);
        }
        return response;
    }
}

