/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.errorcode.GovernanceEngineErrorCode;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.GuidNotFoundException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.MetadataServerException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceClassificationDef;
import org.odpi.openmetadata.accessservices.governanceengine.server.handlers.GovernanceEngineValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;

public class GovernanceClassificationDefHandler {
    private OMRSMetadataCollection metadataCollection = null;
    private String serviceName;
    private OMRSRepositoryHelper repositoryHelper = null;
    private String serverName = null;
    private static GovernanceEngineValidator validator;

    public GovernanceClassificationDefHandler(String serviceName, OMRSRepositoryConnector repositoryConnector) throws MetadataServerException {
        String methodName = "GovernanceClassificationDefHandler";
        this.serviceName = serviceName;
        if (repositoryConnector != null) {
            this.repositoryHelper = repositoryConnector.getRepositoryHelper();
            this.serverName = repositoryConnector.getServerName();
            try {
                this.metadataCollection = repositoryConnector.getMetadataCollection();
            }
            catch (RepositoryErrorException e) {
                GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.NO_METADATA_COLLECTION;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"GovernanceClassificationDefHandler"});
                throw new MetadataServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "GovernanceClassificationDefHandler", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        }
    }

    public List<GovernanceClassificationDef> getGovernanceClassificationDefs(String userId, List<String> classification) throws InvalidParameterException, MetadataServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceClassificationDefs";
        String nameParameter = "name";
        GovernanceEngineValidator.validateUserId(userId, "getGovernanceClassificationDefs");
        GovernanceEngineValidator.validateClassification(classification, "name", "getGovernanceClassificationDefs");
        ArrayList<GovernanceClassificationDef> defsToReturn = new ArrayList<GovernanceClassificationDef>();
        try {
            List typeDefsByCategory = this.metadataCollection.findTypeDefsByCategory(userId, TypeDefCategory.CLASSIFICATION_DEF);
            if (typeDefsByCategory != null) {
                typeDefsByCategory.forEach(typeDef -> {
                    GovernanceClassificationDef governanceClassificationDef = this.getGovernanceClassificationDef((TypeDef)typeDef);
                    defsToReturn.add(governanceClassificationDef);
                });
            }
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.USER_NOT_AUTHORIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{userId, "getGovernanceClassificationDefs"});
            throw new UserNotAuthorizedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getGovernanceClassificationDefs", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException | RepositoryErrorException e) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.METADATA_QUERY_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getGovernanceClassificationDefs"});
            throw new MetadataServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getGovernanceClassificationDefs", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return defsToReturn;
    }

    private GovernanceClassificationDef getGovernanceClassificationDef(TypeDef typeDef) {
        GovernanceClassificationDef governanceClassificationDef = new GovernanceClassificationDef();
        governanceClassificationDef.setName(typeDef.getName());
        Map<String, String> propertyMap = this.getProperties(typeDef);
        governanceClassificationDef.setAttributeDefinitions(propertyMap);
        return governanceClassificationDef;
    }

    private Map<String, String> getProperties(TypeDef typeDef) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        List properties = typeDef.getPropertiesDefinition();
        if (properties != null) {
            properties.forEach(attribute -> propertyMap.put(attribute.getAttributeName(), attribute.getAttributeType().getName()));
        }
        return propertyMap;
    }

    public GovernanceClassificationDef getGovernanceClassificationDef(String userId, String tagGuid) throws InvalidParameterException, MetadataServerException, UserNotAuthorizedException, GuidNotFoundException {
        String methodName = "getGovernanceClassificationDef";
        GovernanceEngineValidator.validateUserId(userId, "getGovernanceClassificationDef");
        GovernanceEngineValidator.validateGUID(tagGuid, "tagGuid", "getGovernanceClassificationDef");
        try {
            TypeDef typeDef = this.metadataCollection.getTypeDefByGUID(userId, tagGuid);
            return this.getGovernanceClassificationDef(typeDef);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.USER_NOT_AUTHORIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{userId, "getGovernanceClassificationDef"});
            throw new UserNotAuthorizedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getGovernanceClassificationDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException | RepositoryErrorException e) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.METADATA_QUERY_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getGovernanceClassificationDef"});
            throw new MetadataServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getGovernanceClassificationDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        catch (TypeDefNotKnownException e) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.GUID_NOT_FOUND_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getGovernanceClassificationDef"});
            throw new GuidNotFoundException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getGovernanceClassificationDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }
}

