/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.errorcode.GovernanceEngineErrorCode;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.MetadataServerException;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.Context;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceClassification;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAsset;
import org.odpi.openmetadata.accessservices.governanceengine.server.handlers.GovernanceEngineValidator;
import org.odpi.openmetadata.accessservices.governanceengine.server.processor.ContextBuilder;
import org.odpi.openmetadata.accessservices.governanceengine.server.util.PropertyUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovernedAssetHandler {
    private static final Logger log = LoggerFactory.getLogger(GovernedAssetHandler.class);
    private OMRSMetadataCollection metadataCollection;
    private Map<String, String> knownTypeDefs = new HashMap<String, String>();
    private Set<String> governedClassifications = this.setGovernedClassifications();
    private ContextBuilder contextBuilder = new ContextBuilder();

    public GovernedAssetHandler(OMRSRepositoryConnector repositoryConnector) throws MetadataServerException {
        String methodName = "GovernedAssetHandler";
        if (repositoryConnector != null) {
            try {
                this.metadataCollection = repositoryConnector.getMetadataCollection();
            }
            catch (RepositoryErrorException e) {
                GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.NO_METADATA_COLLECTION;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"GovernedAssetHandler"});
                throw new MetadataServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "GovernedAssetHandler", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        }
    }

    public List<GovernedAsset> getGovernedAssets(String userId, List<String> classification, List<String> type) throws InvalidParameterException, EntityProxyOnlyException, TypeErrorException, FunctionNotSupportedException, PropertyErrorException, EntityNotKnownException, TypeDefNotKnownException, PagingErrorException, UserNotAuthorizedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, RepositoryErrorException {
        List<String> classificationTypeDef;
        String methodName = "getGovernedAssets";
        String classificationParameter = "classification";
        String typeParameter = "type";
        GovernanceEngineValidator.validateUserId(userId, "getGovernedAssets");
        GovernanceEngineValidator.validateClassification(classification, "classification", "getGovernedAssets");
        GovernanceEngineValidator.validateType(classification, "type", "getGovernedAssets");
        if (classification == null && (classificationTypeDef = this.getClassificationsDef(userId)) != null) {
            classification = new ArrayList<String>(classificationTypeDef);
        }
        ArrayList<GovernedAsset> response = new ArrayList<GovernedAsset>();
        if (type == null) {
            return this.addToAssetListByType(null, classification, userId);
        }
        for (String searchedType : type) {
            List<GovernedAsset> assetsByType = this.addToAssetListByType(searchedType, classification, userId);
            if (assetsByType == null) continue;
            response.addAll(assetsByType);
        }
        return response;
    }

    public GovernedAsset getGovernedAsset(String userId, String assetGuid) throws InvalidParameterException {
        String methodName = "getGovernedAsset";
        String assetParameter = "assetGuid";
        GovernanceEngineValidator.validateUserId(userId, "getGovernedAsset");
        GovernanceEngineValidator.validateGUID(assetGuid, "assetGuid", "getGovernedAsset");
        try {
            EntityDetail entityDetail = this.getEntityDetailById(userId, assetGuid);
            if (entityDetail == null) {
                return null;
            }
            GovernedAsset governedAsset = this.getGovernedAsset(entityDetail);
            if (entityDetail.getClassifications() != null && !entityDetail.getClassifications().isEmpty()) {
                List<GovernanceClassification> governanceClassifications = this.getGovernanceClassifications(entityDetail.getClassifications());
                governedAsset.setAssignedGovernanceClassifications(governanceClassifications);
            }
            return governedAsset;
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | FunctionNotSupportedException | org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeDefNotKnownException | TypeErrorException | UserNotAuthorizedException e) {
            log.error(e.getErrorMessage());
            return null;
        }
    }

    public boolean containsGovernedClassification(EntityDetail entityDetail) {
        if (entityDetail.getClassifications() == null || entityDetail.getClassifications().isEmpty()) {
            return false;
        }
        for (Classification classification : entityDetail.getClassifications()) {
            if (!this.isGovernedClassification(classification.getType().getTypeDefName())) continue;
            return true;
        }
        return false;
    }

    public List<GovernanceClassification> getGovernanceClassifications(List<Classification> allClassifications) {
        List<Classification> governedClassifications = this.filterGovernedClassifications(allClassifications);
        ArrayList<GovernanceClassification> classifications = new ArrayList<GovernanceClassification>(governedClassifications.size());
        for (Classification classification : governedClassifications) {
            classifications.add(this.getGovernanceClassification(classification));
        }
        return classifications;
    }

    private Set<String> setGovernedClassifications() {
        HashSet<String> classifications = new HashSet<String>(4);
        classifications.add("Confidentiality");
        classifications.add("Confidence");
        classifications.add("Criticality");
        classifications.add("Retention");
        return classifications;
    }

    private List<GovernedAsset> addToAssetListByType(String type, List<String> classification, String userId) throws EntityProxyOnlyException, TypeErrorException, TypeDefNotKnownException, PropertyErrorException, EntityNotKnownException, FunctionNotSupportedException, PagingErrorException, UserNotAuthorizedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, RepositoryErrorException {
        if (classification == null) {
            return Collections.emptyList();
        }
        ArrayList<GovernedAsset> response = new ArrayList<GovernedAsset>();
        for (String searchedClassifications : classification) {
            List<GovernedAsset> assetsToReturn = this.addToAssetListByClassification(type, searchedClassifications, userId);
            response.addAll(assetsToReturn);
        }
        return response;
    }

    private List<String> getClassificationsDef(String userId) {
        try {
            List classificationsDef = this.metadataCollection.findTypeDefsByCategory(userId, TypeDefCategory.CLASSIFICATION_DEF);
            return classificationsDef.stream().map(TypeDefLink::getName).collect(Collectors.toList());
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            log.error(e.getErrorMessage());
            return Collections.emptyList();
        }
    }

    private List<GovernedAsset> addToAssetListByClassification(String type, String classification, String userId) throws EntityProxyOnlyException, TypeErrorException, FunctionNotSupportedException, PropertyErrorException, EntityNotKnownException, TypeDefNotKnownException, PagingErrorException, UserNotAuthorizedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, RepositoryErrorException {
        String typeGuid = this.getTypeGuidFromTypeName(type, userId);
        List<EntityDetail> entities = this.getEntitiesByClassification(classification, userId, typeGuid);
        ArrayList<GovernedAsset> assetsToReturn = new ArrayList<GovernedAsset>();
        if (entities != null) {
            for (EntityDetail entity : entities) {
                GovernedAsset entry = this.existingGovernedAsset(assetsToReturn, entity);
                if (entry == null) {
                    entry = this.getGovernedAsset(entity);
                    assetsToReturn.add(entry);
                }
                this.addClassificationInfoToEntry(entry, entity);
            }
        }
        return assetsToReturn;
    }

    private GovernedAsset existingGovernedAsset(List<GovernedAsset> assetsToReturn, EntityDetail entity) {
        Optional<GovernedAsset> asset = assetsToReturn.stream().filter(s -> entity.getGUID().equals(s.getGuid())).findFirst();
        return asset.orElse(null);
    }

    private List<EntityDetail> getEntitiesByClassification(String classification, String userId, String typeGuid) {
        try {
            return this.metadataCollection.findEntitiesByClassification(userId, typeGuid, classification, null, null, 0, null, null, null, null, 0);
        }
        catch (ClassificationErrorException | FunctionNotSupportedException | org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            log.error(e.getErrorMessage());
            return Collections.emptyList();
        }
    }

    private void addClassificationInfoToEntry(GovernedAsset entry, EntityDetail governedAsset) {
        List<Classification> classifications = this.filterGovernedClassifications(governedAsset.getClassifications());
        if (classifications == null || classifications.isEmpty()) {
            return;
        }
        List<GovernanceClassification> governanceClassifications = this.getGovernanceClassifications(entry, classifications);
        if (governanceClassifications.isEmpty()) {
            return;
        }
        ArrayList<GovernanceClassification> usageList = entry.getAssignedGovernanceClassifications();
        if (usageList == null) {
            usageList = new ArrayList<GovernanceClassification>();
        }
        usageList.addAll(governanceClassifications);
        entry.setAssignedGovernanceClassifications(usageList);
    }

    private List<GovernanceClassification> getGovernanceClassifications(GovernedAsset entry, List<Classification> classifications) {
        ArrayList<GovernanceClassification> governanceClassifications = new ArrayList<GovernanceClassification>();
        for (Classification classification : classifications) {
            if (this.containsGovernedClassification(entry, classification)) continue;
            GovernanceClassification governanceClassification = this.getGovernanceClassification(classification);
            governanceClassifications.add(governanceClassification);
        }
        return governanceClassifications;
    }

    private GovernanceClassification getGovernanceClassification(Classification classification) {
        GovernanceClassification governanceClassification = new GovernanceClassification();
        governanceClassification.setName(classification.getName());
        Map<String, String> attributes = this.getInstanceProperties(classification);
        governanceClassification.setAttributes(attributes);
        return governanceClassification;
    }

    private boolean containsGovernedClassification(GovernedAsset entry, Classification classification) {
        if (entry.getAssignedGovernanceClassifications() == null || entry.getAssignedGovernanceClassifications().isEmpty()) {
            return false;
        }
        long count = entry.getAssignedGovernanceClassifications().stream().filter(c -> c.getName().equals(classification.getType().getTypeDefName())).count();
        return count != 0L;
    }

    private Map<String, String> getInstanceProperties(Classification classification) {
        Map instanceProperties;
        HashMap<String, String> attributes = new HashMap<String, String>();
        InstanceProperties properties = classification.getProperties();
        if (properties != null && (instanceProperties = properties.getInstanceProperties()) != null) {
            instanceProperties.forEach((key, value) -> attributes.put((String)key, PropertyUtils.getStringForPropertyValue(value)));
        }
        return attributes;
    }

    private List<Classification> filterGovernedClassifications(List<Classification> classifications) {
        return classifications.stream().filter(c -> this.isGovernedClassification(c.getType().getTypeDefName())).collect(Collectors.toList());
    }

    private boolean isGovernedClassification(String classificationName) {
        return this.governedClassifications.contains(classificationName);
    }

    public GovernedAsset getGovernedAsset(EntityDetail entity) throws EntityProxyOnlyException, TypeErrorException, TypeDefNotKnownException, PropertyErrorException, EntityNotKnownException, FunctionNotSupportedException, PagingErrorException, UserNotAuthorizedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, RepositoryErrorException {
        GovernedAsset governedAsset = new GovernedAsset();
        governedAsset.setGuid(entity.getGUID());
        governedAsset.setType(entity.getType().getTypeDefName());
        governedAsset.setFullQualifiedName(this.getResourceValue(entity, "qualifiedName"));
        governedAsset.setName(this.getResourceValue(entity, "displayName"));
        governedAsset.setContexts(this.buildDatabaseContext(entity));
        return governedAsset;
    }

    private List<Context> buildDatabaseContext(EntityDetail entity) throws EntityProxyOnlyException, TypeErrorException, FunctionNotSupportedException, PropertyErrorException, EntityNotKnownException, TypeDefNotKnownException, PagingErrorException, UserNotAuthorizedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, RepositoryErrorException {
        switch (entity.getType().getTypeDefName()) {
            case "RelationalColumn": {
                return this.contextBuilder.buildContextForColumn(this.metadataCollection, entity.getGUID());
            }
            case "RelationalTable": {
                return this.contextBuilder.buildContextForTable(this.metadataCollection, entity.getGUID());
            }
            case "GlossaryTerm": {
                return this.contextBuilder.buildContextForGlossaryTerm(this.metadataCollection, entity.getGUID());
            }
        }
        return new ArrayList<Context>();
    }

    private String getTypeGuidFromTypeName(String typeName, String userId) {
        try {
            if (this.knownTypeDefs.containsKey(typeName)) {
                return this.knownTypeDefs.get(typeName);
            }
            String typeDefGuid = this.metadataCollection.getTypeDefByName(userId, typeName).getGUID();
            this.knownTypeDefs.put(typeName, typeDefGuid);
            return typeDefGuid;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException | RepositoryErrorException | TypeDefNotKnownException | UserNotAuthorizedException e) {
            log.error(e.getErrorMessage());
            return null;
        }
    }

    private String getResourceValue(EntityDetail entityDetail, String propertyName) {
        PrimitivePropertyValue value;
        InstanceProperties instanceProperties = entityDetail.getProperties();
        if (instanceProperties.getPropertyValue(propertyName) instanceof PrimitivePropertyValue && (value = (PrimitivePropertyValue)instanceProperties.getPropertyValue(propertyName)) != null && value.getPrimitiveValue() instanceof String) {
            return (String)value.getPrimitiveValue();
        }
        return null;
    }

    private EntityDetail getEntityDetailById(String userId, String assetGuid) {
        try {
            return this.metadataCollection.getEntityDetail(userId, assetGuid);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            log.error(e.getErrorMessage());
            return null;
        }
    }
}

