/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.MetadataServerException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceEngineOMASAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAssetAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAssetListAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.SoftwareServerCapabilityRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.SoftwareServerCapabilityResponse;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineInstanceHandler;
import org.odpi.openmetadata.accessservices.governanceengine.server.handlers.GovernedAssetHandler;
import org.odpi.openmetadata.accessservices.governanceengine.server.util.ExceptionHandler;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class GovernanceEngineRESTServices {
    private static GovernanceEngineInstanceHandler instanceHandler = new GovernanceEngineInstanceHandler();
    private ExceptionHandler exceptionHandler = new ExceptionHandler();

    public GovernedAssetListAPIResponse getGovernedAssets(String serverName, String userId, List<String> type) {
        GovernedAssetListAPIResponse response = new GovernedAssetListAPIResponse();
        try {
            GovernedAssetHandler governedAssetHandler = new GovernedAssetHandler(instanceHandler.getRepositoryConnector(serverName));
            response.setGovernedAssetList(governedAssetHandler.getGovernedAssets(userId, type));
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (MetadataServerException error) {
            this.exceptionHandler.captureMetadataServerException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.exceptionHandler.capturePropertyServerException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (ClassificationErrorException | EntityNotKnownException | EntityProxyOnlyException | FunctionNotSupportedException | org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeDefNotKnownException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionHandler.captureOMRSException((GovernanceEngineOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }

    public GovernedAssetAPIResponse getGovernedAsset(String serverName, String userId, String assetGuid) {
        GovernedAssetAPIResponse response = new GovernedAssetAPIResponse();
        try {
            GovernedAssetHandler governedAssetHandler = new GovernedAssetHandler(instanceHandler.getRepositoryConnector(serverName));
            response.setAsset(governedAssetHandler.getGovernedAsset(userId, assetGuid));
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (MetadataServerException error) {
            this.exceptionHandler.captureMetadataServerException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.exceptionHandler.capturePropertyServerException((GovernanceEngineOMASAPIResponse)response, error);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | FunctionNotSupportedException | org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeDefNotKnownException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionHandler.captureOMRSException((GovernanceEngineOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }

    public SoftwareServerCapabilityResponse createSoftwareServer(String serverName, String userId, SoftwareServerCapabilityRequestBody requestBody) {
        SoftwareServerCapabilityResponse response = new SoftwareServerCapabilityResponse();
        try {
            GovernedAssetHandler governedAssetHandler = new GovernedAssetHandler(instanceHandler.getRepositoryConnector(serverName));
            response.setServerCapability(governedAssetHandler.createSoftwareServerCapability(userId, requestBody.getSoftwareServerCapability()));
        }
        catch (MetadataServerException e) {
            this.exceptionHandler.captureMetadataServerException((GovernanceEngineOMASAPIResponse)response, e);
        }
        catch (PropertyServerException e) {
            this.exceptionHandler.capturePropertyServerException((GovernanceEngineOMASAPIResponse)response, e);
        }
        catch (ClassificationErrorException | FunctionNotSupportedException | org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException | PropertyErrorException | RepositoryErrorException | StatusNotSupportedException | TypeErrorException | UserNotAuthorizedException e) {
            this.exceptionHandler.captureOMRSException((GovernanceEngineOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }

    public SoftwareServerCapabilityResponse getSoftwareServerByGUID(String serverName, String userId, String guid) {
        SoftwareServerCapabilityResponse response = new SoftwareServerCapabilityResponse();
        try {
            GovernedAssetHandler governedAssetHandler = new GovernedAssetHandler(instanceHandler.getRepositoryConnector(serverName));
            response.setServerCapability(governedAssetHandler.getSoftwareServerCapabilityByGUID(userId, guid));
        }
        catch (MetadataServerException e) {
            this.exceptionHandler.captureMetadataServerException((GovernanceEngineOMASAPIResponse)response, e);
        }
        catch (PropertyServerException e) {
            this.exceptionHandler.capturePropertyServerException((GovernanceEngineOMASAPIResponse)response, e);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            this.exceptionHandler.captureOMRSException((GovernanceEngineOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        return response;
    }
}

