/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.handlers;

import java.lang.invoke.MethodHandles;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.errorcode.GovernanceEngineErrorCode;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.InvalidParameterException;
import org.springframework.util.StringUtils;

public final class GovernanceEngineValidator {
    private GovernanceEngineValidator() {
    }

    static void validateUserId(String userId, String methodName) throws InvalidParameterException {
        if (StringUtils.isEmpty((Object)userId)) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.EMPTY_USER_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), MethodHandles.lookup().lookupClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    static void validateGUID(String guid, String parameterName, String methodName) throws InvalidParameterException {
        if (StringUtils.isEmpty((Object)guid)) {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.NULL_GUID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), MethodHandles.lookup().lookupClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }
}

