/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.errorcode.GovernanceEngineErrorCode;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.MetadataServerException;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.Context;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceClassification;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAsset;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.SoftwareServerCapability;
import org.odpi.openmetadata.accessservices.governanceengine.server.handlers.GovernanceEngineValidator;
import org.odpi.openmetadata.accessservices.governanceengine.server.processor.ContextBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class GovernedAssetHandler {
    private OMRSMetadataCollection metadataCollection;
    private OMRSRepositoryConnector repositoryConnector;
    private Map<String, String> knownTypeDefs = new HashMap<String, String>();
    private ContextBuilder contextBuilder = new ContextBuilder();

    public GovernedAssetHandler(OMRSRepositoryConnector repositoryConnector) throws MetadataServerException {
        String methodName = "GovernedAssetHandler";
        if (repositoryConnector != null) {
            try {
                this.repositoryConnector = repositoryConnector;
                this.metadataCollection = repositoryConnector.getMetadataCollection();
            }
            catch (RepositoryErrorException e) {
                GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.NO_METADATA_COLLECTION;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"GovernedAssetHandler"});
                throw new MetadataServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "GovernedAssetHandler", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        }
    }

    public List<GovernedAsset> getGovernedAssets(String userId, List<String> type) throws InvalidParameterException, EntityProxyOnlyException, TypeErrorException, FunctionNotSupportedException, PropertyErrorException, EntityNotKnownException, TypeDefNotKnownException, PagingErrorException, UserNotAuthorizedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, RepositoryErrorException, ClassificationErrorException {
        String methodName = "getGovernedAssets";
        GovernanceEngineValidator.validateUserId(userId, "getGovernedAssets");
        ArrayList<EntityDetail> response = new ArrayList();
        if (type == null) {
            response = this.getEntitiesByClassification(userId, null);
        } else {
            for (String searchedType : type) {
                String typeGUID = this.getTypeGuidFromTypeName(userId, searchedType);
                response.addAll(this.getEntitiesByClassification(userId, typeGUID));
            }
        }
        return this.getGovernedAssets(response);
    }

    public GovernedAsset getGovernedAsset(String userId, String assetGuid) throws InvalidParameterException, EntityProxyOnlyException, TypeErrorException, FunctionNotSupportedException, PropertyErrorException, EntityNotKnownException, TypeDefNotKnownException, PagingErrorException, UserNotAuthorizedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, RepositoryErrorException {
        String methodName = "getGovernedAsset";
        String assetParameter = "assetGuid";
        GovernanceEngineValidator.validateUserId(userId, "getGovernedAsset");
        GovernanceEngineValidator.validateGUID(assetGuid, "assetGuid", "getGovernedAsset");
        EntityDetail entityDetail = this.getEntityDetailById(userId, assetGuid);
        if (entityDetail == null) {
            return null;
        }
        return this.getGovernedAsset(entityDetail);
    }

    public boolean containsGovernedClassification(EntityDetail entityDetail) {
        if (entityDetail.getClassifications() == null || entityDetail.getClassifications().isEmpty()) {
            return false;
        }
        for (Classification classification : entityDetail.getClassifications()) {
            if (!this.isGovernedClassification(classification.getType().getTypeDefName())) continue;
            return true;
        }
        return false;
    }

    public boolean isSchemaElement(EntityDetail entityDetail) throws UserNotAuthorizedException, RepositoryErrorException, org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, TypeDefNotKnownException {
        List typeDefSuperTypes = entityDetail.getType().getTypeDefSuperTypes();
        boolean schemaAttribute = typeDefSuperTypes.stream().anyMatch(typeDefLink -> typeDefLink.getName().equals("SchemaAttribute"));
        if (schemaAttribute) {
            return true;
        }
        for (TypeDefLink typeDefLink2 : typeDefSuperTypes) {
            TypeDef typeDef = this.metadataCollection.getTypeDefByName("GovernanceEngine", typeDefLink2.getName());
            if (!typeDef.getSuperType().getName().equals("SchemaAttribute")) continue;
            return true;
        }
        return false;
    }

    public GovernedAsset getGovernedAsset(EntityDetail entity) throws EntityProxyOnlyException, TypeErrorException, TypeDefNotKnownException, PropertyErrorException, EntityNotKnownException, FunctionNotSupportedException, PagingErrorException, UserNotAuthorizedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, RepositoryErrorException {
        GovernedAsset governedAsset = new GovernedAsset();
        governedAsset.setGuid(entity.getGUID());
        governedAsset.setType(entity.getType().getTypeDefName());
        governedAsset.setFullQualifiedName(this.getResourceValue(entity, "qualifiedName"));
        governedAsset.setName(this.getResourceValue(entity, "displayName"));
        governedAsset.setContext(this.buildContext(entity));
        if (entity.getClassifications() != null && !entity.getClassifications().isEmpty()) {
            governedAsset.setAssignedGovernanceClassification(this.getGovernanceClassification(entity.getClassifications()));
        }
        return governedAsset;
    }

    public SoftwareServerCapability createSoftwareServerCapability(String userId, SoftwareServerCapability softwareServerCapability) throws ClassificationErrorException, StatusNotSupportedException, UserNotAuthorizedException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException {
        InstanceProperties initialProperties = this.getSoftwareServerCapabilityProperties(softwareServerCapability);
        EntityDetail entityDetail = this.metadataCollection.addEntity(userId, "fe30a033-8f86-4d17-8986-e6166fa24177", initialProperties, Collections.emptyList(), InstanceStatus.ACTIVE);
        return this.getSoftwareServer(entityDetail);
    }

    public SoftwareServerCapability getSoftwareServerCapabilityByGUID(String userId, String guid) throws UserNotAuthorizedException, RepositoryErrorException, EntityProxyOnlyException, org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, EntityNotKnownException {
        EntityDetail entityDetail = this.metadataCollection.getEntityDetail(userId, guid);
        if (entityDetail.getType().getTypeDefName().equals("SoftwareServerCapability")) {
            return this.getSoftwareServer(entityDetail);
        }
        return null;
    }

    private GovernanceClassification getGovernanceClassification(List<Classification> allClassifications) {
        Optional<Classification> classification = this.filterGovernedClassification(allClassifications);
        return classification.map(this::getGovernanceClassification).orElse(null);
    }

    private List<EntityDetail> getEntitiesByClassification(String userId, String typeGuid) throws ClassificationErrorException, UserNotAuthorizedException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException {
        return this.metadataCollection.findEntitiesByClassification(userId, typeGuid, "SecurityTags", null, null, 0, null, null, null, null, 0);
    }

    private GovernanceClassification getGovernanceClassification(Classification classification) {
        GovernanceClassification governanceClassification = new GovernanceClassification();
        governanceClassification.setName(classification.getName());
        InstanceProperties properties = classification.getProperties();
        if (properties != null) {
            String methodName = "getInstanceProperties";
            List securityLabels = this.repositoryConnector.getRepositoryHelper().getStringArrayProperty("GovernanceEngine", "securityLabels", properties, methodName);
            governanceClassification.setSecurityLabels(securityLabels);
            Map securityProperties = this.repositoryConnector.getRepositoryHelper().getStringMapFromProperty("GovernanceEngine", "securityProperties", properties, methodName);
            governanceClassification.setSecurityProperties(securityProperties);
        }
        return governanceClassification;
    }

    private Optional<Classification> filterGovernedClassification(List<Classification> classifications) {
        return classifications.stream().filter(c -> this.isGovernedClassification(c.getType().getTypeDefName())).findAny();
    }

    private boolean isGovernedClassification(String classificationName) {
        return "SecurityTags".equals(classificationName);
    }

    private List<GovernedAsset> getGovernedAssets(List<EntityDetail> entityDetails) throws EntityProxyOnlyException, TypeErrorException, FunctionNotSupportedException, PropertyErrorException, EntityNotKnownException, TypeDefNotKnownException, PagingErrorException, UserNotAuthorizedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, RepositoryErrorException {
        if (entityDetails == null || entityDetails.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GovernedAsset> governedAssets = new ArrayList<GovernedAsset>(entityDetails.size());
        for (EntityDetail entityDetail : entityDetails) {
            governedAssets.add(this.getGovernedAsset(entityDetail));
        }
        return governedAssets;
    }

    private Context buildContext(EntityDetail entity) throws EntityProxyOnlyException, TypeErrorException, FunctionNotSupportedException, PropertyErrorException, EntityNotKnownException, TypeDefNotKnownException, PagingErrorException, UserNotAuthorizedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, RepositoryErrorException {
        switch (entity.getType().getTypeDefName()) {
            case "RelationalColumn": {
                return this.contextBuilder.buildContextForColumn(this.metadataCollection, entity.getGUID());
            }
            case "RelationalTable": {
                return this.contextBuilder.buildContextForTable(this.metadataCollection, entity.getGUID());
            }
        }
        return null;
    }

    private String getTypeGuidFromTypeName(String typeName, String userId) throws UserNotAuthorizedException, RepositoryErrorException, org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, TypeDefNotKnownException {
        if (!this.knownTypeDefs.containsKey(typeName)) {
            String typeDefGuid = this.metadataCollection.getTypeDefByName(userId, typeName).getGUID();
            this.knownTypeDefs.put(typeName, typeDefGuid);
            return typeDefGuid;
        }
        return this.knownTypeDefs.get(typeName);
    }

    private String getResourceValue(EntityDetail entityDetail, String propertyName) {
        PrimitivePropertyValue value;
        InstanceProperties instanceProperties = entityDetail.getProperties();
        if (instanceProperties.getPropertyValue(propertyName) instanceof PrimitivePropertyValue && (value = (PrimitivePropertyValue)instanceProperties.getPropertyValue(propertyName)) != null && value.getPrimitiveValue() instanceof String) {
            return (String)value.getPrimitiveValue();
        }
        return null;
    }

    private EntityDetail getEntityDetailById(String userId, String assetGuid) throws UserNotAuthorizedException, RepositoryErrorException, EntityProxyOnlyException, org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, EntityNotKnownException {
        return this.metadataCollection.getEntityDetail(userId, assetGuid);
    }

    private SoftwareServerCapability getSoftwareServer(EntityDetail entityDetail) {
        InstanceProperties properties = entityDetail.getProperties();
        OMRSRepositoryHelper repositoryHelper = this.repositoryConnector.getRepositoryHelper();
        SoftwareServerCapability softwareServerCapability = new SoftwareServerCapability();
        softwareServerCapability.setGUID(entityDetail.getGUID());
        softwareServerCapability.setOpenTypeGUID(entityDetail.getType().getTypeDefName());
        softwareServerCapability.setName(this.getStringProperty(properties, "name", repositoryHelper));
        softwareServerCapability.setDescription(this.getStringProperty(properties, "description", repositoryHelper));
        softwareServerCapability.setType(this.getStringProperty(properties, "type", repositoryHelper));
        softwareServerCapability.setPatchLevel(this.getStringProperty(properties, "patchLevel", repositoryHelper));
        softwareServerCapability.setVersion(this.getStringProperty(properties, "version", repositoryHelper));
        softwareServerCapability.setSource(this.getStringProperty(properties, "source", repositoryHelper));
        return softwareServerCapability;
    }

    private InstanceProperties getSoftwareServerCapabilityProperties(SoftwareServerCapability softwareServerCapability) {
        InstanceProperties properties = new InstanceProperties();
        OMRSRepositoryHelper repositoryHelper = this.repositoryConnector.getRepositoryHelper();
        this.addStringProperty(softwareServerCapability.getName(), "name", properties, repositoryHelper);
        this.addStringProperty(softwareServerCapability.getDescription(), "description", properties, repositoryHelper);
        this.addStringProperty(softwareServerCapability.getType(), "type", properties, repositoryHelper);
        this.addStringProperty(softwareServerCapability.getVersion(), "version", properties, repositoryHelper);
        this.addStringProperty(softwareServerCapability.getPatchLevel(), "patchLevel", properties, repositoryHelper);
        this.addStringProperty(softwareServerCapability.getSource(), "source", properties, repositoryHelper);
        return properties;
    }

    private void addStringProperty(String propertyValue, String propertyName, InstanceProperties properties, OMRSRepositoryHelper repositoryHelper) {
        String methodName = "addStringProperty";
        if (propertyValue != null) {
            repositoryHelper.addStringPropertyToInstance("GovernanceEngine", properties, propertyName, propertyValue, methodName);
        }
    }

    private String getStringProperty(InstanceProperties properties, String propertyName, OMRSRepositoryHelper repositoryHelper) {
        return repositoryHelper.getStringProperty("GovernanceEngine", propertyName, properties, "getStringProperty");
    }
}

