/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.Context;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class ContextBuilder {
    private Map<String, String> relationalTableNames = new HashMap<String, String>();

    public Context buildContextForColumn(OMRSMetadataCollection metadataCollection, String assetId) throws UserNotAuthorizedException, RepositoryErrorException, EntityProxyOnlyException, InvalidParameterException, EntityNotKnownException, TypeErrorException, TypeDefNotKnownException, PropertyErrorException, FunctionNotSupportedException, PagingErrorException {
        EntityDetail column = this.getEntity(metadataCollection, assetId);
        if (this.isRelationalColumn(column)) {
            return this.getDatabaseContextForColumn(metadataCollection, column);
        }
        return null;
    }

    public Context buildContextForTable(OMRSMetadataCollection metadataCollection, String assetId) throws InvalidParameterException, TypeErrorException, FunctionNotSupportedException, PropertyErrorException, EntityNotKnownException, TypeDefNotKnownException, PagingErrorException, EntityProxyOnlyException, UserNotAuthorizedException, RepositoryErrorException {
        Context context = new Context();
        context.setTable(this.getTableName(metadataCollection, assetId));
        context.setSchema("gaian");
        return context;
    }

    private Context getDatabaseContextForColumn(OMRSMetadataCollection metadataCollection, EntityDetail column) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException, TypeDefNotKnownException, TypeErrorException, FunctionNotSupportedException, PagingErrorException, PropertyErrorException {
        Context context = new Context();
        String columnName = this.getColumnName(column);
        context.setColumn(columnName);
        context.setTable(this.getTableName(metadataCollection, column.getGUID()));
        context.setSchema("gaian");
        return context;
    }

    private EntityDetail getEntity(OMRSMetadataCollection metadataCollection, String relationalColumnGuid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException {
        return metadataCollection.getEntityDetail("GovernanceEngine", relationalColumnGuid);
    }

    private String getColumnName(EntityDetail entityDetail) {
        return this.getStringProperty(entityDetail.getProperties(), "name");
    }

    private String getTableName(OMRSMetadataCollection metadataCollection, String relationalColumnGuid) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException, TypeDefNotKnownException, TypeErrorException, FunctionNotSupportedException, EntityNotKnownException, PagingErrorException, PropertyErrorException, EntityProxyOnlyException {
        String relationalTableTypeGUID = this.getRelationalTableTypeGUID(metadataCollection, relationalColumnGuid);
        if (this.relationalTableNames.containsKey(relationalTableTypeGUID)) {
            return this.relationalTableNames.get(relationalTableTypeGUID);
        }
        EntityDetail relationalTable = this.getRelationalTable(metadataCollection, relationalTableTypeGUID);
        if (relationalTable != null && relationalTable.getProperties() != null) {
            String tableName = this.getStringProperty(relationalTable.getProperties(), "name");
            this.relationalTableNames.put(relationalTableTypeGUID, tableName);
            return tableName;
        }
        return null;
    }

    private EntityDetail getRelationalTable(OMRSMetadataCollection metadataCollection, String relationalTableTypeGUID) throws InvalidParameterException, TypeErrorException, FunctionNotSupportedException, PropertyErrorException, EntityNotKnownException, TypeDefNotKnownException, PagingErrorException, EntityProxyOnlyException, UserNotAuthorizedException, RepositoryErrorException {
        return this.getEndOfRelationship(metadataCollection, relationalTableTypeGUID, "2d955049-e59b-45dd-8e62-cde1add59f9e");
    }

    private String getRelationalTableTypeGUID(OMRSMetadataCollection metadataCollection, String relationalColumnGuid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException, TypeErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, EntityProxyOnlyException {
        EntityDetail relationalTableType = this.getRelationalTableType(metadataCollection, relationalColumnGuid);
        if (relationalTableType == null) {
            return null;
        }
        return relationalTableType.getGUID();
    }

    private EntityDetail getRelationalTableType(OMRSMetadataCollection metadataCollection, String relationalColumnGuid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException, TypeErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, EntityProxyOnlyException {
        return this.getEndOfRelationship(metadataCollection, relationalColumnGuid, "86b176a2-015c-44a6-8106-54d5d69ba661");
    }

    private EntityDetail getEndOfRelationship(OMRSMetadataCollection metadataCollection, String relationalTableTypeGUID, String relationshipName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException, TypeErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, EntityProxyOnlyException {
        Relationship relationshipForEntity = this.getRelationshipForEntity(metadataCollection, relationalTableTypeGUID, relationshipName);
        if (relationshipForEntity == null) {
            return null;
        }
        String relationalTableGUID = this.getTheOtherEntityGuid(relationalTableTypeGUID, relationshipForEntity);
        if (relationalTableGUID == null) {
            return null;
        }
        return metadataCollection.getEntityDetail("GovernanceEngine", relationalTableGUID);
    }

    private Relationship getRelationshipForEntity(OMRSMetadataCollection metadataCollection, String relationalColumnGuid, String relationshipType) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException, TypeErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException {
        List<Relationship> relationshipsForEntity = this.getRelationshipsForEntity(relationalColumnGuid, relationshipType, metadataCollection);
        if (relationshipsForEntity != null && !relationshipsForEntity.isEmpty()) {
            return relationshipsForEntity.get(0);
        }
        return null;
    }

    private List<Relationship> getRelationshipsForEntity(String entityGUID, String relationshipTypeGUID, OMRSMetadataCollection metadataCollection) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException, TypeErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException {
        List<InstanceStatus> statusList = this.getActiveStatuses();
        return metadataCollection.getRelationshipsForEntity("GovernanceEngine", entityGUID, relationshipTypeGUID, 0, statusList, null, null, null, 0);
    }

    private String getTheOtherEntityGuid(String givenEntityId, Relationship relationship) {
        if (relationship.getEntityOneProxy().getGUID().equals(givenEntityId)) {
            return relationship.getEntityTwoProxy().getGUID();
        }
        return relationship.getEntityOneProxy().getGUID();
    }

    private List<InstanceStatus> getActiveStatuses() {
        ArrayList<InstanceStatus> statusList = new ArrayList<InstanceStatus>();
        statusList.add(InstanceStatus.ACTIVE);
        return statusList;
    }

    private String getStringProperty(InstanceProperties properties, String propertyName) {
        if (properties != null && properties.getPropertyValue(propertyName) instanceof PrimitivePropertyValue && ((PrimitivePropertyValue)properties.getPropertyValue(propertyName)).getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING) {
            return (String)((PrimitivePropertyValue)properties.getPropertyValue(propertyName)).getPrimitiveValue();
        }
        return "";
    }

    private boolean isRelationalColumn(EntityDetail entityDetail) {
        return entityDetail.getType().getTypeDefName().equals("RelationalColumn");
    }
}

