/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.util;

import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.ClassificationNotFoundException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.GovernanceEngineCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.GuidNotFoundException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.MetadataServerException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.TypeNotFoundException;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceEngineOMASAPIResponse;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;

public class ExceptionHandler {
    public void captureCheckedException(GovernanceEngineOMASAPIResponse response, GovernanceEngineCheckedExceptionBase error, String exceptionClassName) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
    }

    public void captureInvalidParameterException(GovernanceEngineOMASAPIResponse response, InvalidParameterException error) {
        this.captureCheckedException(response, (GovernanceEngineCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    public void captureMetadataServerException(GovernanceEngineOMASAPIResponse response, MetadataServerException error) {
        this.captureCheckedException(response, (GovernanceEngineCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    public void captureClassificationNotFoundException(GovernanceEngineOMASAPIResponse response, ClassificationNotFoundException error) {
        this.captureCheckedException(response, (GovernanceEngineCheckedExceptionBase)error, error.getClass().getName());
    }

    public void captureUserNotAuthorizedException(GovernanceEngineOMASAPIResponse response, UserNotAuthorizedException error) {
        this.captureCheckedException(response, (GovernanceEngineCheckedExceptionBase)error, error.getClass().getName());
    }

    public void captureTypeNotFoundException(GovernanceEngineOMASAPIResponse response, TypeNotFoundException error) {
        this.captureCheckedException(response, (GovernanceEngineCheckedExceptionBase)error, error.getClass().getName());
    }

    public void captureGuidNotFoundException(GovernanceEngineOMASAPIResponse response, GuidNotFoundException error) {
        this.captureCheckedException(response, (GovernanceEngineCheckedExceptionBase)error, error.getClass().getName());
    }

    public void capturePropertyServerException(GovernanceEngineOMASAPIResponse response, PropertyServerException error) {
        this.captureCheckedException(response, (GovernanceEngineCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    public void captureOMRSException(GovernanceEngineOMASAPIResponse response, OMRSCheckedExceptionBase error) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(error.getClass().getName());
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
    }
}

