/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.errorcode.GovernanceEngineErrorCode;
import org.odpi.openmetadata.accessservices.governanceengine.server.handlers.GovernedAssetHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OCFOMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class GovernanceEngineServicesInstance
extends OCFOMASServiceInstance {
    private GovernedAssetHandler governedAssetHandler;

    public GovernanceEngineServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, AuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        super(AccessServiceDescription.GOVERNANCE_ENGINE_OMAS.getAccessServiceFullName(), repositoryConnector, supportedZones, null, auditLog, localServerUserId, maxPageSize);
        String methodName = "new ServiceInstance";
        if (this.repositoryHandler != null) {
            this.governedAssetHandler = new GovernedAssetHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.errorHandler, supportedZones);
            if (this.securityVerifier != null) {
                this.governedAssetHandler.setSecurityVerifier(this.securityVerifier);
            }
        } else {
            GovernanceEngineErrorCode errorCode = GovernanceEngineErrorCode.OMRS_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"new ServiceInstance"});
            throw new NewInstanceException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public GovernedAssetHandler getGovernedAssetHandler() {
        return this.governedAssetHandler;
    }
}

