/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.api.ffdc.errorcode.GovernanceEngineAuditCode;
import org.odpi.openmetadata.accessservices.governanceengine.server.admin.GovernanceEngineServicesInstance;
import org.odpi.openmetadata.accessservices.governanceengine.server.listeners.GovernanceEngineOMRSTopicListener;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class GovernanceEngineAdmin
extends AccessServiceAdmin {
    private AuditLog auditLog;
    private GovernanceEngineServicesInstance instance;
    private String serverName;

    public void initialize(AccessServiceConfig accessServiceConfigurationProperties, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector enterpriseOMRSRepositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", GovernanceEngineAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        try {
            List supportedZones = this.extractSupportedZones(accessServiceConfigurationProperties.getAccessServiceOptions(), accessServiceConfigurationProperties.getAccessServiceName(), auditLog);
            this.instance = new GovernanceEngineServicesInstance(enterpriseOMRSRepositoryConnector, supportedZones, auditLog, serverUserName, enterpriseOMRSRepositoryConnector.getMaxPageSize());
            this.serverName = this.instance.getServerName();
            OpenMetadataTopicConnector outTopicConnector = null;
            if (accessServiceConfigurationProperties.getAccessServiceOutTopic() != null) {
                outTopicConnector = super.getOutTopicEventBusConnector(accessServiceConfigurationProperties.getAccessServiceOutTopic(), AccessServiceDescription.GOVERNANCE_ENGINE_OMAS.getAccessServiceFullName(), auditLog);
            }
            if (accessServiceConfigurationProperties.getAccessServiceOutTopic() != null) {
                GovernanceEngineOMRSTopicListener omrsTopicListener = new GovernanceEngineOMRSTopicListener(outTopicConnector, enterpriseOMRSRepositoryConnector.getRepositoryHelper(), enterpriseOMRSRepositoryConnector.getRepositoryValidator(), accessServiceConfigurationProperties.getAccessServiceName(), this.serverName, supportedZones, auditLog);
                super.registerWithEnterpriseTopic(accessServiceConfigurationProperties.getAccessServiceName(), this.serverName, enterpriseOMRSTopicConnector, (OMRSTopicListener)omrsTopicListener, auditLog);
            }
            auditLog.logMessage("initialize", GovernanceEngineAuditCode.SERVICE_INITIALIZED.getMessageDefinition());
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Throwable error) {
            auditLog.logException("initialize", GovernanceEngineAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage()}), error);
            super.throwUnexpectedInitializationException("initialize", AccessServiceDescription.GOVERNANCE_ENGINE_OMAS.getAccessServiceFullName(), error);
        }
    }

    public synchronized void shutdown() {
        String actionDescription = "shutdown";
        this.auditLog.logMessage("shutdown", GovernanceEngineAuditCode.SERVICE_TERMINATING.getMessageDefinition());
        if (this.instance != null) {
            this.instance.shutdown();
        }
        this.auditLog.logMessage("shutdown", GovernanceEngineAuditCode.SERVICE_SHUTDOWN.getMessageDefinition());
    }
}

