/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.governanceengine.api.model.Context;
import org.odpi.openmetadata.accessservices.governanceengine.api.model.GovernanceClassification;
import org.odpi.openmetadata.accessservices.governanceengine.api.model.GovernedAsset;
import org.odpi.openmetadata.accessservices.governanceengine.api.model.SoftwareServerCapability;
import org.odpi.openmetadata.accessservices.governanceengine.server.processor.ContextBuilder;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernedAssetHandler {
    private final String serviceName;
    private final String serverName;
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final RepositoryErrorHandler errorHandler;
    private OpenMetadataServerSecurityVerifier securityVerifier = new OpenMetadataServerSecurityVerifier();
    private List<String> supportedZones;
    private ContextBuilder contextBuilder;

    public GovernedAssetHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, RepositoryErrorHandler errorHandler, List<String> supportedZones) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.errorHandler = errorHandler;
        this.supportedZones = supportedZones;
        this.contextBuilder = new ContextBuilder(repositoryHandler, repositoryHelper);
    }

    public void setSecurityVerifier(OpenMetadataServerSecurityVerifier securityVerifier) {
        this.securityVerifier = securityVerifier;
    }

    public List<GovernedAsset> getGovernedAssets(String userId, List<String> entityTypes, Integer offset, Integer pageSize) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        String methodName = "getGovernedAssets";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        List<Object> response = new ArrayList<EntityDetail>();
        if (CollectionUtils.isEmpty(entityTypes)) {
            response = this.repositoryHandler.getEntitiesForClassificationType(userId, null, "SecurityTags", offset.intValue(), pageSize.intValue(), methodName);
        } else {
            for (String typeName : entityTypes) {
                TypeDef typeDefByName = this.repositoryHelper.getTypeDefByName(userId, typeName);
                if (typeDefByName == null || typeDefByName.getGUID() == null) continue;
                response.addAll(this.repositoryHandler.getEntitiesForClassificationType(userId, typeDefByName.getGUID(), "SecurityTags", offset.intValue(), pageSize.intValue(), methodName));
            }
        }
        return this.convertGovernedAssets(userId, response);
    }

    public GovernedAsset getGovernedAsset(String userId, String assedID) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernedAsset";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        EntityDetail entityDetailsByGUID = this.getEntityDetailsByGUID(userId, assedID, null);
        if (this.containsGovernedClassification(entityDetailsByGUID)) {
            return this.convertGovernedAsset(userId, entityDetailsByGUID);
        }
        return null;
    }

    public boolean containsGovernedClassification(EntityDetail entityDetail) {
        if (CollectionUtils.isEmpty((Collection)entityDetail.getClassifications())) {
            return false;
        }
        for (Classification classification : entityDetail.getClassifications()) {
            if (classification.getType() == null || classification.getType().getTypeDefName() == null || !this.isGovernedClassification(classification.getType().getTypeDefName())) continue;
            return true;
        }
        return false;
    }

    public boolean isSchemaElement(InstanceType entityType) {
        if (entityType == null) {
            return false;
        }
        return this.repositoryHelper.isTypeOf("GovernanceEngine", entityType.getTypeDefName(), "SchemaAttribute");
    }

    public String createSoftwareServerCapability(String userId, SoftwareServerCapability softwareServerCapability) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String methodName = "createSoftwareServerCapability";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        InstanceProperties initialProperties = this.getSoftwareServerCapabilityProperties(softwareServerCapability);
        return this.repositoryHandler.createEntity(userId, "fe30a033-8f86-4d17-8986-e6166fa24177", "SoftwareServerCapability", initialProperties, Collections.emptyList(), InstanceStatus.ACTIVE, methodName);
    }

    public SoftwareServerCapability getSoftwareServerCapabilityByGUID(String userId, String guid) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getSoftwareServerCapabilityByGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        EntityDetail entityDetailsByGUID = this.getEntityDetailsByGUID(userId, guid, "SoftwareServerCapability");
        if (entityDetailsByGUID == null) {
            return null;
        }
        return this.convertSoftwareServerCapability(entityDetailsByGUID);
    }

    public GovernedAsset convertGovernedAsset(String userID, EntityDetail entity) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "convertGovernedAsset";
        GovernedAsset governedAsset = new GovernedAsset();
        governedAsset.setGuid(entity.getGUID());
        governedAsset.setType(entity.getType().getTypeDefName());
        governedAsset.setFullQualifiedName(this.repositoryHelper.getStringProperty("GovernanceEngine", "qualifiedName", entity.getProperties(), methodName));
        governedAsset.setName(this.repositoryHelper.getStringProperty("GovernanceEngine", "displayName", entity.getProperties(), methodName));
        governedAsset.setContext(this.buildContext(userID, entity));
        if (entity.getClassifications() != null && !entity.getClassifications().isEmpty()) {
            governedAsset.setAssignedGovernanceClassification(this.getGovernanceClassification(entity.getClassifications()));
        }
        return governedAsset;
    }

    private GovernanceClassification getGovernanceClassification(List<Classification> allClassifications) {
        Optional<Classification> classification = this.filterGovernedClassification(allClassifications);
        return classification.map(this::getGovernanceClassification).orElse(null);
    }

    private GovernanceClassification getGovernanceClassification(Classification classification) {
        String methodName = "getInstanceProperties";
        GovernanceClassification governanceClassification = new GovernanceClassification();
        governanceClassification.setName(classification.getName());
        InstanceProperties properties = classification.getProperties();
        if (properties != null) {
            governanceClassification.setSecurityLabels(this.repositoryHelper.getStringArrayProperty("GovernanceEngine", "securityLabels", properties, methodName));
            governanceClassification.setSecurityProperties(this.repositoryHelper.getStringMapFromProperty("GovernanceEngine", "securityProperties", properties, methodName));
        }
        return governanceClassification;
    }

    private Optional<Classification> filterGovernedClassification(List<Classification> classifications) {
        return classifications.stream().filter(c -> this.isGovernedClassification(c.getType().getTypeDefName())).findAny();
    }

    private boolean isGovernedClassification(String classificationName) {
        return "SecurityTags".equals(classificationName);
    }

    private List<GovernedAsset> convertGovernedAssets(String userID, List<EntityDetail> entityDetails) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (CollectionUtils.isEmpty(entityDetails)) {
            return Collections.emptyList();
        }
        ArrayList<GovernedAsset> result = new ArrayList<GovernedAsset>();
        for (EntityDetail entityDetail : entityDetails) {
            result.add(this.convertGovernedAsset(userID, entityDetail));
        }
        return result;
    }

    private Context buildContext(String userID, EntityDetail entity) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        switch (entity.getType().getTypeDefName()) {
            case "RelationalColumn": {
                return this.contextBuilder.buildContextForColumn(userID, entity.getGUID());
            }
            case "RelationalTable": {
                return this.contextBuilder.buildContextForTable(userID, entity.getGUID());
            }
        }
        return null;
    }

    private EntityDetail getEntityDetailsByGUID(String userId, String guid, String entityType) throws PropertyServerException, UserNotAuthorizedException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        String methodName = "getEntityDetailsByGUID";
        return this.repositoryHandler.getEntityByGUID(userId, guid, "guid", entityType, methodName);
    }

    private SoftwareServerCapability convertSoftwareServerCapability(EntityDetail entityDetail) {
        InstanceProperties properties = entityDetail.getProperties();
        SoftwareServerCapability softwareServerCapability = new SoftwareServerCapability();
        softwareServerCapability.setGUID(entityDetail.getGUID());
        softwareServerCapability.setOpenTypeGUID(entityDetail.getType().getTypeDefName());
        softwareServerCapability.setName(this.getStringProperty(properties, "name", this.repositoryHelper));
        softwareServerCapability.setDescription(this.getStringProperty(properties, "description", this.repositoryHelper));
        softwareServerCapability.setType(this.getStringProperty(properties, "type", this.repositoryHelper));
        softwareServerCapability.setPatchLevel(this.getStringProperty(properties, "patchLevel", this.repositoryHelper));
        softwareServerCapability.setVersion(this.getStringProperty(properties, "version", this.repositoryHelper));
        softwareServerCapability.setSource(this.getStringProperty(properties, "source", this.repositoryHelper));
        return softwareServerCapability;
    }

    private InstanceProperties getSoftwareServerCapabilityProperties(SoftwareServerCapability softwareServerCapability) {
        InstanceProperties properties = new InstanceProperties();
        this.addStringProperty(softwareServerCapability.getName(), "name", properties, this.repositoryHelper);
        this.addStringProperty(softwareServerCapability.getDescription(), "description", properties, this.repositoryHelper);
        this.addStringProperty(softwareServerCapability.getType(), "type", properties, this.repositoryHelper);
        this.addStringProperty(softwareServerCapability.getVersion(), "version", properties, this.repositoryHelper);
        this.addStringProperty(softwareServerCapability.getPatchLevel(), "patchLevel", properties, this.repositoryHelper);
        this.addStringProperty(softwareServerCapability.getSource(), "source", properties, this.repositoryHelper);
        return properties;
    }

    private void addStringProperty(String propertyValue, String propertyName, InstanceProperties properties, OMRSRepositoryHelper repositoryHelper) {
        String methodName = "addStringProperty";
        if (propertyValue != null) {
            repositoryHelper.addStringPropertyToInstance("GovernanceEngine", properties, propertyName, propertyValue, methodName);
        }
    }

    private String getStringProperty(InstanceProperties properties, String propertyName, OMRSRepositoryHelper repositoryHelper) {
        return repositoryHelper.getStringProperty("GovernanceEngine", propertyName, properties, "getStringProperty");
    }
}

