/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server;

import org.odpi.openmetadata.accessservices.governanceengine.ffdc.GovernanceEngineAuditCode;
import org.odpi.openmetadata.accessservices.governanceengine.handlers.MetadataElementHandler;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceActionElement;
import org.odpi.openmetadata.accessservices.governanceengine.rest.ActionTargetStatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.CompletionStatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.FindRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionProcessRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.IncidentReportRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NewClassificationRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NewMetadataElementRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NewRelatedElementsRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.OpenMetadataElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.OpenMetadataElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.RelatedMetadataElementListResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.RelatedMetadataElementsListResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.StatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateEffectivityDatesRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdatePropertiesRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateStatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.slf4j.LoggerFactory;

public class GovernanceEngineRESTServices {
    private static GovernanceEngineInstanceHandler instanceHandler = new GovernanceEngineInstanceHandler();
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GovernanceEngineRESTServices.class), instanceHandler.getServiceName());

    public ConnectionResponse getOutTopicConnection(String serverName, String userId, String callerId) {
        String methodName = "getOutTopicConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getOutTopicConnection");
        ConnectionResponse response = new ConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getOutTopicConnection");
            response.setConnection(instanceHandler.getOutTopicConnection(userId, serverName, "getOutTopicConnection", callerId));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getOutTopicConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse logAssetAuditMessage(String serverName, String userId, String assetGUID, String governanceService, String message) {
        String methodName = "logAssetAuditMessage";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "logAssetAuditMessage");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "logAssetAuditMessage");
            auditLog.logMessage("logAssetAuditMessage", GovernanceEngineAuditCode.ASSET_AUDIT_LOG.getMessageDefinition(new String[]{assetGUID, governanceService, message}));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "logAssetAuditMessage", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataElementResponse getMetadataElementByGUID(String serverName, String userId, String elementGUID) {
        String methodName = "getMetadataElementByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataElementByGUID");
        AuditLog auditLog = null;
        OpenMetadataElementResponse response = new OpenMetadataElementResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementByGUID");
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getMetadataElementByGUID");
            response.setElement(handler.getMetadataElementByGUID(userId, elementGUID, "getMetadataElementByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getMetadataElementByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataElementResponse getMetadataElementByUniqueName(String serverName, String userId, NameRequestBody requestBody) {
        String methodName = "getMetadataElementByUniqueName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataElementByUniqueName");
        AuditLog auditLog = null;
        OpenMetadataElementResponse response = new OpenMetadataElementResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementByUniqueName");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getMetadataElementByUniqueName");
                response.setElement(handler.getMetadataElementByUniqueName(userId, requestBody.getName(), requestBody.getNameParameterName(), requestBody.getNamePropertyName(), "getMetadataElementByUniqueName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getMetadataElementByUniqueName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getMetadataElementByUniqueName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse getMetadataElementGUIDByUniqueName(String serverName, String userId, NameRequestBody requestBody) {
        String methodName = "getMetadataElementGUIDByUniqueName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataElementGUIDByUniqueName");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementGUIDByUniqueName");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getMetadataElementGUIDByUniqueName");
                response.setGUID(handler.getMetadataElementGUIDByUniqueName(userId, requestBody.getName(), requestBody.getNameParameterName(), requestBody.getNamePropertyName(), "getMetadataElementGUIDByUniqueName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getMetadataElementGUIDByUniqueName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getMetadataElementGUIDByUniqueName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataElementsResponse findMetadataElementsWithString(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findMetadataElementsWithString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findMetadataElementsWithString");
        AuditLog auditLog = null;
        OpenMetadataElementsResponse response = new OpenMetadataElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMetadataElementsWithString");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "findMetadataElementsWithString");
                response.setElementList(handler.findMetadataElementsWithString(userId, requestBody.getSearchString(), startFrom, pageSize, "findMetadataElementsWithString"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findMetadataElementsWithString", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findMetadataElementsWithString", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedMetadataElementListResponse getRelatedMetadataElements(String serverName, String userId, String elementGUID, String relationshipTypeName, int startingAtEnd, int startFrom, int pageSize) {
        String methodName = "getRelatedMetadataElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRelatedMetadataElements");
        AuditLog auditLog = null;
        RelatedMetadataElementListResponse response = new RelatedMetadataElementListResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelatedMetadataElements");
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "getRelatedMetadataElements");
            response.setElementList(handler.getRelatedMetadataElements(userId, elementGUID, startingAtEnd, relationshipTypeName, startFrom, pageSize, "getRelatedMetadataElements"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getRelatedMetadataElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OpenMetadataElementsResponse findMetadataElements(String serverName, String userId, int startFrom, int pageSize, FindRequestBody requestBody) {
        String methodName = "findMetadataElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findMetadataElements");
        AuditLog auditLog = null;
        OpenMetadataElementsResponse response = new OpenMetadataElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMetadataElements");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "findMetadataElements");
                response.setElementList(handler.findMetadataElements(userId, requestBody.getMetadataElementTypeName(), requestBody.getMetadataElementSubtypeName(), requestBody.getSearchProperties(), requestBody.getLimitResultsByStatus(), requestBody.getMatchClassifications(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), startFrom, pageSize, "findMetadataElements"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findMetadataElements", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findMetadataElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedMetadataElementsListResponse findRelationshipsBetweenMetadataElements(String serverName, String userId, int startFrom, int pageSize, FindRequestBody requestBody) {
        String methodName = "findRelationshipsBetweenMetadataElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findRelationshipsBetweenMetadataElements");
        AuditLog auditLog = null;
        RelatedMetadataElementsListResponse response = new RelatedMetadataElementsListResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findRelationshipsBetweenMetadataElements");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "findRelationshipsBetweenMetadataElements");
                response.setElementList(handler.findRelationshipsBetweenMetadataElements(userId, requestBody.getMetadataElementTypeName(), requestBody.getSearchProperties(), requestBody.getSequencingProperty(), requestBody.getSequencingOrder(), startFrom, pageSize, "findRelationshipsBetweenMetadataElements"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findRelationshipsBetweenMetadataElements", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findRelationshipsBetweenMetadataElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createMetadataElementInStore(String serverName, String userId, NewMetadataElementRequestBody requestBody) {
        String methodName = "createMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createMetadataElementInStore");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "createMetadataElementInStore");
                response.setGUID(handler.createMetadataElementInStore(userId, requestBody.getTypeName(), requestBody.getInitialStatus(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getProperties(), requestBody.getTemplateGUID(), "createMetadataElementInStore"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateMetadataElementInStore(String serverName, String userId, String metadataElementGUID, UpdatePropertiesRequestBody requestBody) {
        String methodName = "updateMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateMetadataElementInStore");
                handler.updateMetadataElementInStore(userId, metadataElementGUID, requestBody.getReplaceProperties(), requestBody.getProperties(), "updateMetadataElementInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateMetadataElementStatusInStore(String serverName, String userId, String metadataElementGUID, UpdateStatusRequestBody requestBody) {
        String methodName = "updateMetadataElementStatusInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateMetadataElementStatusInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateMetadataElementStatusInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateMetadataElementStatusInStore");
                handler.updateMetadataElementStatusInStore(userId, metadataElementGUID, requestBody.getNewStatus(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), "updateMetadataElementStatusInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateMetadataElementStatusInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateMetadataElementStatusInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteMetadataElementInStore(String serverName, String userId, String metadataElementGUID, NullRequestBody requestBody) {
        String methodName = "deleteMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "deleteMetadataElementInStore");
                handler.deleteMetadataElementInStore(userId, metadataElementGUID, "deleteMetadataElementInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "deleteMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse classifyMetadataElementInStore(String serverName, String userId, String metadataElementGUID, String classificationName, NewClassificationRequestBody requestBody) {
        String methodName = "classifyMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "classifyMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "classifyMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "classifyMetadataElementInStore");
                handler.classifyMetadataElementInStore(userId, metadataElementGUID, classificationName, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getProperties(), "classifyMetadataElementInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "classifyMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "classifyMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse reclassifyMetadataElementInStore(String serverName, String userId, String metadataElementGUID, String classificationName, UpdatePropertiesRequestBody requestBody) {
        String methodName = "reclassifyMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "reclassifyMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "reclassifyMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "reclassifyMetadataElementInStore");
                handler.reclassifyMetadataElementInStore(userId, metadataElementGUID, classificationName, requestBody.getReplaceProperties(), requestBody.getProperties(), "reclassifyMetadataElementInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "reclassifyMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "reclassifyMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateClassificationStatusInStore(String serverName, String userId, String metadataElementGUID, String classificationName, UpdateEffectivityDatesRequestBody requestBody) {
        String methodName = "updateClassificationStatusInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateClassificationStatusInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateClassificationStatusInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateClassificationStatusInStore");
                handler.updateClassificationStatusInStore(userId, metadataElementGUID, classificationName, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), "updateClassificationStatusInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateClassificationStatusInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateClassificationStatusInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unclassifyMetadataElementInStore(String serverName, String userId, String metadataElementGUID, String classificationName, NullRequestBody requestBody) {
        String methodName = "unclassifyMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unclassifyMetadataElementInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unclassifyMetadataElementInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "unclassifyMetadataElementInStore");
                handler.unclassifyMetadataElementInStore(userId, metadataElementGUID, classificationName, "unclassifyMetadataElementInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "unclassifyMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "unclassifyMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createRelatedElementsInStore(String serverName, String userId, NewRelatedElementsRequestBody requestBody) {
        String methodName = "createRelatedElementsInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createRelatedElementsInStore");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createRelatedElementsInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "createRelatedElementsInStore");
                response.setGUID(handler.createRelatedElementsInStore(userId, requestBody.getTypeName(), requestBody.getMetadataElement1GUID(), requestBody.getMetadataElement2GUID(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getProperties(), "createRelatedElementsInStore"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createRelatedElementsInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createRelatedElementsInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateRelatedElementsInStore(String serverName, String userId, String relationshipGUID, UpdatePropertiesRequestBody requestBody) {
        String methodName = "updateRelatedElementsInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateRelatedElementsInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateRelatedElementsInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateRelatedElementsInStore");
                handler.updateRelatedElementsInStore(userId, relationshipGUID, requestBody.getReplaceProperties(), requestBody.getProperties(), "updateRelatedElementsInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateRelatedElementsInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateRelatedElementsInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateRelatedElementsStatusInStore(String serverName, String userId, String relationshipGUID, UpdateEffectivityDatesRequestBody requestBody) {
        String methodName = "updateRelatedElementsStatusInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateRelatedElementsStatusInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateRelatedElementsStatusInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "updateRelatedElementsStatusInStore");
                handler.updateRelatedElementsStatusInStore(userId, relationshipGUID, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), "updateRelatedElementsStatusInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateRelatedElementsStatusInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateRelatedElementsStatusInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteRelatedElementsInStore(String serverName, String userId, String relationshipGUID, NullRequestBody requestBody) {
        String methodName = "deleteRelatedElementsInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteRelatedElementsInStore");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteRelatedElementsInStore");
            if (requestBody != null) {
                MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "deleteRelatedElementsInStore");
                handler.deleteRelatedElementsInStore(userId, relationshipGUID, "deleteRelatedElementsInStore");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteRelatedElementsInStore", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "deleteRelatedElementsInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateActionTargetStatus(String serverName, String userId, ActionTargetStatusRequestBody requestBody) {
        String methodName = "updateActionTargetStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateActionTargetStatus");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateActionTargetStatus");
            if (requestBody != null) {
                GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "updateActionTargetStatus");
                int statusOrdinal = GovernanceActionStatus.ACTIONED.getOpenTypeOrdinal();
                if (requestBody.getStatus() != null) {
                    statusOrdinal = requestBody.getStatus().getOpenTypeOrdinal();
                }
                handler.updateActionTargetStatus(userId, requestBody.getActionTargetGUID(), statusOrdinal, requestBody.getStartDate(), requestBody.getCompletionDate(), "updateActionTargetStatus");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateActionTargetStatus", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateActionTargetStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceActionStatus(String serverName, String userId, String governanceActionGUID, StatusRequestBody requestBody) {
        String methodName = "updateGovernanceActionStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceActionStatus");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceActionStatus");
            if (requestBody != null) {
                GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "updateGovernanceActionStatus");
                int statusOrdinal = GovernanceActionStatus.ACTIONED.getOpenTypeOrdinal();
                if (requestBody.getStatus() != null) {
                    statusOrdinal = requestBody.getStatus().getOpenTypeOrdinal();
                }
                handler.updateGovernanceActionStatus(userId, governanceActionGUID, statusOrdinal, "updateGovernanceActionStatus");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceActionStatus", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateGovernanceActionStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse recordCompletionStatus(String serverName, String userId, String governanceActionGUID, CompletionStatusRequestBody requestBody) {
        String methodName = "recordCompletionStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "recordCompletionStatus");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "recordCompletionStatus");
            if (requestBody != null) {
                GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "recordCompletionStatus");
                int statusOrdinal = GovernanceActionStatus.ACTIONED.getOpenTypeOrdinal();
                if (requestBody.getStatus() != null) {
                    statusOrdinal = requestBody.getStatus().getOpenTypeOrdinal();
                }
                handler.recordCompletionStatus(userId, governanceActionGUID, statusOrdinal, requestBody.getRequestParameters(), requestBody.getOutputGuards(), requestBody.getNewActionTargets(), "recordCompletionStatus");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "recordCompletionStatus", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "recordCompletionStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse initiateGovernanceAction(String serverName, String userId, String governanceEngineName, GovernanceActionRequestBody requestBody) {
        String methodName = "initiateGovernanceAction";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "initiateGovernanceAction");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "initiateGovernanceAction");
            if (requestBody != null) {
                GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "initiateGovernanceAction");
                response.setGUID(handler.initiateGovernanceAction(userId, requestBody.getQualifiedName(), requestBody.getDomainIdentifier(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getRequestSourceGUIDs(), requestBody.getActionTargets(), null, requestBody.getReceivedGuards(), requestBody.getStartTime(), governanceEngineName, requestBody.getRequestType(), requestBody.getRequestParameters(), null, null, "initiateGovernanceAction", requestBody.getOriginatorServiceName(), requestBody.getOriginatorEngineName(), "initiateGovernanceAction"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "initiateGovernanceAction", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "initiateGovernanceAction", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse initiateGovernanceActionProcess(String serverName, String userId, GovernanceActionProcessRequestBody requestBody) {
        String methodName = "initiateGovernanceActionProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "initiateGovernanceActionProcess");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "initiateGovernanceActionProcess");
            if (requestBody != null) {
                GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "initiateGovernanceActionProcess");
                response.setGUID(handler.initiateGovernanceActionProcess(userId, requestBody.getProcessQualifiedName(), requestBody.getRequestSourceGUIDs(), requestBody.getActionTargets(), requestBody.getRequestParameters(), requestBody.getStartTime(), requestBody.getOriginatorServiceName(), requestBody.getOriginatorEngineName(), "initiateGovernanceActionProcess"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "initiateGovernanceActionProcess", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "initiateGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createIncidentReport(String serverName, String userId, IncidentReportRequestBody requestBody) {
        String methodName = "createIncidentReport";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createIncidentReport");
        Object auditLog = null;
        GUIDResponse response = new GUIDResponse();
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionElementResponse getGovernanceAction(String serverName, String userId, String governanceActionGUID) {
        String methodName = "getGovernanceAction";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceAction");
        AuditLog auditLog = null;
        GovernanceActionElementResponse response = new GovernanceActionElementResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceAction");
            GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "getGovernanceAction");
            response.setElement((GovernanceActionElement)handler.getGovernanceAction(userId, governanceActionGUID, "getGovernanceAction"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getGovernanceAction", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse claimGovernanceAction(String serverName, String userId, String governanceActionGUID, NullRequestBody requestBody) {
        String methodName = "claimGovernanceAction";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "claimGovernanceAction");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "claimGovernanceAction");
            GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "claimGovernanceAction");
            handler.claimGovernanceAction(userId, governanceActionGUID, "claimGovernanceAction");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "claimGovernanceAction", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionElementsResponse getGovernanceActions(String serverName, String userId, int startFrom, int pageSize) {
        String methodName = "getGovernanceActions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActions");
        AuditLog auditLog = null;
        GovernanceActionElementsResponse response = new GovernanceActionElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActions");
            GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "getGovernanceActions");
            response.setElements(handler.getGovernanceActions(userId, startFrom, pageSize, "getGovernanceActions"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getGovernanceActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionElementsResponse getActiveGovernanceActions(String serverName, String userId, int startFrom, int pageSize) {
        String methodName = "getActiveGovernanceActions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActiveGovernanceActions");
        AuditLog auditLog = null;
        GovernanceActionElementsResponse response = new GovernanceActionElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActiveGovernanceActions");
            GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "getActiveGovernanceActions");
            response.setElements(handler.getActiveGovernanceActions(userId, startFrom, pageSize, "getActiveGovernanceActions"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getActiveGovernanceActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionElementsResponse getActiveClaimedGovernanceActions(String serverName, String userId, String governanceEngineGUID, int startFrom, int pageSize) {
        String methodName = "getActiveClaimedGovernanceActions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActiveClaimedGovernanceActions");
        AuditLog auditLog = null;
        GovernanceActionElementsResponse response = new GovernanceActionElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActiveClaimedGovernanceActions");
            GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "getActiveClaimedGovernanceActions");
            response.setElements(handler.getActiveClaimedGovernanceActions(userId, governanceEngineGUID, startFrom, pageSize, "getActiveClaimedGovernanceActions"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getActiveClaimedGovernanceActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

