/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.services;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.api.model.GovernedAssetListResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.model.GovernedAssetResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.model.SoftwareServerCapabilityRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.api.model.SoftwareServerCapabilityResponse;
import org.odpi.openmetadata.accessservices.governanceengine.server.admin.GovernanceEngineInstanceHandler;
import org.odpi.openmetadata.accessservices.governanceengine.server.handlers.GovernedAssetHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GovernanceEngineRESTServices {
    private static GovernanceEngineInstanceHandler instanceHandler = new GovernanceEngineInstanceHandler();
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GovernedAssetListResponse getGovernedAssets(String serverName, String userId, List<String> entityTypes, Integer offset, Integer pageSize) {
        String methodName = "getGovernedAssets";
        GovernedAssetListResponse response = new GovernedAssetListResponse();
        try {
            GovernedAssetHandler governedAssetHandler = instanceHandler.getGovernedAssetHandler(userId, serverName, methodName);
            response.setGovernedAssetList(governedAssetHandler.getGovernedAssets(userId, entityTypes, offset, pageSize));
        }
        catch (InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, e);
        }
        return response;
    }

    public GovernedAssetResponse getGovernedAsset(String serverName, String userId, String assetGuid) {
        String methodName = "getGovernedAsset";
        GovernedAssetResponse response = new GovernedAssetResponse();
        try {
            GovernedAssetHandler governedAssetHandler = instanceHandler.getGovernedAssetHandler(userId, serverName, methodName);
            response.setAsset(governedAssetHandler.getGovernedAsset(userId, assetGuid));
        }
        catch (InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, e);
        }
        return response;
    }

    public StringResponse createSoftwareServer(String serverName, String userId, SoftwareServerCapabilityRequestBody requestBody) {
        String methodName = "createSoftwareServer";
        StringResponse response = new StringResponse();
        try {
            GovernedAssetHandler governedAssetHandler = instanceHandler.getGovernedAssetHandler(userId, serverName, methodName);
            response.setResultString(governedAssetHandler.createSoftwareServerCapability(userId, requestBody.getSoftwareServerCapability()));
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, e);
        }
        catch (InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, e);
        }
        return response;
    }

    public SoftwareServerCapabilityResponse getSoftwareServerByGUID(String serverName, String userId, String guid) {
        String methodName = "getSoftwareServerByGUID";
        SoftwareServerCapabilityResponse response = new SoftwareServerCapabilityResponse();
        try {
            GovernedAssetHandler governedAssetHandler = instanceHandler.getGovernedAssetHandler(userId, serverName, methodName);
            response.setServerCapability(governedAssetHandler.getSoftwareServerCapabilityByGUID(userId, guid));
        }
        catch (InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, e);
        }
        return response;
    }
}

